<?php
// +----------------------------------------------------------------------
// | 文海代码生成器
// +----------------------------------------------------------------------
// | Copyright (c) 2021 https://www.kaifashu.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 开发树
// +----------------------------------------------------------------------

namespace app\admin\controller;
use app\common\model\Document as DocumentModel;
use app\common\model\DocumentCategory as DocumentCategoryModel;
use app\common\model\DocumentArticle as DocumentArticleModel;
use app\common\validate\Document as DocumentValidate;

/**
 *文章内容
 */
class Document extends Auth
{
    /**
     * 列表
     */
    public function index(){

        $param=[
            'title'=>'',
            'document_category_id'=>''
        ];
        $param=$this->initParam($param);
        $map[] =['status','>',-1];
        if($param['title']!=''){
            $map[]=['title','like',"%".$param['title']."%"];
        }
        if($param['document_category_id']!=''){
            $map[]=['category_id','=',$param['document_category_id']];
        }
        $model=new DocumentModel();
        $lists=$model->where($map)
            -> order('create_time desc,sort asc')
            ->paginate($this->config['LIST_ROWS'],false,['query' => $this->getRouteQuery()]);
        $categoryModel=new DocumentCategoryModel();
        $DocumentCategoryList=$categoryModel->where('status','>',-1)->select()->toArray();
        $DocumentCategoryList=list_to_tree($DocumentCategoryList);
        $DocumentCategoryList=list_to_char_tree($DocumentCategoryList);
        $this->assign('DocumentCategoryList',$DocumentCategoryList);
        $this->assign('lists',$lists);
        $this->assign('param',$param);
        return $this -> fetch();
    }
    /**
     * 新增
     */
    public function add(){
        $thisModel=new DocumentModel();
        if($this->request->isGet()){
            $IsrecommendList=$thisModel->isrecommendList;
            $this->assign('IsrecommendList',$IsrecommendList);
            $IstopList=$thisModel->istopList;
            $this->assign('IstopList',$IstopList);
            $IsShowList=$thisModel->displayList;
            $this->assign('IsShowList',$IsShowList);
            $model=new DocumentCategoryModel();
            $DocumentCategoryList=$model->where('status<>-1')->select()->toArray();
            $DocumentCategoryList=list_to_tree($DocumentCategoryList);
            $DocumentCategoryList=list_to_char_tree($DocumentCategoryList);
            $this->assign('DocumentCategoryList',$DocumentCategoryList);
            $this->assign('member',$this->member);

            //获取传递的可能存在的文章分类id
            $cid=input('cid');
            $this-> assign('cid', $cid);
            return $this -> fetch();
        }
        $documentArticleModel=new DocumentArticleModel();
        $postData=$this->request->param();
        //验证
        $documentValidate = new DocumentValidate();
        if (!$documentValidate -> check($postData)) {
            $this -> error($documentValidate -> getError());
        }
        $postData['uid']=$this->member->id;
        $re=$documentArticleModel->add_data($postData);
        if($re){
            $this->success('新增成功！','index?document_category_id='.input('cid'));
        }
        else{
            $this->error('新增失败！','index');
        }
    }
    /**
     * 编辑
     */
    public function edit(){
        $thisModel=new DocumentModel();
        if($this->request->isGet()){
            $IsrecommendList=$thisModel->isrecommendList;
            $this->assign('IsrecommendList',$IsrecommendList);
            $IstopList=$thisModel->istopList;
            $this->assign('IstopList',$IstopList);
            $IsShowList=$thisModel->displayList;
            $this->assign('IsShowList',$IsShowList);
            $categoryModel=new DocumentCategoryModel();
            $DocumentCategoryList=$categoryModel->where('status','>',-1)->select()->toArray();
            $DocumentCategoryList=list_to_tree($DocumentCategoryList);
            $DocumentCategoryList=list_to_char_tree($DocumentCategoryList);
            $this->assign('DocumentCategoryList',$DocumentCategoryList);
            $id=input('id');
            $info=$thisModel->get($id);
            $this->assign('info',$info);
            $documentArticleModel=new DocumentArticleModel();
            $infos=$documentArticleModel->get($id);
            $this->assign('infos',$infos);

            $this-> assign('cid', $info['category_id']);
            return $this -> fetch();
        }
        $paramData=$this->request->param();
        //验证
        $documentValidate = new DocumentValidate();
        if (!$documentValidate -> check($paramData)) {
            $this -> error($documentValidate -> getError());
        }
        $documentArticleModel=new DocumentArticleModel();
        $paramData['uid']=$this->member->id;
        $re=$documentArticleModel->edit_data($paramData);
        if($re){
            $this->success('编辑成功！','index?document_category_id='.input('cid'));
        }
        else{
            $this->error('编辑失败！');
        }
    }
    /**
     * 删除
     */
    public function del(){
        $id=$this->request->param('ids/a');
        $thisModel=new DocumentModel();
        //伪删除
        $where[] =['id','in',$id];
        $re=$thisModel->save([
            'status'  => -1
        ],$where);
        if($re){
            $this->success('删除成功！');
        }
        else{
            $this->error($thisModel->getError());
        }
    }
    /**
     * 排序
     */
    public function sort(){
        if ($this->request->isPost()){
            $data['id']=input('id/d');
            $data['sort']=input('sort');
            $thisModel=new DocumentModel();
            //            验证
            $documentValidate = new DocumentValidate();
            if (!$documentValidate -> scene('sort') -> check($data)) {
                $this -> error($documentValidate -> getError());
            }
            $re=$thisModel->edit($data);
            if($re){
                $this->success('操作成功！');
            }else{
                $this->error($thisModel->getError());
            }
        }
    }

    /**
     * 修改状态
     */
    public function enable(){
        if ($this->request->isPost()){
            $data['id']=input('id/d');
            $data['display']=input('val/d');
            $thisModel=new DocumentModel();
            $res=$thisModel->edit($data);
            if($res){
                if ($data['display'] == 1) {
                    //隐藏
                    $setDisplay = "document_display_xian";
                }
                if ($data['display'] == 0) {
                    //显示
                    $setDisplay = "document_display_yin";
                }
                $this->success('操作成功！');
            }else{
                $this->error($thisModel->getError());
            }
        }
    }

}