<?php
// +----------------------------------------------------------------------
// | hulacwms 3.0 呼啦企业网站管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2021 https://www.kaifashu.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 开发树
// +----------------------------------------------------------------------

namespace app\admin\controller;
use think\App;
use think\Controller;
use app\common\model\Config as ConfigModel;

class Base extends Controller
{
    /**
     * @var 模块配置
     */
    protected $config;

    public function __construct(App $app = null)
    {
        // URL兼容模式
        \think\facade\Url::root('?s=');
        parent::__construct($app);
    }
    /**
     * 模块初始化
     */
    protected function initialize(){
        //加载当前模块配置
        $configModel=new ConfigModel();
        $this->config=$configModel->load($this->request->module());
        hook('adminInit',isset($this->member)?$this->member:false);
    }

    /**
     * 退出登录
     */
    public function logout(){
        session('UID',null);
    }

    /**
     * 判断是否已登录
     * @return mixed 管理员id
     */
    public function isLogin(){
        $uid= session('UID');
        if(!$uid){
            $this->error('请登录！','Admin/login');
        }
        return $uid;
    }
	
	/**
     * 如果在非第一页没有数据时，跳转到最后一页
     */
    public function ifPageNoData($lists){
        $currentPage=$lists->currentPage();
		$page=input('page/d');
		$page=$page?$page:1;
		if($currentPage!=$page){
			//page是url传递的
			//$currentPage是程序生成的。超出数据分页数，$currentPage为最后一页页码
			$currentUrl=request()->url();
			$newUrl=preg_replace('/([\?\&])page=\d+/','$1'."page=$currentPage",$currentUrl);
			header("Location: $newUrl");
    		exit();
		}
    }
	
	/**
     * 获得当前页面的referer
     */
    public function getPageReferer(){
        $referer=cookie('PAGE_REFERER');
		cookie('PAGE_REFERER',null);
		return $referer;
    }
	
	/**
     * 存储当前页面的referer
     */
    public function savePageRefererToCookie(){
        $referer=$this->request->header('referer');
		cookie('PAGE_REFERER',$referer);
    }

    /**
     * 获得当前路由及参数列表
     * @return mixed
     */
    public function getRouteQuery(){
        $queryArr=$this->request->param();
        $queryArr['s']=$this->request->pathinfo();
        return $queryArr;
    }

    /**
     * 初始化请求参数
     * @param $param 默认参数值
     * @return array
     */
    public function initParam($param){
        $get=input();
        return array_merge($param,$get);
    }
}
