<?php
// +----------------------------------------------------------------------
// | hulacwms 3.0 呼啦企业网站管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2021 https://www.kaifashu.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 开发树
// +----------------------------------------------------------------------

namespace app\admin\controller;
use app\common\model\AdminMenu as AdminMenuModel;
use app\common\validate\AdminMenu as AdminMenuValidate;

/**
 *
 */
class AdminMenu extends Auth
{
    /**
     * 列表
     */
    public function index($pid=0){
        $model=new AdminMenuModel();
        $map[]=['pid','=',$pid];
        $lists=$model->where($map)->order('sort asc')->select();

        if($pid!=0){
            $topMenu=$model->get($pid);
        }
        else{
            $topMenu=['pid'=>-1,'title'=>'顶级菜单'];
        }
        $this->assign('topMenu', $topMenu);
        $this->assign('lists',$lists);
        $this->assign('pid',$pid);
        return $this -> fetch();
    }
    /**
     * 新增
     */
    public function add($pid){
        if($this->request->isGet()){
            $this->assign('pid',$pid);
            $lists=AdminMenuModel::where('status','>',-1)->select();
            $lists=list_to_tree($lists);
            $lists=list_to_char_tree($lists);
            $this->assign('lists',$lists);
            return $this -> fetch();
        }
        $postData=$this->request->param();
        //验证
        $adminMenuValidate=new AdminMenuValidate();
        if (!$adminMenuValidate->check($postData)) {
            $this->error($adminMenuValidate->getError());
        }
        $model=new AdminMenuModel();

        $postData['hide']=isset($postData['hide'])?$postData['hide']:1;
        $re=$model->add($postData);
        if($re){
            
            $this->success('新增成功！','index');
        }
        else{
            $this->error($model->getError());
        }
    }
    /**
     * 编辑
     */
    public function edit(){
        $model=new AdminMenuModel();
        if($this->request->isGet()){
            $id=input('id');
            $info=$model->get($id);
            $this->assign('info',$info);
            $lists=AdminMenuModel::where('status','>',-1)->select();
            $lists=list_to_tree($lists);
            $lists=list_to_char_tree($lists);
            $this->assign('lists',$lists);
            return $this -> fetch();
        }
        $paramData=$this->request->param();
        //验证
        $adminMenuValidate=new AdminMenuValidate();
        if (!$adminMenuValidate->check($paramData)) {
            $this->error($adminMenuValidate->getError());
        }
        $re=$model->edit($paramData);
        if($re){
            
            $this->success('编辑成功！','');
        }
        else{
            $this->error($model->getError());
        }
    }
    /**
     * 删除
     */
    public function del(){
        $id=$this->request->param('ids/a');
        $model=new AdminMenuModel();
        $re=$model->del($id);
        if($re){
            AdminMenuModel::removeAuthMenuCache();
            $this->success('删除成功！');
        }
        else{
            $this->error($model->getError());
        }
    }

    /**
     * 排序
     */
    public function sort(){
        if ($this->request->isPost()){
            $data['id']=input('id/d');
            $data['sort']=input('sort');

            $adminMenuValidate=new AdminMenuValidate();
            if (!$adminMenuValidate->scene('sort')->check($data)) {
                $this->error($adminMenuValidate->getError());
            }
            $model=new AdminMenuModel();
            $re=$model->edit($data);
            if($re){
                
                $this->success('操作成功！');
            }else{
                $this->error($model->getError());
            }
        }
    }
    /**
     * 显示隐藏
     */
    public function hide(){
        if ($this->request->isPost()){
            $data['id']=input('id/d');
            $data['hide']=input('val/d');
            $model=new AdminMenuModel();
            $res=$model->edit($data);
            if($res){
                $this->success('操作成功！');
            }else{
                $this->error($model->getError());
            }
        }
    }
}