<?php
// +----------------------------------------------------------------------
// | hulacwms 3.0 呼啦企业网站管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2021 https://www.kaifashu.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 开发树
// +----------------------------------------------------------------------

namespace app\admin\controller;

use app\common\model\AdminAuthGroup as AdminAuthGroupModel;
use app\common\model\AdminMember as AdminMemberModel;
use app\common\model\AdminMenu as AdminMenuModel;
use app\common\validate\AdminAuthGroup as AuthManagerValidate;


class AdminAuthGroup extends Auth
{
    /**
     * 后台用户权限首页
     */
    public function index()
    {
        $model = new AdminAuthGroupModel();
        $lists = $model
            ->where('status','>',-1)
            ->paginate($this->config['LIST_ROWS'], false, ['query' => $this->getRouteQuery()]);
        $this->assign('lists', $lists);
        return $this->fetch();
    }

    /**
     * 添加用户权限
     */
    public function add()
    {
        if ($this->request->isGet()) {
            return $this->fetch();
        }
        $postData = $this->request->param();
        //验证
        $authManagerValidate=new AuthManagerValidate();
        if (!$authManagerValidate->check($postData)) {
            $this->error($authManagerValidate->getError());
        }

        $model = new AdminAuthGroupModel();
        //判断用户组名称是否重复
        if ($model->isRepeatTitle($postData['title'])) {
            $this->error("用户组名称重复！");
        }
        $postData['type']=1;
        $postData['module']='admin';
        $re = $model->add($postData);
        if ($re) {
            $this->success('新增成功！','index');
        } else {
            $this->error($model->getError());
        }
    }


    /**
     * 编辑用户权限
     */
    public function edit()
    {
        $model = new AdminAuthGroupModel();
        if ($this->request->isGet()) {
            $id = input('id');
            $info = $model->get($id);
            $this->assign('info', $info);
            return $this->fetch();
        }
        $paramData = $this->request->param();
        //验证
        $authManagerValidate=new AuthManagerValidate();
        if (!$authManagerValidate->check($paramData)) {
            $this->error($authManagerValidate->getError());
        }

        //判断用户组名称是否重复
        if ($model->isRepeatTitle($paramData['title'], $paramData['id'])) {
            $this->error("用户组名称重复！");
        }
        $re = $model->edit($paramData);
        if ($re) {
            $this->success('编辑成功！','index');
        } else {
            $this->error($model->getError());
        }
    }

    /**
     * 启用禁用用户权限
     */
    public function enable()
    {
        if ($this->request->isPost()) {
            $data['id'] = input('id/d');
            $data['status'] = input('val/d');
            $model = new AdminAuthGroupModel();
            $res = $model->edit($data);
            if ($res) {
                if($data['status']==1){
                    $adminAuthgroup_status="adminauthgroup_status_qi";
                }
                if($data['status']==0){
                    $adminAuthgroup_status="adminauthgroup_status_jin";
                }
                $this->success('操作成功！');
            } else {
                $this->error($model->getError());
            }
        }
    }

    /**
     * 删除权限分组（软删除）
     */
    public function del()
    {
        $id = $this->request->param('ids/a');
        $model = new AdminAuthGroupModel();
        $where[] =['id','in',$id];
        //伪删除
        $re=$model->save([
            'status'  => -1
        ],$where);
        if ($re) {
            $adminMemberModel=new AdminMemberModel();
            $where=[];
            $where[]=['group_id','in',$id];
            $adminMemberModel->update(['group_id'=>0],$where);
            $this->success('删除成功！');
        } else {
            $this->error($model->getError());
        }
    }

    /**
     * 访问授权页面
     */
    public function access($id)
    {
        if ($this->request->isGet()) {
            //拉取所有后台所有菜单
            $modelAdminMenu = new AdminMenuModel();
            $lists = $modelAdminMenu->order('sort asc')->select();
            $lists = list_to_tree($lists, 0);
            //获取当前用户组信息
            $modelAuthModel = new AdminAuthGroupModel();
            $authGroup = $modelAuthModel->get($id);
            $this->assign('authGroup', $authGroup);
            $this->assign('lists', $lists);
            $this->assign('id', $id);
            return $this->fetch();
        }
        $rule = $this->request->param('rule/a');
        $data['rules'] = implode(',', $rule);
        $data['id'] = $id;
        $model = new AdminAuthGroupModel();
        $re = $model->edit($data);
        if ($re) {
            session('ADMIN_MEMBER_RULES',null);
            $this->success('授权成功！');
        } else {
            $this->error($model->getError());
        }

    }

    /**
     * 成员授权页面
     */
    public function user()
    {
        if ($this->request->isGet()) {
            $id=input('id');
            //获取当前用户组信息
            $modelAuthModel = new AdminAuthGroupModel();
            $authGroup = $modelAuthModel->get($id);
            $this->assign('authGroup', $authGroup);

            $modelAdminMember = new AdminMemberModel();
            $lists = $modelAdminMember->where('group_id', $id)->select();

            $this->assign('lists', $lists);
            $this->assign('id', $id);
            return $this->fetch();
        }

        $data = $this->request->param();
        $modelAdminMember = new AdminMemberModel();
        $re = $modelAdminMember->bindAuth($data);
        if ($re) {
            session('ADMIN_MEMBER_RULES',null);
            $this->success('授权成功！');
        } else {
            $this->error($modelAdminMember->getError());
        }
    }

    /**
     * 成员取消授权页面
     */
    public function user_cancel($id)
    {
        $data['id'] = $id;
        $data['group_id'] = 0;
        $modelAdminMember = new AdminMemberModel();
        $re = $modelAdminMember->edit($data);
        if ($re) {
            $this->success('操作成功！');
        } else {
            $this->error($modelAdminMember->getError());
        }

    }
}
