<?php
// +----------------------------------------------------------------------
// | hulacwms 3.0 呼啦企业网站管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2021 https://www.kaifashu.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 开发树
// +----------------------------------------------------------------------
namespace app\admin\controller;
use app\common\model\AdminMember as AdminMemberModel;
use think\captcha\Captcha;

class Admin extends Base
{
    /**
     * 后台登录
     */
    public function login(){
        if($this->request->isPost()){
            $data=$_POST;
            $captcha = new Captcha();
            if( !$captcha->check($data['code']))
            {
                 //验证失败
                $this->error('验证码错误！');
            }
            $memberModel=new AdminMemberModel();
            $reLogin=$memberModel->login($data);
            if(!$reLogin){
                $this->error($memberModel->getError());
            }

            //登录，保存登录信息
            session('UID',$reLogin->id);
            //跳转到首页
            $this->success('登录成功，正在跳转...');
        }
        else{
            //判断是否存在登录信息，如果存在，直接跳转到后台首页。
            $uid=session('UID');
            if($uid){
                return redirect('Index/index');
            }
            return $this->fetch();
        }
    }
    /**
     * 后台退出
     */
    public function logout(){
        parent::logout();
        $this->success('退出成功，正在跳转...','Admin/login');
    }
    /**
     * 验证码
     */
    public function captcha(){
        $config =    [
            // 验证码字体大小
            'fontSize'    =>    20,
            // 验证码位数
            'length'      =>    4,
            'imageW'=>148,
            'imageH'=>38
        ];
        $captcha = new Captcha($config);
        return $captcha->entry();
    }
}
