<?php
// +----------------------------------------------------------------------
// | hulacwms 3.0 呼啦企业网站管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2021 https://www.kaifashu.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 开发树
// +----------------------------------------------------------------------

namespace app\admin\controller;
use think\Exception;
use think\facade\Env;
use think\addons\Service as AddonsService;

class Addons extends Auth
{
    protected $ignoreLogin=['agent'];
    /**
     * 插件执行代理
     * @return mixed
     */
    public function agent(){
        $param=$this->request->param();
        $class = get_addon_class($param['addon'],'controller', $param['controller']);
        if (!class_exists($class)) {
            $this->error('插件不存在或已删除！');
        }
        $controllers = new $class();
        return call_user_func_array([$controllers, $param['action']], ['config'=>$this->config]);
    }
    /**
     * 插件列表
     * @return mixed
     */
    public function index(){
        $addons_path=Env::get('addons_path');
        if(!is_dir($addons_path)){
            $this->assign('lists',[]);
            return $this->fetch();
        }
        $dir_lists=scandir($addons_path);
        $lists=[];
        foreach ($dir_lists as $dir){
            if($dir=='.'||$dir=='..'){
                continue;
            }
            if (is_file($addons_path . $dir))
                continue;
            $class = get_addon_class($dir);
            if (class_exists($class)) {
                $addon = new $class();
                array_push($lists,$addon->getInfo());
            }
        }
        $this->assign('lists',$lists);
        return $this->fetch();
    }
    /**
     * 插件库
     * @return mixed
     */
    public function lib(){

        return $this->fetch();
    }

    /**
     * 启用禁用
     * @param $name
     * @param $val
     */
    public function enable($name,$val){
        $val=(int)$val;
        if($val==1){
            AddonsService::enable($name);
        }
        else{
            AddonsService::disable($name);
        }
        $this->success('操作成功！');
    }

    /**
     * 修改插件配置
     * @param $name
     */
    public function config($name){
        $class = get_addon_class($name);
        if (!class_exists($class)) {
            $this->error('插件不存在或已删除！');
        }
        $addon = new $class();
        if($this->request->isGet()){
            $lists=$addon->getFullConfig();
            $this->assign('lists',$lists);
            $this->assign('name',$name);
            return $this -> fetch();
        }
        $data=input();
        if(isset($data['file'])){
            unset($data['file']);
        }
        if(isset($data['name'])){
            unset($data['name']);
        }
        foreach ($data as $key=>$val){
            if(is_array($val)){
                $data[$key]=implode(',',$val);
            }
        }
        $addon->saveConfig($data);
        $this->success('操作成功！','');
    }

    /**
     * 本地安装插件
     */
    public function local(){
        $file = request()->file('file');
        try {
            AddonsService::local($file);
            $this->success('安装成功！','index');
        }
        catch (Exception $e){
            $this->error($e->getMessage());
        }
    }

    /**
     * 卸载插件
     */
    public function del($name){
        try {
            AddonsService::uninstall($name);
            $this->success('卸载成功！','index');
        }
        catch (Exception $e){
            $this->error($e->getMessage());
        }
    }
}
