<?php
// +----------------------------------------------------------------------
// | hulacwms 3.0 呼啦企业网站管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2021 https://www.kaifashu.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 开发树
// +----------------------------------------------------------------------

/**
 * 系统非常规MD5加密方法
 * @param  string $str 要加密的字符串
 * @return string
 */
function zz_ucenter_md5($str, $key = 'ZzUserKey'){
    return '' === $str ? '' : md5(sha1($str) . $key);
}

// 分析枚举类型配置值 格式 a:名称1,b:名称2
function parse_config_attr($string) {
    $array = preg_split('/[,;\r\n]+/', trim($string, ",;\r\n"));
    if(strpos($string,':')){
        $value  =   array();
        foreach ($array as $val) {
            list($k, $v) = explode(':', $val);
            $value[$k]   = $v;
        }
    }else{
        $value  =   $array;
    }
    return $value;
}

/**
 * 格式化字节大小
 * @param  number $size      字节数
 * @param  string $delimiter 数字和单位分隔符
 * @return string            格式化后的带单位的大小
 * @author 开发树 https://www.kaifashu.com
 */
function format_bytes($size, $delimiter = '') {
    $units = array('B', 'KB', 'MB', 'GB', 'TB', 'PB');
    for ($i = 0; $size >= 1024 && $i < 5; $i++) $size /= 1024;
    return round($size, 2) . $delimiter . $units[$i];
}

/**
 * 数据列表转换为数据树
 */
function list_to_tree($lists,$pid=0,$level=0) {
    $treeList=[];
    foreach ($lists as $item){
        if($item['pid']==$pid){
            $item['level']=$level;
            $childItem=list_to_tree($lists,$item['id'],$level+1);
            if($childItem){
                $item['child']=$childItem;
            }
            array_push($treeList,$item);
        }
    }
    return $treeList;
}

/**
 * 分类转换为数据树（字符数据树）
 */
function list_to_char_tree($lists) {
	if(!is_array($lists)){
		return;
	}
	$treeList=[];
	foreach($lists as $key=>$item){
		if($item['level']>0){
			$item['title']="├─".$item['title'];
		}
		
		for($x=1;$x<$item['level'];$x++){
			$item['title']="│  ".$item['title'];
		}

		if(isset($item['child'])){
            $treeItem=list_to_char_tree($item['child']);
			unset($item['child']);
            array_push($treeList,$item);
            if($treeItem){
                $treeList=array_merge($treeList,$treeItem);
            }
        }
		else{
			array_push($treeList,$item);
		}
	}
    return $treeList;
}
/**
 * 在输入关键字中，不按规则写的，予以替换分隔符
 * @return string
 */
function keyword_repalce_split($str){
    $str=str_replace("，",",",$str);
    $str=str_replace(";",",",$str);
    $str=str_replace("；",",",$str);
    $str=str_replace("|",",",$str);
    $str=str_replace("、",",",$str);
    $str=str_replace("\\",",",$str);
    return $str;
}