<?php
namespace addons\admin_log\model;
use think\model\concern\SoftDelete;

class AdminLog extends \think\Model
{
    //软删除功能，当数据表中出现delete_time字段时，启用。
    use SoftDelete;
    //自动时间戳
    protected $autoWriteTimestamp = true;

    /**
     * 记录行为
     * @param $param 当前后台登录的用户信息
     */
    public static function record($param=false){
        $request=request();
        $controller=$request->controller();
        $action=$request->action();
        $data['route']=$controller.'/'.$action;
        //保存可能存在的用户信息
        if($param){
            $data['admin_member_id']=$param->id;
            $data['admin_member_username']=$param->username;
        }
        $postData=$_POST;
        if($postData){
            //隐藏诸如密码似的敏感信息
            if(isset($postData['password'])){
                $postData['password']='******';
            }
            if(isset($postData['oldpassword'])){
                $postData['oldpassword']='******';
            }
            if(isset($postData['repassword'])){
                $postData['repassword']='******';
            }
            $data['content']=json_encode($postData);
        }
        $data['url']=$request->url();
        $data['ip']=$request->ip();
        $data['useragent']=$_SERVER['HTTP_USER_AGENT'];
        $model=new static();
        $model->save($data);
    }
}