<?php


namespace addons\admin_log\controller;
use addons\admin_log\model\AdminLog;
use think\Exception;
use think\Db;


class Index extends \think\Addons\AdminAuth
{
    public function index($config){
        $title=$this->request->param('title');
        $map=[];
        if($title){
            $map[]=['title|url','like','%'.$title.'%'];
        }
        $lists = AdminLog::where($map)
            -> order('id desc')->paginate($config['LIST_ROWS'],false,['query' => $this->getRouteQuery()]);

        $this->ifPageNoData($lists);
        //读取所有后台菜单
        try {
            $adminMenuList=Db::name('admin_menu')->select();
            $adminMenuDic=[];

            foreach ($adminMenuList as $item){
                if(isset($item['status'])&&(int)$item['status']==-1){
                    return;
                }
                if(isset($item['delete_time'])&&!$item['delete_time']){
                    return;
                }
                $adminMenuDic[$item['id']]=['title'=>$item['title'],'pid'=>$item['pid'],'url'=>$item['url']];
            }
            $updateData=[];
            foreach ($lists as $key=>$val){

                if($val->title===null){
                    if(strpos('admin/login',strtolower($val->route))>-1){
                        $val->title='登录';
                    }
                    elseif(preg_match('/addons[%2F|\/]\w+-\w+-\w+/',strtolower($val->url),$pat_array)){
                        $val->title=$this->getAdminMenuTitle($adminMenuDic,urldecode($pat_array[0]));
                    }
                    else{
                        $val->title=$this->getAdminMenuTitle($adminMenuDic,$val->route);
                    }

                    array_push($updateData,['id'=>$val->id,'title'=>$val->title]);
                }
            }
            $adminLogModel=new AdminLog();
            $adminLogModel->saveAll($updateData);
        }catch(Exception $e){
//            echo $e->getMessage();
        }


        $this -> assign('lists', $lists);
        $this->assign('title',$title);
        return $this->fetch();
    }



    /**
     * 详情
     */
    public function detail(){
        $id=$this->request->param('id');
        $info=AdminLog::get($id);
        if(!$info){
            $this->error('记录不存在或已删除！');
        }
        $this->assign('info',$info);
        return $this->fetch();
    }

    /**
     * 删除
     */
    public function del(){
        $id=$this->request->param('ids/a');
        $re=AdminLog::destroy($id);
        if($re){
            $this->success('删除成功！');
        }
        else{
            $this->error('删除失败！');
        }
    }

    /**
     * 获取当前route所对应的菜单名称
     * @param $lists
     * @param $route
     * @return string
     */
    private function getAdminMenuTitle($lists,$route){
        $menu=false;
        $title='';
        foreach ($lists as $item){
            if(strpos(strtolower($item['url']),strtolower($route))>-1){
                $menu=$item;
                $title=$menu['title'];
                while (true){
                    if($menu['pid']==0){
                        return $title;
                    }
                    $menu=$lists[$menu['pid']];
                    $title=$menu['title'].'/'.$title;
                }
            }
        }
        return $title;
    }
}