<!---
Copyright 2022 The HuggingFace Team. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# SetFit Notebooks

You can find here a list of notebooks covering various applications of SetFit. If you would like to contribute a notebook, please open a Pull Request so it can be included!

**Note:** On Kaggle, there is an issue with running `setfit` alongside the pre-installed version of `tensorflow`. To handle that, run 

```
%pip uninstall tensorflow -y
```

in the first cell of the notebook.

<!--This table is automatically generated, do not fill manually!-->



| Notebook                         | Colab                                                                                                                                                                                                         | Kaggle                                                                                                                                                                                                             | Gradient                                                                                                                                                                                         | Studio Lab                                                                                                                                                                                                             |
|:---------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Text Classification (Multiclass) | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/huggingface/setfit/blob/main/notebooks/text-classification.ipynb)                       | [![Kaggle](https://kaggle.com/static/images/open-in-kaggle.svg)](https://kaggle.com/kernels/welcome?src=https://github.com/huggingface/setfit/blob/main/notebooks/text-classification.ipynb)                       | [![Gradient](https://assets.paperspace.io/img/gradient-badge.svg)](https://console.paperspace.com/github/huggingface/setfit/blob/main/notebooks/text-classification.ipynb)                       | [![Open In SageMaker Studio Lab](https://studiolab.sagemaker.aws/studiolab.svg)](https://studiolab.sagemaker.aws/import/github/huggingface/setfit/blob/main/notebooks/text-classification.ipynb)                       |
| Text Classification (Multilabel) | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/huggingface/setfit/blob/main/notebooks/text-classification_multilabel.ipynb)            | [![Kaggle](https://kaggle.com/static/images/open-in-kaggle.svg)](https://kaggle.com/kernels/welcome?src=https://github.com/huggingface/setfit/blob/main/notebooks/text-classification_multilabel.ipynb)            | [![Gradient](https://assets.paperspace.io/img/gradient-badge.svg)](https://console.paperspace.com/github/huggingface/setfit/blob/main/notebooks/text-classification_multilabel.ipynb)            | [![Open In SageMaker Studio Lab](https://studiolab.sagemaker.aws/studiolab.svg)](https://studiolab.sagemaker.aws/import/github/huggingface/setfit/blob/main/notebooks/text-classification_multilabel.ipynb)            |
| Text Classification (HoC dataset, Multilabel) | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/huggingface/setfit/blob/main/notebooks/multilabel_HoC.ipynb)            | [![Kaggle](https://kaggle.com/static/images/open-in-kaggle.svg)](https://kaggle.com/kernels/welcome?src=https://github.com/huggingface/setfit/blob/main/notebooks/text-multilabel_HoC.ipynb)            | [![Gradient](https://assets.paperspace.io/img/gradient-badge.svg)](https://console.paperspace.com/github/huggingface/setfit/blob/main/notebooks/text-multilabel_HoC.ipynb)            | [![Open In SageMaker Studio Lab](https://studiolab.sagemaker.aws/studiolab.svg)](https://studiolab.sagemaker.aws/import/github/huggingface/setfit/blob/main/notebooks/text-multilabel_HoC.ipynb)            |
| Zero-Shot Text Classification    | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/huggingface/setfit/blob/main/notebooks/zero-shot-classification.ipynb)                  | [![Kaggle](https://kaggle.com/static/images/open-in-kaggle.svg)](https://kaggle.com/kernels/welcome?src=https://github.com/huggingface/setfit/blob/main/notebooks/zero-shot-classification.ipynb)                  | [![Gradient](https://assets.paperspace.io/img/gradient-badge.svg)](https://console.paperspace.com/github/huggingface/setfit/blob/main/notebooks/zero-shot-classification.ipynb)                  | [![Open In SageMaker Studio Lab](https://studiolab.sagemaker.aws/studiolab.svg)](https://studiolab.sagemaker.aws/import/github/huggingface/setfit/blob/main/notebooks/zero-shot-classification.ipynb)                  |
| Hyperparameter search            | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/huggingface/setfit/blob/main/notebooks/text-classification_hyperparameter-search.ipynb) | [![Kaggle](https://kaggle.com/static/images/open-in-kaggle.svg)](https://kaggle.com/kernels/welcome?src=https://github.com/huggingface/setfit/blob/main/notebooks/text-classification_hyperparameter-search.ipynb) | [![Gradient](https://assets.paperspace.io/img/gradient-badge.svg)](https://console.paperspace.com/github/huggingface/setfit/blob/main/notebooks/text-classification_hyperparameter-search.ipynb) | [![Open In SageMaker Studio Lab](https://studiolab.sagemaker.aws/studiolab.svg)](https://studiolab.sagemaker.aws/import/github/huggingface/setfit/blob/main/notebooks/text-classification_hyperparameter-search.ipynb) |



<!--End of table-->
