﻿# 1. Docker
1. [Comandos](https://github.com/hudsoncadan/tips-and-tricks/tree/master/dicas/docker): Quick reminder de comandos Docker.
# 2. ASP.NET
## C#
1. [Serviços em Background com Hangfire](dicas/aspnet/hangfire/HangfireSolution): Uma maneira fácil para executar processamento em background com .NET.
2. [Performance C#](dicas/aspnet/csharp/performance/PerformanceSolution/): Comparativo de perfomance entre List x Enumerable utilizando for, foreach e LINQ. Qual são as apostas para a melhor performance?
3. [Unit of Work](dicas/aspnet/unitofwork/UoWSolution): Implementação do padrão Repository com Unit of Work.
4. [LINQ](https://github.com/hudsoncadan/tips-and-tricks/tree/master/dicas/aspnet/csharp/linq): Conceito e Exemplos de LINQ para facilitar o entendimento.
## Web App
1. [Sintaxe Razor para ASP.NET Core](https://github.com/hudsoncadan/tips-and-tricks/tree/master/dicas/aspnet/webapps/razor-syntax): Renderize C# para HTML através da Sintaxe Razor.
2. [HTML Helpers x Tag Helpers](https://github.com/hudsoncadan/tips-and-tricks/tree/master/dicas/aspnet/webapps/htmlhelpers-taghelpers): Compare o uso de HTML Helpers x Tag Helpers e aprenda a criar Tag Helpers personalizados.
## OpenID e OAuth 2.0
1. [IdentityServer4](https://github.com/hudsoncadan/Authentication): Framework que implementa os protocolos OpenID e OAuth 2.0, gratuito, open source e disponível para ASP.NET Core.
# 3. Flutter
1. [Package GET](https://github.com/hudsoncadan/tips-and-tricks/tree/master/dicas/flutter/package_get): Package GET para Flutter com recursos de Gerenciamento de Estado, Injeção de Dependência e Navegação.
2. [Unit and Widget Tests](/dicas/flutter/tests/flutter_tests): Projeto Flutter com demonstração de Testes Unitários e Testes de Widget.
3. [Lista de Imagens com Animações](dicas/flutter/flutter_heart_animation): Lista de imagens, semelhante ao Instagram, com uma animação de like no duplo toque do usuário. 
# 4. Angular
1. [Formulários Dinâmicos](https://github.com/hudsoncadan/tips-and-tricks/tree/master/dicas/angular/dynamic-forms): Projeto Angular com o objetivo de simular a criação de formulários dinamicamente.
# 5. Python, Pandas e Machine Learning
## Python
1. [datetime](https://github.com/hudsoncadan/tips-and-tricks/blob/master/dicas/python/datetime/datetime%20Notebook.ipynb): Manipule datas e horas.
2. [Organizador de Arquivos](https://github.com/hudsoncadan/tips-and-tricks/blob/master/dicas/python/organizador/Organizador.ipynb): Organize por tipo os arquivos de um diretório.
3. [Decorators](https://github.com/hudsoncadan/tips-and-tricks/blob/master/dicas/python/decorators/decorators.ipynb): Adicione funcionalidades a um método já existente sem alterar sua estrutura.
## Pandas
1. [pandas.core.groupby.GroupBy.cumcount()](https://github.com/hudsoncadan/tips-and-tricks/blob/master/dicas/pandas/cumcount/cumcount%20Notebook.ipynb): Crie uma coluna autoincremento baseado em um grupo de colunas.
2. [pandas.cut()](https://github.com/hudsoncadan/tips-and-tricks/blob/master/dicas/pandas/cut/cut%20Notebook.ipynb): Converta dados numéricos em dados categóricos.
3. [pandas.DataFrame.diff()](https://github.com/hudsoncadan/tips-and-tricks/blob/master/dicas/pandas/diff/diff%20Notebook.ipynb): Calcule a diferença de valores entre cada linha de um DataFrame.
4. [pandas.DataFrame.unstack()](https://github.com/hudsoncadan/tips-and-tricks/blob/master/dicas/pandas/unstack/unstack%20Notebook.ipynb): Converta índices em colunas.
5. [pandas.Series.str.contains()](https://github.com/hudsoncadan/tips-and-tricks/blob/master/dicas/pandas/strcontains/strcontains%20Notebook.ipynb): Consulte se um valor ou uma expressão regular está contida dentro de uma Series.
6. [pandas.melt()](https://github.com/hudsoncadan/tips-and-tricks/blob/master/dicas/pandas/melt/melt%20Notebook.ipynb): Converta os elementos de uma lista em várias linhas no DataFrame.
7. [pandas.DataFrame.explode()](https://github.com/hudsoncadan/tips-and-tricks/blob/master/dicas/pandas/explode/explode%20Notebook.ipynb): Disponível a partir da versão 0.25, converta os elementos de uma lista em várias linhas no DataFrame.
8. [pandas.api.types.CategoricalDtype](https://github.com/hudsoncadan/tips-and-tricks/blob/master/dicas/pandas/categoricaldtype/categoricaldtype%20Notebook.ipynb): Defina uma ordem para as variáveis categóricas.
## Machine Learning
1. [Categorical Variables](https://github.com/hudsoncadan/tips-and-tricks/blob/master/dicas/machinelearning/categoricalvariables/categoricalvariables%20Notebook.ipynb): Conheça 3 técnicas para trabalhar com Categorical Variables.
2. [Missing Values](https://github.com/hudsoncadan/tips-and-tricks/blob/master/dicas/machinelearning/missingvalues/missingvalues%20Notebook.ipynb): Conheça 3 técnicas para trabalhar com Missing Values.
3. [sklearn.pipeline.Pipeline](https://github.com/hudsoncadan/tips-and-tricks/blob/master/dicas/machinelearning/pipelines/pipelines%20Notebook.ipynb): Agrupe as etapas de pré-processamento e modelagem dos dados.
4. [sklearn.model_selection.cross_val_score](https://github.com/hudsoncadan/tips-and-tricks/blob/master/dicas/machinelearning/crossvalidation/crossvalidation%20Notebook.ipynb): Execute o processo de modelagem em diferentes subconjuntos de dados para obter várias medidas de qualidade do modelo.
## Desafios
1. [Kaggle Credit Card - Previsão de Saldo](https://github.com/hudsoncadan/tips-and-tricks/blob/master/dicas/desafios/kaggle/creditcard/regression/Kaggle%20Credit%20Card%20LinearRegression.ipynb): Este notebook apresenta um modelo capaz de prever o Saldo (Balance) do cartão de crédito de acordo com uma série de características dos usuários. 
2. [Kaggle Credit Card - Segmentação de Clientes](https://github.com/hudsoncadan/tips-and-tricks/blob/master/dicas/desafios/kaggle/creditcard/kmeans/Kaggle%20Credit%20Card%20KMeans.ipynb): Este estudo de caso exige desenvolver um modelo para identificar segmentações de clientes a fim de definir uma estratégia de marketing.
