require 'htty'

# Encapsulates the _query-unset-all_ command.
class HTTY::CLI::Commands::QueryUnsetAll < HTTY::CLI::Command

  # Returns the name of a category under which help for the _query-unset-all_
  # command should appear.
  def self.category
    'Navigation'
  end

  # Returns the help text for the _query-unset-all_ command.
  def self.help
    "Clears the query string of the request's address"
  end

  # Returns the extended help text for the _query-unset-all_ command.
  def self.help_extended
    'Clears the query string used for the request. Does not communicate with ' +
    "the host.\n"                                                              +
    "\n"                                                                       +
    'The console prompt shows the address for the current request.'
  end

  # Returns related command classes for the _query-unset-all_ command.
  def self.see_also_commands
    [HTTY::CLI::Commands::QueryUnset,
     HTTY::CLI::Commands::QuerySet,
     HTTY::CLI::Commands::Address]
  end

  # Performs the _query-unset-all_ command.
  def perform
    add_request_if_new do |request|
      self.class.notify_if_cookies_cleared request do
        request.query_unset_all(*arguments)
      end
    end
  end

end
