require 'htty'

# Encapsulates the _headers-unset-all_ command.
class HTTY::CLI::Commands::HeadersUnsetAll < HTTY::CLI::Command

  # Returns the name of a category under which help for the _headers-unset-all_
  # command should appear.
  def self.category
    'Building Requests'
  end

  # Returns the help text for the _headers-unset-all_ command.
  def self.help
    'Removes all headers from the request'
  end

  # Returns the extended help text for the _headers-unset-all_ command.
  def self.help_extended
    'Removes all headers used for the request. Does not communicate with the ' +
    'host.'
  end

  # Returns related command classes for the _headers-unset-all_ command.
  def self.see_also_commands
    [HTTY::CLI::Commands::HeadersRequest,
     HTTY::CLI::Commands::HeadersUnset,
     HTTY::CLI::Commands::HeadersSet]
  end

  # Performs the _headers-unset-all_ command.
  def perform
    add_request_if_new do |request|
      request.headers_unset_all(*arguments)
    end
  end

end
