require 'htty'

# Encapsulates the _fragment-unset_ command.
class HTTY::CLI::Commands::FragmentUnset < HTTY::CLI::Command

  # Returns the name of a category under which help for the _fragment-unset_
  # command should appear.
  def self.category
    'Navigation'
  end

  # Returns the help text for the _fragment-unset_ command.
  def self.help
    "Removes the fragment from the request's address"
  end

  # Returns the extended help text for the _fragment-unset_ command.
  def self.help_extended
    'Removes the page fragment used for the request. Does not communicate ' +
    "with the host.\n"                                                      +
    "\n"                                                                    +
    'The console prompt shows the address for the current request.'
  end

  # Returns related command classes for the _fragment-unset_ command.
  def self.see_also_commands
    [HTTY::CLI::Commands::FragmentSet,
     HTTY::CLI::Commands::Address]
  end

  # Performs the _fragment-unset_ command.
  def perform
    add_request_if_new do |request|
      self.class.notify_if_cookies_cleared request do
        request.fragment_unset(*arguments)
      end
    end
  end

end
