use rkvm_input::key::{Button, Key, Keyboard};
use serde::Deserialize;
use std::collections::HashSet;
use std::net::SocketAddr;
use std::path::PathBuf;

#[derive(Deserialize)]
#[serde(rename_all = "kebab-case")]
pub struct Config {
    pub listen: SocketAddr,
    pub certificate: PathBuf,
    pub key: PathBuf,
    pub password: String,
    pub switch_keys: HashSet<SwitchKey>,
    pub propagate_switch_keys: Option<bool>,
}

#[derive(Deserialize, Clone, Copy, PartialEq, Eq, Hash)]
#[serde(rename_all = "kebab-case")]
pub enum SwitchKey {
    // Keys.
    A,
    Ab,
    AddressBook,
    Again,
    AlsToggle,
    AltErase,
    Angle,
    Apostrophe,
    Appselect,
    Archive,
    AspectRatio,
    Assistant,
    AttendantOff,
    AttendantOn,
    AttendantToggle,
    Audio,
    AudioDesc,
    Aux,
    B,
    Back,
    Backslash,
    Backspace,
    BassBoost,
    Battery,
    Blue,
    Bluetooth,
    Bookmarks,
    Break,
    BrightnessAuto,
    BrightnessCycle,
    BrightnessMax,
    BrightnessMin,
    BrightnessToggle,
    BrightnessDown,
    BrightnessUp,
    BrlDot1,
    BrlDot10,
    BrlDot2,
    BrlDot3,
    BrlDot4,
    BrlDot5,
    BrlDot6,
    BrlDot7,
    BrlDot8,
    BrlDot9,
    ButtonConfig,
    C,
    Calc,
    Calendar,
    Camera,
    CameraDown,
    CameraFocus,
    CameraLeft,
    CameraRight,
    CameraUp,
    CameraZoomIn,
    CameraZoomOut,
    Cancel,
    CapsLock,
    Cd,
    Channel,
    ChannelDown,
    ChannelUp,
    Chat,
    Clear,
    Close,
    CloseCd,
    Coffee,
    Comma,
    Compose,
    Computer,
    Config,
    Connect,
    ContextMenu,
    Controlpanel,
    Copy,
    Cut,
    CycleWindows,
    D,
    Dashboard,
    Data,
    Database,
    DelEol,
    DelEos,
    DelLine,
    Delete,
    DeleteFile,
    Digits,
    Directory,
    DisplayOff,
    DisplayToggle,
    Documents,
    Dollar,
    Dot,
    Down,
    Dvd,
    E,
    Edit,
    Editor,
    EjectCd,
    EjectCloseCd,
    Email,
    End,
    Enter,
    Epg,
    Equal,
    Esc,
    Euro,
    Exit,
    F,
    F1,
    F10,
    F11,
    F12,
    F13,
    F14,
    F15,
    F16,
    F17,
    F18,
    F19,
    F2,
    F20,
    F21,
    F22,
    F23,
    F24,
    F3,
    F4,
    F5,
    F6,
    F7,
    F8,
    F9,
    FastForward,
    FastReverse,
    Favorites,
    File,
    Finance,
    Find,
    First,
    Fn,
    Fn1,
    Fn2,
    FnB,
    FnD,
    FnE,
    FnEsc,
    FnF,
    FnF1,
    FnF10,
    FnF11,
    FnF12,
    FnF2,
    FnF3,
    FnF4,
    FnF5,
    FnF6,
    FnF7,
    FnF8,
    FnF9,
    FnS,
    Forward,
    ForwardMail,
    Frameback,
    FrameForward,
    Front,
    FullScreen,
    G,
    Games,
    Goto,
    GraphicsEditor,
    Grave,
    Green,
    H,
    Hangeul,
    Hanja,
    Help,
    Henkan,
    Hiragana,
    Home,
    Homepage,
    Hp,
    I,
    Images,
    Info,
    InsLine,
    Insert,
    Iso,
    J,
    Journal,
    K,
    Katakana,
    KatakanaHiragana,
    KbdLayoutNext,
    KbdLcdMenu1,
    KbdLcdMenu2,
    KbdLcdMenu3,
    KbdLcdMenu4,
    KbdLcdMenu5,
    KbdIllumDown,
    KbdIllumToggle,
    KbdIllumUp,
    KbdInputAssistAccept,
    KbdInputAssistCancel,
    KbdInputAssistNext,
    KbdInputAssistNextgroup,
    KbdInputAssistPrev,
    KbdInputAssistPrevgroup,
    Keyboard,
    Kp0,
    Kp1,
    Kp2,
    Kp3,
    Kp4,
    Kp5,
    Kp6,
    Kp7,
    Kp8,
    Kp9,
    KpAsterisk,
    KpComma,
    KpDott,
    KpEnter,
    KpEqual,
    KpJpComma,
    KpLeftParen,
    KpMinus,
    KpPlus,
    KpPlusMinus,
    KpRightParen,
    KpSlash,
    L,
    Language,
    Last,
    Left,
    LeftDown,
    LeftUp,
    LeftAlt,
    LeftBrace,
    LeftCtrl,
    LeftMeta,
    LeftShift,
    LightsToggle,
    LineFeed,
    List,
    LogOff,
    M,
    Macro,
    Macro1,
    Macro10,
    Macro11,
    Macro12,
    Macro13,
    Macro14,
    Macro15,
    Macro16,
    Macro17,
    Macro18,
    Macro19,
    Macro2,
    Macro20,
    Macro21,
    Macro22,
    Macro23,
    Macro24,
    Macro25,
    Macro26,
    Macro27,
    Macro28,
    Macro29,
    Macro3,
    Macro30,
    Macro4,
    Macro5,
    Macro6,
    Macro7,
    Macro8,
    Macro9,
    MacroPreset1,
    MacroPreset2,
    MacroPreset3,
    MacroPresetCycle,
    MacroRecordStart,
    MacroRecordStop,
    Mail,
    Media,
    MediaRepeat,
    MediaTopMenu,
    Memo,
    Menu,
    Messenger,
    Mhp,
    MicMute,
    Minus,
    Mode,
    Move,
    Mp3,
    MsDos,
    Muhenkan,
    Mute,
    N,
    #[serde(rename = "0")]
    N0,
    #[serde(rename = "1")]
    N1,
    #[serde(rename = "102nd")]
    N102nd,
    #[serde(rename = "10-channels-down")]
    N10ChannelsDown,
    #[serde(rename = "10-channels-up")]
    N10ChannelsUp,
    #[serde(rename = "2")]
    N2,
    #[serde(rename = "3")]
    N3,
    #[serde(rename = "3d-mode")]
    N3dMode,
    #[serde(rename = "4")]
    N4,
    #[serde(rename = "5")]
    N5,
    #[serde(rename = "6")]
    N6,
    #[serde(rename = "7")]
    N7,
    #[serde(rename = "8")]
    N8,
    #[serde(rename = "9")]
    N9,
    New,
    News,
    Next,
    NextFavorite,
    NextSong,
    Numeric0,
    Numeric1,
    Numeric11,
    Numeric12,
    Numeric2,
    Numeric3,
    Numeric4,
    Numeric5,
    Numeric6,
    Numeric7,
    Numeric8,
    Numeric9,
    NumericA,
    NumericB,
    NumericC,
    NumericD,
    NumericPound,
    NumericStar,
    NumLock,
    O,
    Ok,
    OnscreenKeyboard,
    Open,
    Option,
    P,
    PageDown,
    PageUp,
    Paste,
    Pause,
    PauseRecord,
    PauseCd,
    Pc,
    Phone,
    Play,
    PlayCd,
    Player,
    PlayPause,
    Power,
    Power2,
    Presentation,
    Previous,
    PreviousSong,
    Print,
    PrivacyScreenToggle,
    Prog1,
    Prog2,
    Prog3,
    Prog4,
    Program,
    Props,
    Pvr,
    Q,
    Question,
    R,
    Radio,
    Record,
    Red,
    Redo,
    Refresh,
    Reply,
    Reserved,
    Restart,
    Rewind,
    RfKill,
    Right,
    RightDown,
    RightUp,
    RightAlt,
    RightBrace,
    RightCtrl,
    RightMeta,
    RightShift,
    Ro,
    RootMenu,
    RotateDisplay,
    RotateLockToggle,
    S,
    Sat,
    Sat2,
    Save,
    Scale,
    Screensaver,
    ScrollDown,
    ScrollLock,
    ScrollUp,
    Search,
    Select,
    SelectiveScreenshot,
    Semicolon,
    Send,
    SendFile,
    Setup,
    Shop,
    Shuffle,
    Slash,
    Sleep,
    Slow,
    SlowReverse,
    Sound,
    Space,
    Spellcheck,
    Sport,
    Spreadsheet,
    Stop,
    StopRecord,
    StopCd,
    Subtitle,
    Suspend,
    SwitchVideoMode,
    SysRq,
    T,
    Tab,
    Tape,
    TaskManager,
    Teen,
    Text,
    Time,
    Title,
    TouchpadOff,
    TouchpadOn,
    TouchpadToggle,
    Tuner,
    Tv,
    Tv2,
    Twen,
    U,
    Undo,
    Unknown,
    Unmute,
    Up,
    Uwb,
    V,
    Vcr,
    Vcr2,
    Vendor,
    Video,
    VideoNext,
    VideoPrev,
    VideoPhone,
    Vod,
    VoiceCommand,
    VoiceMail,
    VolumeDown,
    VolumeUp,
    W,
    WakeUp,
    Wlan,
    WordProcessor,
    WpsButton,
    Wwan,
    Www,
    X,
    Xfer,
    Y,
    Yellow,
    Yen,
    Z,
    ZenkakuHankaku,
    ZoomIn,
    ZoomOut,
    ZoomReset,

    // Buttons.
    B0,
    B1,
    B2,
    B3,
    B4,
    B5,
    B6,
    B7,
    B8,
    B9,
    BLeft,
    BRight,
    Middle,
    Side,
    Extra,
    BForward,
    BBack,
    Task,
    Trigger,
    Thumb,
    Thumb2,
    Top,
    Top2,
    Pinkie,
    Base,
    Base2,
    Base3,
    Base4,
    Base5,
    Base6,
    Dead,
    South,
    East,
    BC,
    North,
    West,
    BZ,
    TL,
    Tr,
    Tl2,
    Tr2,
    BSelect,
    Start,
    BMode,
    ThumbL,
    ThumbR,
    ToolPen,
    ToolRubber,
    ToolBrush,
    ToolPencil,
    ToolAirbrush,
    ToolFinger,
    ToolMouse,
    ToolLens,
    QuintTap,
    Stylus3,
    Touch,
    Stylus,
    Stylus2,
    DoubleTap,
    TripleTap,
    QuadTap,
    GearDown,
    GearUp,
    DPadUp,
    DPadDown,
    DPadLeft,
    DPadRight,
    TriggerHappy1,
    TrigerHappy2,
    TriggerHappy3,
    TriggerHappy4,
    TriggerHappy5,
    TriggerHappy6,
    TriggerHappy7,
    TriggerHappy8,
    TriggerHappy9,
    TriggerHappy10,
    TriggerHappy11,
    TriggerHappy12,
    TriggerHappy13,
    TriggerHappy14,
    TriggerHappy15,
    TriggerHappy16,
    TriggerHappy17,
    TriggerHappy18,
    TriggerHappy19,
    TriggerHappy20,
    TriggerHappy21,
    TriggerHappy22,
    TriggerHappy23,
    TriggerHappy24,
    TriggerHappy25,
    TriggerHappy26,
    TriggerHappy27,
    TriggerHappy28,
    TriggerHappy29,
    TriggerHappy30,
    TriggerHappy31,
    TriggerHappy32,
    TriggerHappy33,
    TriggerHappy34,
    TriggerHappy35,
    TriggerHappy36,
    TriggerHappy37,
    TriggerHappy38,
    TriggerHappy39,
    TriggerHappy40,
}

impl Into<Key> for SwitchKey {
    fn into(self) -> Key {
        match self {
            // Keys.
            Self::A => Key::Key(Keyboard::A),
            Self::Ab => Key::Key(Keyboard::Ab),
            Self::AddressBook => Key::Key(Keyboard::AddressBook),
            Self::Again => Key::Key(Keyboard::Again),
            Self::AlsToggle => Key::Key(Keyboard::AlsToggle),
            Self::AltErase => Key::Key(Keyboard::AltErase),
            Self::Angle => Key::Key(Keyboard::Angle),
            Self::Apostrophe => Key::Key(Keyboard::Apostrophe),
            Self::Appselect => Key::Key(Keyboard::Appselect),
            Self::Archive => Key::Key(Keyboard::Archive),
            Self::AspectRatio => Key::Key(Keyboard::AspectRatio),
            Self::Assistant => Key::Key(Keyboard::Assistant),
            Self::AttendantOff => Key::Key(Keyboard::AttendantOff),
            Self::AttendantOn => Key::Key(Keyboard::AttendantOn),
            Self::AttendantToggle => Key::Key(Keyboard::AttendantToggle),
            Self::Audio => Key::Key(Keyboard::Audio),
            Self::AudioDesc => Key::Key(Keyboard::AudioDesc),
            Self::Aux => Key::Key(Keyboard::Aux),
            Self::B => Key::Key(Keyboard::B),
            Self::Back => Key::Key(Keyboard::Back),
            Self::Backslash => Key::Key(Keyboard::Backslash),
            Self::Backspace => Key::Key(Keyboard::Backspace),
            Self::BassBoost => Key::Key(Keyboard::BassBoost),
            Self::Battery => Key::Key(Keyboard::Battery),
            Self::Blue => Key::Key(Keyboard::Blue),
            Self::Bluetooth => Key::Key(Keyboard::Bluetooth),
            Self::Bookmarks => Key::Key(Keyboard::Bookmarks),
            Self::Break => Key::Key(Keyboard::Break),
            Self::BrightnessAuto => Key::Key(Keyboard::BrightnessAuto),
            Self::BrightnessCycle => Key::Key(Keyboard::BrightnessCycle),
            Self::BrightnessMax => Key::Key(Keyboard::BrightnessMax),
            Self::BrightnessMin => Key::Key(Keyboard::BrightnessMin),
            Self::BrightnessToggle => Key::Key(Keyboard::BrightnessToggle),
            Self::BrightnessDown => Key::Key(Keyboard::BrightnessDown),
            Self::BrightnessUp => Key::Key(Keyboard::BrightnessUp),
            Self::BrlDot1 => Key::Key(Keyboard::BrlDot1),
            Self::BrlDot10 => Key::Key(Keyboard::BrlDot10),
            Self::BrlDot2 => Key::Key(Keyboard::BrlDot2),
            Self::BrlDot3 => Key::Key(Keyboard::BrlDot3),
            Self::BrlDot4 => Key::Key(Keyboard::BrlDot4),
            Self::BrlDot5 => Key::Key(Keyboard::BrlDot5),
            Self::BrlDot6 => Key::Key(Keyboard::BrlDot6),
            Self::BrlDot7 => Key::Key(Keyboard::BrlDot7),
            Self::BrlDot8 => Key::Key(Keyboard::BrlDot8),
            Self::BrlDot9 => Key::Key(Keyboard::BrlDot9),
            Self::ButtonConfig => Key::Key(Keyboard::ButtonConfig),
            Self::C => Key::Key(Keyboard::C),
            Self::Calc => Key::Key(Keyboard::Calc),
            Self::Calendar => Key::Key(Keyboard::Calendar),
            Self::Camera => Key::Key(Keyboard::Camera),
            Self::CameraDown => Key::Key(Keyboard::CameraDown),
            Self::CameraFocus => Key::Key(Keyboard::CameraFocus),
            Self::CameraLeft => Key::Key(Keyboard::CameraLeft),
            Self::CameraRight => Key::Key(Keyboard::CameraRight),
            Self::CameraUp => Key::Key(Keyboard::CameraUp),
            Self::CameraZoomIn => Key::Key(Keyboard::CameraZoomIn),
            Self::CameraZoomOut => Key::Key(Keyboard::CameraZoomOut),
            Self::Cancel => Key::Key(Keyboard::Cancel),
            Self::CapsLock => Key::Key(Keyboard::CapsLock),
            Self::Cd => Key::Key(Keyboard::Cd),
            Self::Channel => Key::Key(Keyboard::Channel),
            Self::ChannelDown => Key::Key(Keyboard::ChannelDown),
            Self::ChannelUp => Key::Key(Keyboard::ChannelUp),
            Self::Chat => Key::Key(Keyboard::Chat),
            Self::Clear => Key::Key(Keyboard::Clear),
            Self::Close => Key::Key(Keyboard::Close),
            Self::CloseCd => Key::Key(Keyboard::CloseCd),
            Self::Coffee => Key::Key(Keyboard::Coffee),
            Self::Comma => Key::Key(Keyboard::Comma),
            Self::Compose => Key::Key(Keyboard::Compose),
            Self::Computer => Key::Key(Keyboard::Computer),
            Self::Config => Key::Key(Keyboard::Config),
            Self::Connect => Key::Key(Keyboard::Connect),
            Self::ContextMenu => Key::Key(Keyboard::ContextMenu),
            Self::Controlpanel => Key::Key(Keyboard::Controlpanel),
            Self::Copy => Key::Key(Keyboard::Copy),
            Self::Cut => Key::Key(Keyboard::Cut),
            Self::CycleWindows => Key::Key(Keyboard::CycleWindows),
            Self::D => Key::Key(Keyboard::D),
            Self::Dashboard => Key::Key(Keyboard::Dashboard),
            Self::Data => Key::Key(Keyboard::Data),
            Self::Database => Key::Key(Keyboard::Database),
            Self::DelEol => Key::Key(Keyboard::DelEol),
            Self::DelEos => Key::Key(Keyboard::DelEos),
            Self::DelLine => Key::Key(Keyboard::DelLine),
            Self::Delete => Key::Key(Keyboard::Delete),
            Self::DeleteFile => Key::Key(Keyboard::DeleteFile),
            Self::Digits => Key::Key(Keyboard::Digits),
            Self::Directory => Key::Key(Keyboard::Directory),
            Self::DisplayOff => Key::Key(Keyboard::DisplayOff),
            Self::DisplayToggle => Key::Key(Keyboard::DisplayToggle),
            Self::Documents => Key::Key(Keyboard::Documents),
            Self::Dollar => Key::Key(Keyboard::Dollar),
            Self::Dot => Key::Key(Keyboard::Dot),
            Self::Down => Key::Key(Keyboard::Down),
            Self::Dvd => Key::Key(Keyboard::Dvd),
            Self::E => Key::Key(Keyboard::E),
            Self::Edit => Key::Key(Keyboard::Edit),
            Self::Editor => Key::Key(Keyboard::Editor),
            Self::EjectCd => Key::Key(Keyboard::EjectCd),
            Self::EjectCloseCd => Key::Key(Keyboard::EjectCloseCd),
            Self::Email => Key::Key(Keyboard::Email),
            Self::End => Key::Key(Keyboard::End),
            Self::Enter => Key::Key(Keyboard::Enter),
            Self::Epg => Key::Key(Keyboard::Epg),
            Self::Equal => Key::Key(Keyboard::Equal),
            Self::Esc => Key::Key(Keyboard::Esc),
            Self::Euro => Key::Key(Keyboard::Euro),
            Self::Exit => Key::Key(Keyboard::Exit),
            Self::F => Key::Key(Keyboard::F),
            Self::F1 => Key::Key(Keyboard::F1),
            Self::F10 => Key::Key(Keyboard::F10),
            Self::F11 => Key::Key(Keyboard::F11),
            Self::F12 => Key::Key(Keyboard::F12),
            Self::F13 => Key::Key(Keyboard::F13),
            Self::F14 => Key::Key(Keyboard::F14),
            Self::F15 => Key::Key(Keyboard::F15),
            Self::F16 => Key::Key(Keyboard::F16),
            Self::F17 => Key::Key(Keyboard::F17),
            Self::F18 => Key::Key(Keyboard::F18),
            Self::F19 => Key::Key(Keyboard::F19),
            Self::F2 => Key::Key(Keyboard::F2),
            Self::F20 => Key::Key(Keyboard::F20),
            Self::F21 => Key::Key(Keyboard::F21),
            Self::F22 => Key::Key(Keyboard::F22),
            Self::F23 => Key::Key(Keyboard::F23),
            Self::F24 => Key::Key(Keyboard::F24),
            Self::F3 => Key::Key(Keyboard::F3),
            Self::F4 => Key::Key(Keyboard::F4),
            Self::F5 => Key::Key(Keyboard::F5),
            Self::F6 => Key::Key(Keyboard::F6),
            Self::F7 => Key::Key(Keyboard::F7),
            Self::F8 => Key::Key(Keyboard::F8),
            Self::F9 => Key::Key(Keyboard::F9),
            Self::FastForward => Key::Key(Keyboard::FastForward),
            Self::FastReverse => Key::Key(Keyboard::FastReverse),
            Self::Favorites => Key::Key(Keyboard::Favorites),
            Self::File => Key::Key(Keyboard::File),
            Self::Finance => Key::Key(Keyboard::Finance),
            Self::Find => Key::Key(Keyboard::Find),
            Self::First => Key::Key(Keyboard::First),
            Self::Fn => Key::Key(Keyboard::Fn),
            Self::Fn1 => Key::Key(Keyboard::Fn1),
            Self::Fn2 => Key::Key(Keyboard::Fn2),
            Self::FnB => Key::Key(Keyboard::FnB),
            Self::FnD => Key::Key(Keyboard::FnD),
            Self::FnE => Key::Key(Keyboard::FnE),
            Self::FnEsc => Key::Key(Keyboard::FnEsc),
            Self::FnF => Key::Key(Keyboard::FnF),
            Self::FnF1 => Key::Key(Keyboard::FnF1),
            Self::FnF10 => Key::Key(Keyboard::FnF10),
            Self::FnF11 => Key::Key(Keyboard::FnF11),
            Self::FnF12 => Key::Key(Keyboard::FnF12),
            Self::FnF2 => Key::Key(Keyboard::FnF2),
            Self::FnF3 => Key::Key(Keyboard::FnF3),
            Self::FnF4 => Key::Key(Keyboard::FnF4),
            Self::FnF5 => Key::Key(Keyboard::FnF5),
            Self::FnF6 => Key::Key(Keyboard::FnF6),
            Self::FnF7 => Key::Key(Keyboard::FnF7),
            Self::FnF8 => Key::Key(Keyboard::FnF8),
            Self::FnF9 => Key::Key(Keyboard::FnF9),
            Self::FnS => Key::Key(Keyboard::FnS),
            Self::Forward => Key::Key(Keyboard::Forward),
            Self::ForwardMail => Key::Key(Keyboard::ForwardMail),
            Self::Frameback => Key::Key(Keyboard::Frameback),
            Self::FrameForward => Key::Key(Keyboard::FrameForward),
            Self::Front => Key::Key(Keyboard::Front),
            Self::FullScreen => Key::Key(Keyboard::FullScreen),
            Self::G => Key::Key(Keyboard::G),
            Self::Games => Key::Key(Keyboard::Games),
            Self::Goto => Key::Key(Keyboard::Goto),
            Self::GraphicsEditor => Key::Key(Keyboard::GraphicsEditor),
            Self::Grave => Key::Key(Keyboard::Grave),
            Self::Green => Key::Key(Keyboard::Green),
            Self::H => Key::Key(Keyboard::H),
            Self::Hangeul => Key::Key(Keyboard::Hangeul),
            Self::Hanja => Key::Key(Keyboard::Hanja),
            Self::Help => Key::Key(Keyboard::Help),
            Self::Henkan => Key::Key(Keyboard::Henkan),
            Self::Hiragana => Key::Key(Keyboard::Hiragana),
            Self::Home => Key::Key(Keyboard::Home),
            Self::Homepage => Key::Key(Keyboard::Homepage),
            Self::Hp => Key::Key(Keyboard::Hp),
            Self::I => Key::Key(Keyboard::I),
            Self::Images => Key::Key(Keyboard::Images),
            Self::Info => Key::Key(Keyboard::Info),
            Self::InsLine => Key::Key(Keyboard::InsLine),
            Self::Insert => Key::Key(Keyboard::Insert),
            Self::Iso => Key::Key(Keyboard::Iso),
            Self::J => Key::Key(Keyboard::J),
            Self::Journal => Key::Key(Keyboard::Journal),
            Self::K => Key::Key(Keyboard::K),
            Self::Katakana => Key::Key(Keyboard::Katakana),
            Self::KatakanaHiragana => Key::Key(Keyboard::KatakanaHiragana),
            Self::KbdLayoutNext => Key::Key(Keyboard::KbdLayoutNext),
            Self::KbdLcdMenu1 => Key::Key(Keyboard::KbdLcdMenu1),
            Self::KbdLcdMenu2 => Key::Key(Keyboard::KbdLcdMenu2),
            Self::KbdLcdMenu3 => Key::Key(Keyboard::KbdLcdMenu3),
            Self::KbdLcdMenu4 => Key::Key(Keyboard::KbdLcdMenu4),
            Self::KbdLcdMenu5 => Key::Key(Keyboard::KbdLcdMenu5),
            Self::KbdIllumDown => Key::Key(Keyboard::KbdIllumDown),
            Self::KbdIllumToggle => Key::Key(Keyboard::KbdIllumToggle),
            Self::KbdIllumUp => Key::Key(Keyboard::KbdIllumUp),
            Self::KbdInputAssistAccept => Key::Key(Keyboard::KbdInputAssistAccept),
            Self::KbdInputAssistCancel => Key::Key(Keyboard::KbdInputAssistCancel),
            Self::KbdInputAssistNext => Key::Key(Keyboard::KbdInputAssistNext),
            Self::KbdInputAssistNextgroup => Key::Key(Keyboard::KbdInputAssistNextgroup),
            Self::KbdInputAssistPrev => Key::Key(Keyboard::KbdInputAssistPrev),
            Self::KbdInputAssistPrevgroup => Key::Key(Keyboard::KbdInputAssistPrevgroup),
            Self::Keyboard => Key::Key(Keyboard::Keyboard),
            Self::Kp0 => Key::Key(Keyboard::Kp0),
            Self::Kp1 => Key::Key(Keyboard::Kp1),
            Self::Kp2 => Key::Key(Keyboard::Kp2),
            Self::Kp3 => Key::Key(Keyboard::Kp3),
            Self::Kp4 => Key::Key(Keyboard::Kp4),
            Self::Kp5 => Key::Key(Keyboard::Kp5),
            Self::Kp6 => Key::Key(Keyboard::Kp6),
            Self::Kp7 => Key::Key(Keyboard::Kp7),
            Self::Kp8 => Key::Key(Keyboard::Kp8),
            Self::Kp9 => Key::Key(Keyboard::Kp9),
            Self::KpAsterisk => Key::Key(Keyboard::KpAsterisk),
            Self::KpComma => Key::Key(Keyboard::KpComma),
            Self::KpDott => Key::Key(Keyboard::KpDot),
            Self::KpEnter => Key::Key(Keyboard::KpEnter),
            Self::KpEqual => Key::Key(Keyboard::KpEqual),
            Self::KpJpComma => Key::Key(Keyboard::KpJpComma),
            Self::KpLeftParen => Key::Key(Keyboard::KpLeftParen),
            Self::KpMinus => Key::Key(Keyboard::KpMinus),
            Self::KpPlus => Key::Key(Keyboard::KpPlus),
            Self::KpPlusMinus => Key::Key(Keyboard::KpPlusMinus),
            Self::KpRightParen => Key::Key(Keyboard::KpRightParen),
            Self::KpSlash => Key::Key(Keyboard::KpSlash),
            Self::L => Key::Key(Keyboard::L),
            Self::Language => Key::Key(Keyboard::Language),
            Self::Last => Key::Key(Keyboard::Last),
            Self::Left => Key::Key(Keyboard::Left),
            Self::LeftDown => Key::Key(Keyboard::LeftDown),
            Self::LeftUp => Key::Key(Keyboard::LeftUp),
            Self::LeftAlt => Key::Key(Keyboard::LeftAlt),
            Self::LeftBrace => Key::Key(Keyboard::LeftBrace),
            Self::LeftCtrl => Key::Key(Keyboard::LeftCtrl),
            Self::LeftMeta => Key::Key(Keyboard::LeftMeta),
            Self::LeftShift => Key::Key(Keyboard::LeftShift),
            Self::LightsToggle => Key::Key(Keyboard::LightsToggle),
            Self::LineFeed => Key::Key(Keyboard::LineFeed),
            Self::List => Key::Key(Keyboard::List),
            Self::LogOff => Key::Key(Keyboard::LogOff),
            Self::M => Key::Key(Keyboard::M),
            Self::Macro => Key::Key(Keyboard::Macro),
            Self::Macro1 => Key::Key(Keyboard::Macro1),
            Self::Macro10 => Key::Key(Keyboard::Macro10),
            Self::Macro11 => Key::Key(Keyboard::Macro11),
            Self::Macro12 => Key::Key(Keyboard::Macro12),
            Self::Macro13 => Key::Key(Keyboard::Macro13),
            Self::Macro14 => Key::Key(Keyboard::Macro14),
            Self::Macro15 => Key::Key(Keyboard::Macro15),
            Self::Macro16 => Key::Key(Keyboard::Macro16),
            Self::Macro17 => Key::Key(Keyboard::Macro17),
            Self::Macro18 => Key::Key(Keyboard::Macro18),
            Self::Macro19 => Key::Key(Keyboard::Macro19),
            Self::Macro2 => Key::Key(Keyboard::Macro2),
            Self::Macro20 => Key::Key(Keyboard::Macro20),
            Self::Macro21 => Key::Key(Keyboard::Macro21),
            Self::Macro22 => Key::Key(Keyboard::Macro22),
            Self::Macro23 => Key::Key(Keyboard::Macro23),
            Self::Macro24 => Key::Key(Keyboard::Macro24),
            Self::Macro25 => Key::Key(Keyboard::Macro25),
            Self::Macro26 => Key::Key(Keyboard::Macro26),
            Self::Macro27 => Key::Key(Keyboard::Macro27),
            Self::Macro28 => Key::Key(Keyboard::Macro28),
            Self::Macro29 => Key::Key(Keyboard::Macro29),
            Self::Macro3 => Key::Key(Keyboard::Macro3),
            Self::Macro30 => Key::Key(Keyboard::Macro30),
            Self::Macro4 => Key::Key(Keyboard::Macro4),
            Self::Macro5 => Key::Key(Keyboard::Macro5),
            Self::Macro6 => Key::Key(Keyboard::Macro6),
            Self::Macro7 => Key::Key(Keyboard::Macro7),
            Self::Macro8 => Key::Key(Keyboard::Macro8),
            Self::Macro9 => Key::Key(Keyboard::Macro9),
            Self::MacroPreset1 => Key::Key(Keyboard::MacroPreset1),
            Self::MacroPreset2 => Key::Key(Keyboard::MacroPreset2),
            Self::MacroPreset3 => Key::Key(Keyboard::MacroPreset3),
            Self::MacroPresetCycle => Key::Key(Keyboard::MacroPresetCycle),
            Self::MacroRecordStart => Key::Key(Keyboard::MacroRecordStart),
            Self::MacroRecordStop => Key::Key(Keyboard::MacroRecordStop),
            Self::Mail => Key::Key(Keyboard::Mail),
            Self::Media => Key::Key(Keyboard::Media),
            Self::MediaRepeat => Key::Key(Keyboard::MediaRepeat),
            Self::MediaTopMenu => Key::Key(Keyboard::MediaTopMenu),
            Self::Memo => Key::Key(Keyboard::Memo),
            Self::Menu => Key::Key(Keyboard::Menu),
            Self::Messenger => Key::Key(Keyboard::Messenger),
            Self::Mhp => Key::Key(Keyboard::Mhp),
            Self::MicMute => Key::Key(Keyboard::MicMute),
            Self::Minus => Key::Key(Keyboard::Minus),
            Self::Mode => Key::Key(Keyboard::Mode),
            Self::Move => Key::Key(Keyboard::Move),
            Self::Mp3 => Key::Key(Keyboard::Mp3),
            Self::MsDos => Key::Key(Keyboard::MsDos),
            Self::Muhenkan => Key::Key(Keyboard::Muhenkan),
            Self::Mute => Key::Key(Keyboard::Mute),
            Self::N => Key::Key(Keyboard::N),
            Self::N0 => Key::Key(Keyboard::N0),
            Self::N1 => Key::Key(Keyboard::N1),
            Self::N102nd => Key::Key(Keyboard::N102nd),
            Self::N10ChannelsDown => Key::Key(Keyboard::N10ChannelsDown),
            Self::N10ChannelsUp => Key::Key(Keyboard::N10ChannelsUp),
            Self::N2 => Key::Key(Keyboard::N2),
            Self::N3 => Key::Key(Keyboard::N3),
            Self::N3dMode => Key::Key(Keyboard::N3dMode),
            Self::N4 => Key::Key(Keyboard::N4),
            Self::N5 => Key::Key(Keyboard::N5),
            Self::N6 => Key::Key(Keyboard::N6),
            Self::N7 => Key::Key(Keyboard::N7),
            Self::N8 => Key::Key(Keyboard::N8),
            Self::N9 => Key::Key(Keyboard::N9),
            Self::New => Key::Key(Keyboard::New),
            Self::News => Key::Key(Keyboard::News),
            Self::Next => Key::Key(Keyboard::Next),
            Self::NextFavorite => Key::Key(Keyboard::NextFavorite),
            Self::NextSong => Key::Key(Keyboard::NextSong),
            Self::Numeric0 => Key::Key(Keyboard::Numeric0),
            Self::Numeric1 => Key::Key(Keyboard::Numeric1),
            Self::Numeric11 => Key::Key(Keyboard::Numeric11),
            Self::Numeric12 => Key::Key(Keyboard::Numeric12),
            Self::Numeric2 => Key::Key(Keyboard::Numeric2),
            Self::Numeric3 => Key::Key(Keyboard::Numeric3),
            Self::Numeric4 => Key::Key(Keyboard::Numeric4),
            Self::Numeric5 => Key::Key(Keyboard::Numeric5),
            Self::Numeric6 => Key::Key(Keyboard::Numeric6),
            Self::Numeric7 => Key::Key(Keyboard::Numeric7),
            Self::Numeric8 => Key::Key(Keyboard::Numeric8),
            Self::Numeric9 => Key::Key(Keyboard::Numeric9),
            Self::NumericA => Key::Key(Keyboard::NumericA),
            Self::NumericB => Key::Key(Keyboard::NumericB),
            Self::NumericC => Key::Key(Keyboard::NumericC),
            Self::NumericD => Key::Key(Keyboard::NumericD),
            Self::NumericPound => Key::Key(Keyboard::NumericPound),
            Self::NumericStar => Key::Key(Keyboard::NumericStar),
            Self::NumLock => Key::Key(Keyboard::NumLock),
            Self::O => Key::Key(Keyboard::O),
            Self::Ok => Key::Key(Keyboard::Ok),
            Self::OnscreenKeyboard => Key::Key(Keyboard::OnscreenKeyboard),
            Self::Open => Key::Key(Keyboard::Open),
            Self::Option => Key::Key(Keyboard::Option),
            Self::P => Key::Key(Keyboard::P),
            Self::PageDown => Key::Key(Keyboard::PageDown),
            Self::PageUp => Key::Key(Keyboard::PageUp),
            Self::Paste => Key::Key(Keyboard::Paste),
            Self::Pause => Key::Key(Keyboard::Pause),
            Self::PauseRecord => Key::Key(Keyboard::PauseRecord),
            Self::PauseCd => Key::Key(Keyboard::PauseCd),
            Self::Pc => Key::Key(Keyboard::Pc),
            Self::Phone => Key::Key(Keyboard::Phone),
            Self::Play => Key::Key(Keyboard::Play),
            Self::PlayCd => Key::Key(Keyboard::PlayCd),
            Self::Player => Key::Key(Keyboard::Player),
            Self::PlayPause => Key::Key(Keyboard::PlayPause),
            Self::Power => Key::Key(Keyboard::Power),
            Self::Power2 => Key::Key(Keyboard::Power2),
            Self::Presentation => Key::Key(Keyboard::Presentation),
            Self::Previous => Key::Key(Keyboard::Previous),
            Self::PreviousSong => Key::Key(Keyboard::PreviousSong),
            Self::Print => Key::Key(Keyboard::Print),
            Self::PrivacyScreenToggle => Key::Key(Keyboard::PrivacyScreenToggle),
            Self::Prog1 => Key::Key(Keyboard::Prog1),
            Self::Prog2 => Key::Key(Keyboard::Prog2),
            Self::Prog3 => Key::Key(Keyboard::Prog3),
            Self::Prog4 => Key::Key(Keyboard::Prog4),
            Self::Program => Key::Key(Keyboard::Program),
            Self::Props => Key::Key(Keyboard::Props),
            Self::Pvr => Key::Key(Keyboard::Pvr),
            Self::Q => Key::Key(Keyboard::Q),
            Self::Question => Key::Key(Keyboard::Question),
            Self::R => Key::Key(Keyboard::R),
            Self::Radio => Key::Key(Keyboard::Radio),
            Self::Record => Key::Key(Keyboard::Record),
            Self::Red => Key::Key(Keyboard::Red),
            Self::Redo => Key::Key(Keyboard::Redo),
            Self::Refresh => Key::Key(Keyboard::Refresh),
            Self::Reply => Key::Key(Keyboard::Reply),
            Self::Reserved => Key::Key(Keyboard::Reserved),
            Self::Restart => Key::Key(Keyboard::Restart),
            Self::Rewind => Key::Key(Keyboard::Rewind),
            Self::RfKill => Key::Key(Keyboard::RfKill),
            Self::Right => Key::Key(Keyboard::Right),
            Self::RightDown => Key::Key(Keyboard::RightDown),
            Self::RightUp => Key::Key(Keyboard::RightUp),
            Self::RightAlt => Key::Key(Keyboard::RightAlt),
            Self::RightBrace => Key::Key(Keyboard::RightBrace),
            Self::RightCtrl => Key::Key(Keyboard::RightCtrl),
            Self::RightMeta => Key::Key(Keyboard::RightMeta),
            Self::RightShift => Key::Key(Keyboard::RightShift),
            Self::Ro => Key::Key(Keyboard::Ro),
            Self::RootMenu => Key::Key(Keyboard::RootMenu),
            Self::RotateDisplay => Key::Key(Keyboard::RotateDisplay),
            Self::RotateLockToggle => Key::Key(Keyboard::RotateLockToggle),
            Self::S => Key::Key(Keyboard::S),
            Self::Sat => Key::Key(Keyboard::Sat),
            Self::Sat2 => Key::Key(Keyboard::Sat2),
            Self::Save => Key::Key(Keyboard::Save),
            Self::Scale => Key::Key(Keyboard::Scale),
            Self::Screensaver => Key::Key(Keyboard::Screensaver),
            Self::ScrollDown => Key::Key(Keyboard::ScrollDown),
            Self::ScrollLock => Key::Key(Keyboard::ScrollLock),
            Self::ScrollUp => Key::Key(Keyboard::ScrollUp),
            Self::Search => Key::Key(Keyboard::Search),
            Self::Select => Key::Key(Keyboard::Select),
            Self::SelectiveScreenshot => Key::Key(Keyboard::SelectiveScreenshot),
            Self::Semicolon => Key::Key(Keyboard::Semicolon),
            Self::Send => Key::Key(Keyboard::Send),
            Self::SendFile => Key::Key(Keyboard::SendFile),
            Self::Setup => Key::Key(Keyboard::Setup),
            Self::Shop => Key::Key(Keyboard::Shop),
            Self::Shuffle => Key::Key(Keyboard::Shuffle),
            Self::Slash => Key::Key(Keyboard::Slash),
            Self::Sleep => Key::Key(Keyboard::Sleep),
            Self::Slow => Key::Key(Keyboard::Slow),
            Self::SlowReverse => Key::Key(Keyboard::SlowReverse),
            Self::Sound => Key::Key(Keyboard::Sound),
            Self::Space => Key::Key(Keyboard::Space),
            Self::Spellcheck => Key::Key(Keyboard::Spellcheck),
            Self::Sport => Key::Key(Keyboard::Sport),
            Self::Spreadsheet => Key::Key(Keyboard::Spreadsheet),
            Self::Stop => Key::Key(Keyboard::Stop),
            Self::StopRecord => Key::Key(Keyboard::StopRecord),
            Self::StopCd => Key::Key(Keyboard::StopCd),
            Self::Subtitle => Key::Key(Keyboard::Subtitle),
            Self::Suspend => Key::Key(Keyboard::Suspend),
            Self::SwitchVideoMode => Key::Key(Keyboard::SwitchVideoMode),
            Self::SysRq => Key::Key(Keyboard::SysRq),
            Self::T => Key::Key(Keyboard::T),
            Self::Tab => Key::Key(Keyboard::Tab),
            Self::Tape => Key::Key(Keyboard::Tape),
            Self::TaskManager => Key::Key(Keyboard::TaskManager),
            Self::Teen => Key::Key(Keyboard::Teen),
            Self::Text => Key::Key(Keyboard::Text),
            Self::Time => Key::Key(Keyboard::Time),
            Self::Title => Key::Key(Keyboard::Title),
            Self::TouchpadOff => Key::Key(Keyboard::TouchpadOff),
            Self::TouchpadOn => Key::Key(Keyboard::TouchpadOn),
            Self::TouchpadToggle => Key::Key(Keyboard::TouchpadToggle),
            Self::Tuner => Key::Key(Keyboard::Tuner),
            Self::Tv => Key::Key(Keyboard::Tv),
            Self::Tv2 => Key::Key(Keyboard::Tv2),
            Self::Twen => Key::Key(Keyboard::Twen),
            Self::U => Key::Key(Keyboard::U),
            Self::Undo => Key::Key(Keyboard::Undo),
            Self::Unknown => Key::Key(Keyboard::Unknown),
            Self::Unmute => Key::Key(Keyboard::Unmute),
            Self::Up => Key::Key(Keyboard::Up),
            Self::Uwb => Key::Key(Keyboard::Uwb),
            Self::V => Key::Key(Keyboard::V),
            Self::Vcr => Key::Key(Keyboard::Vcr),
            Self::Vcr2 => Key::Key(Keyboard::Vcr2),
            Self::Vendor => Key::Key(Keyboard::Vendor),
            Self::Video => Key::Key(Keyboard::Video),
            Self::VideoNext => Key::Key(Keyboard::VideoNext),
            Self::VideoPrev => Key::Key(Keyboard::VideoPrev),
            Self::VideoPhone => Key::Key(Keyboard::VideoPhone),
            Self::Vod => Key::Key(Keyboard::Vod),
            Self::VoiceCommand => Key::Key(Keyboard::VoiceCommand),
            Self::VoiceMail => Key::Key(Keyboard::VoiceMail),
            Self::VolumeDown => Key::Key(Keyboard::VolumeDown),
            Self::VolumeUp => Key::Key(Keyboard::VolumeUp),
            Self::W => Key::Key(Keyboard::W),
            Self::WakeUp => Key::Key(Keyboard::WakeUp),
            Self::Wlan => Key::Key(Keyboard::Wlan),
            Self::WordProcessor => Key::Key(Keyboard::WordProcessor),
            Self::WpsButton => Key::Key(Keyboard::WpsButton),
            Self::Wwan => Key::Key(Keyboard::Wwan),
            Self::Www => Key::Key(Keyboard::Www),
            Self::X => Key::Key(Keyboard::X),
            Self::Xfer => Key::Key(Keyboard::Xfer),
            Self::Y => Key::Key(Keyboard::Y),
            Self::Yellow => Key::Key(Keyboard::Yellow),
            Self::Yen => Key::Key(Keyboard::Yen),
            Self::Z => Key::Key(Keyboard::Z),
            Self::ZenkakuHankaku => Key::Key(Keyboard::ZenkakuHankaku),
            Self::ZoomIn => Key::Key(Keyboard::ZoomIn),
            Self::ZoomOut => Key::Key(Keyboard::ZoomOut),
            Self::ZoomReset => Key::Key(Keyboard::ZoomReset),

            // Buttons.
            Self::B0 => Key::Button(Button::B0),
            Self::B1 => Key::Button(Button::B1),
            Self::B2 => Key::Button(Button::B2),
            Self::B3 => Key::Button(Button::B3),
            Self::B4 => Key::Button(Button::B4),
            Self::B5 => Key::Button(Button::B5),
            Self::B6 => Key::Button(Button::B6),
            Self::B7 => Key::Button(Button::B7),
            Self::B8 => Key::Button(Button::B8),
            Self::B9 => Key::Button(Button::B9),
            Self::BLeft => Key::Button(Button::Left),
            Self::BRight => Key::Button(Button::Right),
            Self::Middle => Key::Button(Button::Middle),
            Self::Side => Key::Button(Button::Side),
            Self::Extra => Key::Button(Button::Extra),
            Self::BForward => Key::Button(Button::Forward),
            Self::BBack => Key::Button(Button::Back),
            Self::Task => Key::Button(Button::Task),
            Self::Trigger => Key::Button(Button::Trigger),
            Self::Thumb => Key::Button(Button::Thumb),
            Self::Thumb2 => Key::Button(Button::Thumb2),
            Self::Top => Key::Button(Button::Top),
            Self::Top2 => Key::Button(Button::Top2),
            Self::Pinkie => Key::Button(Button::Pinkie),
            Self::Base => Key::Button(Button::Base),
            Self::Base2 => Key::Button(Button::Base2),
            Self::Base3 => Key::Button(Button::Base3),
            Self::Base4 => Key::Button(Button::Base4),
            Self::Base5 => Key::Button(Button::Base5),
            Self::Base6 => Key::Button(Button::Base6),
            Self::Dead => Key::Button(Button::Dead),
            Self::South => Key::Button(Button::South),
            Self::East => Key::Button(Button::East),
            Self::BC => Key::Button(Button::C),
            Self::North => Key::Button(Button::North),
            Self::West => Key::Button(Button::West),
            Self::BZ => Key::Button(Button::Z),
            Self::TL => Key::Button(Button::TL),
            Self::Tr => Key::Button(Button::Tr),
            Self::Tl2 => Key::Button(Button::Tl2),
            Self::Tr2 => Key::Button(Button::Tr2),
            Self::BSelect => Key::Button(Button::Select),
            Self::Start => Key::Button(Button::Start),
            Self::BMode => Key::Button(Button::Mode),
            Self::ThumbL => Key::Button(Button::ThumbL),
            Self::ThumbR => Key::Button(Button::ThumbR),
            Self::ToolPen => Key::Button(Button::ToolPen),
            Self::ToolRubber => Key::Button(Button::ToolRubber),
            Self::ToolBrush => Key::Button(Button::ToolBrush),
            Self::ToolPencil => Key::Button(Button::ToolPencil),
            Self::ToolAirbrush => Key::Button(Button::ToolAirbrush),
            Self::ToolFinger => Key::Button(Button::ToolFinger),
            Self::ToolMouse => Key::Button(Button::ToolMouse),
            Self::ToolLens => Key::Button(Button::ToolLens),
            Self::QuintTap => Key::Button(Button::QuintTap),
            Self::Stylus3 => Key::Button(Button::Stylus3),
            Self::Touch => Key::Button(Button::Touch),
            Self::Stylus => Key::Button(Button::Stylus),
            Self::Stylus2 => Key::Button(Button::Stylus2),
            Self::DoubleTap => Key::Button(Button::DoubleTap),
            Self::TripleTap => Key::Button(Button::TripleTap),
            Self::QuadTap => Key::Button(Button::QuadTap),
            Self::GearDown => Key::Button(Button::GearDown),
            Self::GearUp => Key::Button(Button::GearUp),
            Self::DPadUp => Key::Button(Button::DPadUp),
            Self::DPadDown => Key::Button(Button::DPadDown),
            Self::DPadLeft => Key::Button(Button::DPadLeft),
            Self::DPadRight => Key::Button(Button::DPadRight),
            Self::TriggerHappy1 => Key::Button(Button::TriggerHappy1),
            Self::TrigerHappy2 => Key::Button(Button::TrigerHappy2),
            Self::TriggerHappy3 => Key::Button(Button::TriggerHappy3),
            Self::TriggerHappy4 => Key::Button(Button::TriggerHappy4),
            Self::TriggerHappy5 => Key::Button(Button::TriggerHappy5),
            Self::TriggerHappy6 => Key::Button(Button::TriggerHappy6),
            Self::TriggerHappy7 => Key::Button(Button::TriggerHappy7),
            Self::TriggerHappy8 => Key::Button(Button::TriggerHappy8),
            Self::TriggerHappy9 => Key::Button(Button::TriggerHappy9),
            Self::TriggerHappy10 => Key::Button(Button::TriggerHappy10),
            Self::TriggerHappy11 => Key::Button(Button::TriggerHappy11),
            Self::TriggerHappy12 => Key::Button(Button::TriggerHappy12),
            Self::TriggerHappy13 => Key::Button(Button::TriggerHappy13),
            Self::TriggerHappy14 => Key::Button(Button::TriggerHappy14),
            Self::TriggerHappy15 => Key::Button(Button::TriggerHappy15),
            Self::TriggerHappy16 => Key::Button(Button::TriggerHappy16),
            Self::TriggerHappy17 => Key::Button(Button::TriggerHappy17),
            Self::TriggerHappy18 => Key::Button(Button::TriggerHappy18),
            Self::TriggerHappy19 => Key::Button(Button::TriggerHappy19),
            Self::TriggerHappy20 => Key::Button(Button::TriggerHappy20),
            Self::TriggerHappy21 => Key::Button(Button::TriggerHappy21),
            Self::TriggerHappy22 => Key::Button(Button::TriggerHappy22),
            Self::TriggerHappy23 => Key::Button(Button::TriggerHappy23),
            Self::TriggerHappy24 => Key::Button(Button::TriggerHappy24),
            Self::TriggerHappy25 => Key::Button(Button::TriggerHappy25),
            Self::TriggerHappy26 => Key::Button(Button::TriggerHappy26),
            Self::TriggerHappy27 => Key::Button(Button::TriggerHappy27),
            Self::TriggerHappy28 => Key::Button(Button::TriggerHappy28),
            Self::TriggerHappy29 => Key::Button(Button::TriggerHappy29),
            Self::TriggerHappy30 => Key::Button(Button::TriggerHappy30),
            Self::TriggerHappy31 => Key::Button(Button::TriggerHappy31),
            Self::TriggerHappy32 => Key::Button(Button::TriggerHappy32),
            Self::TriggerHappy33 => Key::Button(Button::TriggerHappy33),
            Self::TriggerHappy34 => Key::Button(Button::TriggerHappy34),
            Self::TriggerHappy35 => Key::Button(Button::TriggerHappy35),
            Self::TriggerHappy36 => Key::Button(Button::TriggerHappy36),
            Self::TriggerHappy37 => Key::Button(Button::TriggerHappy37),
            Self::TriggerHappy38 => Key::Button(Button::TriggerHappy38),
            Self::TriggerHappy39 => Key::Button(Button::TriggerHappy39),
            Self::TriggerHappy40 => Key::Button(Button::TriggerHappy40),
        }
    }
}

#[cfg(test)]
mod test {
    use super::*;

    #[test]
    fn example_parses() {
        let config = include_str!("../../example/server.toml");
        toml::from_str::<Config>(config).unwrap();
    }
}
