use crate::convert::Convert;
use crate::glue;

use serde::{Deserialize, Serialize};

#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash, Serialize, Deserialize)]
pub enum Keyboard {
    A,
    Ab,
    AddressBook,
    Again,
    AlsToggle,
    AltErase,
    Angle,
    Apostrophe,
    Appselect,
    Archive,
    AspectRatio,
    Assistant,
    AttendantOff,
    AttendantOn,
    AttendantToggle,
    Audio,
    AudioDesc,
    Aux,
    B,
    Back,
    Backslash,
    Backspace,
    BassBoost,
    Battery,
    Blue,
    Bluetooth,
    Bookmarks,
    Break,
    BrightnessAuto,
    BrightnessCycle,
    BrightnessMax,
    BrightnessMin,
    BrightnessToggle,
    BrightnessDown,
    BrightnessUp,
    BrlDot1,
    BrlDot10,
    BrlDot2,
    BrlDot3,
    BrlDot4,
    BrlDot5,
    BrlDot6,
    BrlDot7,
    BrlDot8,
    BrlDot9,
    ButtonConfig,
    C,
    Calc,
    Calendar,
    Camera,
    CameraDown,
    CameraFocus,
    CameraLeft,
    CameraRight,
    CameraUp,
    CameraZoomIn,
    CameraZoomOut,
    Cancel,
    CapsLock,
    Cd,
    Channel,
    ChannelDown,
    ChannelUp,
    Chat,
    Clear,
    Close,
    CloseCd,
    Coffee,
    Comma,
    Compose,
    Computer,
    Config,
    Connect,
    ContextMenu,
    Controlpanel,
    Copy,
    Cut,
    CycleWindows,
    D,
    Dashboard,
    Data,
    Database,
    DelEol,
    DelEos,
    DelLine,
    Delete,
    DeleteFile,
    Digits,
    Directory,
    DisplayOff,
    DisplayToggle,
    Documents,
    Dollar,
    Dot,
    Down,
    Dvd,
    E,
    Edit,
    Editor,
    EjectCd,
    EjectCloseCd,
    Email,
    End,
    Enter,
    Epg,
    Equal,
    Esc,
    Euro,
    Exit,
    F,
    F1,
    F10,
    F11,
    F12,
    F13,
    F14,
    F15,
    F16,
    F17,
    F18,
    F19,
    F2,
    F20,
    F21,
    F22,
    F23,
    F24,
    F3,
    F4,
    F5,
    F6,
    F7,
    F8,
    F9,
    FastForward,
    FastReverse,
    Favorites,
    File,
    Finance,
    Find,
    First,
    Fn,
    Fn1,
    Fn2,
    FnB,
    FnD,
    FnE,
    FnEsc,
    FnF,
    FnF1,
    FnF10,
    FnF11,
    FnF12,
    FnF2,
    FnF3,
    FnF4,
    FnF5,
    FnF6,
    FnF7,
    FnF8,
    FnF9,
    FnS,
    Forward,
    ForwardMail,
    Frameback,
    FrameForward,
    Front,
    FullScreen,
    G,
    Games,
    Goto,
    GraphicsEditor,
    Grave,
    Green,
    H,
    Hangeul,
    Hanja,
    Help,
    Henkan,
    Hiragana,
    Home,
    Homepage,
    Hp,
    I,
    Images,
    Info,
    InsLine,
    Insert,
    Iso,
    J,
    Journal,
    K,
    Katakana,
    KatakanaHiragana,
    KbdLayoutNext,
    KbdLcdMenu1,
    KbdLcdMenu2,
    KbdLcdMenu3,
    KbdLcdMenu4,
    KbdLcdMenu5,
    KbdIllumDown,
    KbdIllumToggle,
    KbdIllumUp,
    KbdInputAssistAccept,
    KbdInputAssistCancel,
    KbdInputAssistNext,
    KbdInputAssistNextgroup,
    KbdInputAssistPrev,
    KbdInputAssistPrevgroup,
    Keyboard,
    Kp0,
    Kp1,
    Kp2,
    Kp3,
    Kp4,
    Kp5,
    Kp6,
    Kp7,
    Kp8,
    Kp9,
    KpAsterisk,
    KpComma,
    KpDot,
    KpEnter,
    KpEqual,
    KpJpComma,
    KpLeftParen,
    KpMinus,
    KpPlus,
    KpPlusMinus,
    KpRightParen,
    KpSlash,
    L,
    Language,
    Last,
    Left,
    LeftDown,
    LeftUp,
    LeftAlt,
    LeftBrace,
    LeftCtrl,
    LeftMeta,
    LeftShift,
    LightsToggle,
    LineFeed,
    List,
    LogOff,
    M,
    Macro,
    Macro1,
    Macro10,
    Macro11,
    Macro12,
    Macro13,
    Macro14,
    Macro15,
    Macro16,
    Macro17,
    Macro18,
    Macro19,
    Macro2,
    Macro20,
    Macro21,
    Macro22,
    Macro23,
    Macro24,
    Macro25,
    Macro26,
    Macro27,
    Macro28,
    Macro29,
    Macro3,
    Macro30,
    Macro4,
    Macro5,
    Macro6,
    Macro7,
    Macro8,
    Macro9,
    MacroPreset1,
    MacroPreset2,
    MacroPreset3,
    MacroPresetCycle,
    MacroRecordStart,
    MacroRecordStop,
    Mail,
    Media,
    MediaRepeat,
    MediaTopMenu,
    Memo,
    Menu,
    Messenger,
    Mhp,
    MicMute,
    Minus,
    Mode,
    Move,
    Mp3,
    MsDos,
    Muhenkan,
    Mute,
    N,
    N0,
    N1,
    N102nd,
    N10ChannelsDown,
    N10ChannelsUp,
    N2,
    N3,
    N3dMode,
    N4,
    N5,
    N6,
    N7,
    N8,
    N9,
    New,
    News,
    Next,
    NextFavorite,
    NextSong,
    Numeric0,
    Numeric1,
    Numeric11,
    Numeric12,
    Numeric2,
    Numeric3,
    Numeric4,
    Numeric5,
    Numeric6,
    Numeric7,
    Numeric8,
    Numeric9,
    NumericA,
    NumericB,
    NumericC,
    NumericD,
    NumericPound,
    NumericStar,
    NumLock,
    O,
    Ok,
    OnscreenKeyboard,
    Open,
    Option,
    P,
    PageDown,
    PageUp,
    Paste,
    Pause,
    PauseRecord,
    PauseCd,
    Pc,
    Phone,
    Play,
    PlayCd,
    Player,
    PlayPause,
    Power,
    Power2,
    Presentation,
    Previous,
    PreviousSong,
    Print,
    PrivacyScreenToggle,
    Prog1,
    Prog2,
    Prog3,
    Prog4,
    Program,
    Props,
    Pvr,
    Q,
    Question,
    R,
    Radio,
    Record,
    Red,
    Redo,
    Refresh,
    Reply,
    Reserved,
    Restart,
    Rewind,
    RfKill,
    Right,
    RightDown,
    RightUp,
    RightAlt,
    RightBrace,
    RightCtrl,
    RightMeta,
    RightShift,
    Ro,
    RootMenu,
    RotateDisplay,
    RotateLockToggle,
    S,
    Sat,
    Sat2,
    Save,
    Scale,
    Screensaver,
    ScrollDown,
    ScrollLock,
    ScrollUp,
    Search,
    Select,
    SelectiveScreenshot,
    Semicolon,
    Send,
    SendFile,
    Setup,
    Shop,
    Shuffle,
    Slash,
    Sleep,
    Slow,
    SlowReverse,
    Sound,
    Space,
    Spellcheck,
    Sport,
    Spreadsheet,
    Stop,
    StopRecord,
    StopCd,
    Subtitle,
    Suspend,
    SwitchVideoMode,
    SysRq,
    T,
    Tab,
    Tape,
    TaskManager,
    Teen,
    Text,
    Time,
    Title,
    TouchpadOff,
    TouchpadOn,
    TouchpadToggle,
    Tuner,
    Tv,
    Tv2,
    Twen,
    U,
    Undo,
    Unknown,
    Unmute,
    Up,
    Uwb,
    V,
    Vcr,
    Vcr2,
    Vendor,
    Video,
    VideoNext,
    VideoPrev,
    VideoPhone,
    Vod,
    VoiceCommand,
    VoiceMail,
    VolumeDown,
    VolumeUp,
    W,
    WakeUp,
    Wlan,
    WordProcessor,
    WpsButton,
    Wwan,
    Www,
    X,
    Xfer,
    Y,
    Yellow,
    Yen,
    Z,
    ZenkakuHankaku,
    ZoomIn,
    ZoomOut,
    ZoomReset,
}

impl Convert for Keyboard {
    type Raw = u16;

    fn to_raw(&self) -> Option<Self::Raw> {
        let raw = match *self {
            Keyboard::A => glue::KEY_A,
            Keyboard::Ab => glue::KEY_AB,
            Keyboard::AddressBook => glue::KEY_ADDRESSBOOK,
            Keyboard::Again => glue::KEY_AGAIN,
            Keyboard::AlsToggle => glue::KEY_ALS_TOGGLE,
            Keyboard::AltErase => glue::KEY_ALTERASE,
            Keyboard::Angle => glue::KEY_ANGLE,
            Keyboard::Apostrophe => glue::KEY_APOSTROPHE,
            Keyboard::Appselect => glue::KEY_APPSELECT,
            Keyboard::Archive => glue::KEY_ARCHIVE,
            Keyboard::AspectRatio => glue::KEY_ASPECT_RATIO,
            Keyboard::Assistant => glue::KEY_ASSISTANT,
            Keyboard::AttendantOff => glue::KEY_ATTENDANT_OFF,
            Keyboard::AttendantOn => glue::KEY_ATTENDANT_ON,
            Keyboard::AttendantToggle => glue::KEY_ATTENDANT_TOGGLE,
            Keyboard::Audio => glue::KEY_AUDIO,
            Keyboard::AudioDesc => glue::KEY_AUDIO_DESC,
            Keyboard::Aux => glue::KEY_AUX,
            Keyboard::B => glue::KEY_B,
            Keyboard::Back => glue::KEY_BACK,
            Keyboard::Backslash => glue::KEY_BACKSLASH,
            Keyboard::Backspace => glue::KEY_BACKSPACE,
            Keyboard::BassBoost => glue::KEY_BASSBOOST,
            Keyboard::Battery => glue::KEY_BATTERY,
            Keyboard::Blue => glue::KEY_BLUE,
            Keyboard::Bluetooth => glue::KEY_BLUETOOTH,
            Keyboard::Bookmarks => glue::KEY_BOOKMARKS,
            Keyboard::Break => glue::KEY_BREAK,
            Keyboard::BrightnessAuto => glue::KEY_BRIGHTNESS_AUTO,
            Keyboard::BrightnessCycle => glue::KEY_BRIGHTNESS_CYCLE,
            Keyboard::BrightnessMax => glue::KEY_BRIGHTNESS_MAX,
            Keyboard::BrightnessMin => glue::KEY_BRIGHTNESS_MIN,
            Keyboard::BrightnessToggle => glue::KEY_BRIGHTNESS_TOGGLE,
            Keyboard::BrightnessDown => glue::KEY_BRIGHTNESSDOWN,
            Keyboard::BrightnessUp => glue::KEY_BRIGHTNESSUP,
            Keyboard::BrlDot1 => glue::KEY_BRL_DOT1,
            Keyboard::BrlDot10 => glue::KEY_BRL_DOT10,
            Keyboard::BrlDot2 => glue::KEY_BRL_DOT2,
            Keyboard::BrlDot3 => glue::KEY_BRL_DOT3,
            Keyboard::BrlDot4 => glue::KEY_BRL_DOT4,
            Keyboard::BrlDot5 => glue::KEY_BRL_DOT5,
            Keyboard::BrlDot6 => glue::KEY_BRL_DOT6,
            Keyboard::BrlDot7 => glue::KEY_BRL_DOT7,
            Keyboard::BrlDot8 => glue::KEY_BRL_DOT8,
            Keyboard::BrlDot9 => glue::KEY_BRL_DOT9,
            Keyboard::ButtonConfig => glue::KEY_BUTTONCONFIG,
            Keyboard::C => glue::KEY_C,
            Keyboard::Calc => glue::KEY_CALC,
            Keyboard::Calendar => glue::KEY_CALENDAR,
            Keyboard::Camera => glue::KEY_CAMERA,
            Keyboard::CameraDown => glue::KEY_CAMERA_DOWN,
            Keyboard::CameraFocus => glue::KEY_CAMERA_FOCUS,
            Keyboard::CameraLeft => glue::KEY_CAMERA_LEFT,
            Keyboard::CameraRight => glue::KEY_CAMERA_RIGHT,
            Keyboard::CameraUp => glue::KEY_CAMERA_UP,
            Keyboard::CameraZoomIn => glue::KEY_CAMERA_ZOOMIN,
            Keyboard::CameraZoomOut => glue::KEY_CAMERA_ZOOMOUT,
            Keyboard::Cancel => glue::KEY_CANCEL,
            Keyboard::CapsLock => glue::KEY_CAPSLOCK,
            Keyboard::Cd => glue::KEY_CD,
            Keyboard::Channel => glue::KEY_CHANNEL,
            Keyboard::ChannelDown => glue::KEY_CHANNELDOWN,
            Keyboard::ChannelUp => glue::KEY_CHANNELUP,
            Keyboard::Chat => glue::KEY_CHAT,
            Keyboard::Clear => glue::KEY_CLEAR,
            Keyboard::Close => glue::KEY_CLOSE,
            Keyboard::CloseCd => glue::KEY_CLOSECD,
            Keyboard::Coffee => glue::KEY_COFFEE,
            Keyboard::Comma => glue::KEY_COMMA,
            Keyboard::Compose => glue::KEY_COMPOSE,
            Keyboard::Computer => glue::KEY_COMPUTER,
            Keyboard::Config => glue::KEY_CONFIG,
            Keyboard::Connect => glue::KEY_CONNECT,
            Keyboard::ContextMenu => glue::KEY_CONTEXT_MENU,
            Keyboard::Controlpanel => glue::KEY_CONTROLPANEL,
            Keyboard::Copy => glue::KEY_COPY,
            Keyboard::Cut => glue::KEY_CUT,
            Keyboard::CycleWindows => glue::KEY_CYCLEWINDOWS,
            Keyboard::D => glue::KEY_D,
            Keyboard::Dashboard => glue::KEY_DASHBOARD,
            Keyboard::Data => glue::KEY_DATA,
            Keyboard::Database => glue::KEY_DATABASE,
            Keyboard::DelEol => glue::KEY_DEL_EOL,
            Keyboard::DelEos => glue::KEY_DEL_EOS,
            Keyboard::DelLine => glue::KEY_DEL_LINE,
            Keyboard::Delete => glue::KEY_DELETE,
            Keyboard::DeleteFile => glue::KEY_DELETEFILE,
            Keyboard::Digits => glue::KEY_DIGITS,
            Keyboard::Directory => glue::KEY_DIRECTORY,
            Keyboard::DisplayOff => glue::KEY_DISPLAY_OFF,
            Keyboard::DisplayToggle => glue::KEY_DISPLAYTOGGLE,
            Keyboard::Documents => glue::KEY_DOCUMENTS,
            Keyboard::Dollar => glue::KEY_DOLLAR,
            Keyboard::Dot => glue::KEY_DOT,
            Keyboard::Down => glue::KEY_DOWN,
            Keyboard::Dvd => glue::KEY_DVD,
            Keyboard::E => glue::KEY_E,
            Keyboard::Edit => glue::KEY_EDIT,
            Keyboard::Editor => glue::KEY_EDITOR,
            Keyboard::EjectCd => glue::KEY_EJECTCD,
            Keyboard::EjectCloseCd => glue::KEY_EJECTCLOSECD,
            Keyboard::Email => glue::KEY_EMAIL,
            Keyboard::End => glue::KEY_END,
            Keyboard::Enter => glue::KEY_ENTER,
            Keyboard::Epg => glue::KEY_EPG,
            Keyboard::Equal => glue::KEY_EQUAL,
            Keyboard::Esc => glue::KEY_ESC,
            Keyboard::Euro => glue::KEY_EURO,
            Keyboard::Exit => glue::KEY_EXIT,
            Keyboard::F => glue::KEY_F,
            Keyboard::F1 => glue::KEY_F1,
            Keyboard::F10 => glue::KEY_F10,
            Keyboard::F11 => glue::KEY_F11,
            Keyboard::F12 => glue::KEY_F12,
            Keyboard::F13 => glue::KEY_F13,
            Keyboard::F14 => glue::KEY_F14,
            Keyboard::F15 => glue::KEY_F15,
            Keyboard::F16 => glue::KEY_F16,
            Keyboard::F17 => glue::KEY_F17,
            Keyboard::F18 => glue::KEY_F18,
            Keyboard::F19 => glue::KEY_F19,
            Keyboard::F2 => glue::KEY_F2,
            Keyboard::F20 => glue::KEY_F20,
            Keyboard::F21 => glue::KEY_F21,
            Keyboard::F22 => glue::KEY_F22,
            Keyboard::F23 => glue::KEY_F23,
            Keyboard::F24 => glue::KEY_F24,
            Keyboard::F3 => glue::KEY_F3,
            Keyboard::F4 => glue::KEY_F4,
            Keyboard::F5 => glue::KEY_F5,
            Keyboard::F6 => glue::KEY_F6,
            Keyboard::F7 => glue::KEY_F7,
            Keyboard::F8 => glue::KEY_F8,
            Keyboard::F9 => glue::KEY_F9,
            Keyboard::FastForward => glue::KEY_FASTFORWARD,
            Keyboard::FastReverse => glue::KEY_FASTREVERSE,
            Keyboard::Favorites => glue::KEY_FAVORITES,
            Keyboard::File => glue::KEY_FILE,
            Keyboard::Finance => glue::KEY_FINANCE,
            Keyboard::Find => glue::KEY_FIND,
            Keyboard::First => glue::KEY_FIRST,
            Keyboard::Fn => glue::KEY_FN,
            Keyboard::Fn1 => glue::KEY_FN_1,
            Keyboard::Fn2 => glue::KEY_FN_2,
            Keyboard::FnB => glue::KEY_FN_B,
            Keyboard::FnD => glue::KEY_FN_D,
            Keyboard::FnE => glue::KEY_FN_E,
            Keyboard::FnEsc => glue::KEY_FN_ESC,
            Keyboard::FnF => glue::KEY_FN_F,
            Keyboard::FnF1 => glue::KEY_FN_F1,
            Keyboard::FnF10 => glue::KEY_FN_F10,
            Keyboard::FnF11 => glue::KEY_FN_F11,
            Keyboard::FnF12 => glue::KEY_FN_F12,
            Keyboard::FnF2 => glue::KEY_FN_F2,
            Keyboard::FnF3 => glue::KEY_FN_F3,
            Keyboard::FnF4 => glue::KEY_FN_F4,
            Keyboard::FnF5 => glue::KEY_FN_F5,
            Keyboard::FnF6 => glue::KEY_FN_F6,
            Keyboard::FnF7 => glue::KEY_FN_F7,
            Keyboard::FnF8 => glue::KEY_FN_F8,
            Keyboard::FnF9 => glue::KEY_FN_F9,
            Keyboard::FnS => glue::KEY_FN_S,
            Keyboard::Forward => glue::KEY_FORWARD,
            Keyboard::ForwardMail => glue::KEY_FORWARDMAIL,
            Keyboard::Frameback => glue::KEY_FRAMEBACK,
            Keyboard::FrameForward => glue::KEY_FRAMEFORWARD,
            Keyboard::Front => glue::KEY_FRONT,
            Keyboard::FullScreen => glue::KEY_FULL_SCREEN,
            Keyboard::G => glue::KEY_G,
            Keyboard::Games => glue::KEY_GAMES,
            Keyboard::Goto => glue::KEY_GOTO,
            Keyboard::GraphicsEditor => glue::KEY_GRAPHICSEDITOR,
            Keyboard::Grave => glue::KEY_GRAVE,
            Keyboard::Green => glue::KEY_GREEN,
            Keyboard::H => glue::KEY_H,
            Keyboard::Hangeul => glue::KEY_HANGEUL,
            Keyboard::Hanja => glue::KEY_HANJA,
            Keyboard::Help => glue::KEY_HELP,
            Keyboard::Henkan => glue::KEY_HENKAN,
            Keyboard::Hiragana => glue::KEY_HIRAGANA,
            Keyboard::Home => glue::KEY_HOME,
            Keyboard::Homepage => glue::KEY_HOMEPAGE,
            Keyboard::Hp => glue::KEY_HP,
            Keyboard::I => glue::KEY_I,
            Keyboard::Images => glue::KEY_IMAGES,
            Keyboard::Info => glue::KEY_INFO,
            Keyboard::InsLine => glue::KEY_INS_LINE,
            Keyboard::Insert => glue::KEY_INSERT,
            Keyboard::Iso => glue::KEY_ISO,
            Keyboard::J => glue::KEY_J,
            Keyboard::Journal => glue::KEY_JOURNAL,
            Keyboard::K => glue::KEY_K,
            Keyboard::Katakana => glue::KEY_KATAKANA,
            Keyboard::KatakanaHiragana => glue::KEY_KATAKANAHIRAGANA,
            Keyboard::KbdLayoutNext => glue::KEY_KBD_LAYOUT_NEXT,
            Keyboard::KbdLcdMenu1 => glue::KEY_KBD_LCD_MENU1,
            Keyboard::KbdLcdMenu2 => glue::KEY_KBD_LCD_MENU2,
            Keyboard::KbdLcdMenu3 => glue::KEY_KBD_LCD_MENU3,
            Keyboard::KbdLcdMenu4 => glue::KEY_KBD_LCD_MENU4,
            Keyboard::KbdLcdMenu5 => glue::KEY_KBD_LCD_MENU5,
            Keyboard::KbdIllumDown => glue::KEY_KBDILLUMDOWN,
            Keyboard::KbdIllumToggle => glue::KEY_KBDILLUMTOGGLE,
            Keyboard::KbdIllumUp => glue::KEY_KBDILLUMUP,
            Keyboard::KbdInputAssistAccept => glue::KEY_KBDINPUTASSIST_ACCEPT,
            Keyboard::KbdInputAssistCancel => glue::KEY_KBDINPUTASSIST_CANCEL,
            Keyboard::KbdInputAssistNext => glue::KEY_KBDINPUTASSIST_NEXT,
            Keyboard::KbdInputAssistNextgroup => glue::KEY_KBDINPUTASSIST_NEXTGROUP,
            Keyboard::KbdInputAssistPrev => glue::KEY_KBDINPUTASSIST_PREV,
            Keyboard::KbdInputAssistPrevgroup => glue::KEY_KBDINPUTASSIST_PREVGROUP,
            Keyboard::Keyboard => glue::KEY_KEYBOARD,
            Keyboard::Kp0 => glue::KEY_KP0,
            Keyboard::Kp1 => glue::KEY_KP1,
            Keyboard::Kp2 => glue::KEY_KP2,
            Keyboard::Kp3 => glue::KEY_KP3,
            Keyboard::Kp4 => glue::KEY_KP4,
            Keyboard::Kp5 => glue::KEY_KP5,
            Keyboard::Kp6 => glue::KEY_KP6,
            Keyboard::Kp7 => glue::KEY_KP7,
            Keyboard::Kp8 => glue::KEY_KP8,
            Keyboard::Kp9 => glue::KEY_KP9,
            Keyboard::KpAsterisk => glue::KEY_KPASTERISK,
            Keyboard::KpComma => glue::KEY_KPCOMMA,
            Keyboard::KpDot => glue::KEY_KPDOT,
            Keyboard::KpEnter => glue::KEY_KPENTER,
            Keyboard::KpEqual => glue::KEY_KPEQUAL,
            Keyboard::KpJpComma => glue::KEY_KPJPCOMMA,
            Keyboard::KpLeftParen => glue::KEY_KPLEFTPAREN,
            Keyboard::KpMinus => glue::KEY_KPMINUS,
            Keyboard::KpPlus => glue::KEY_KPPLUS,
            Keyboard::KpPlusMinus => glue::KEY_KPPLUSMINUS,
            Keyboard::KpRightParen => glue::KEY_KPRIGHTPAREN,
            Keyboard::KpSlash => glue::KEY_KPSLASH,
            Keyboard::L => glue::KEY_L,
            Keyboard::Language => glue::KEY_LANGUAGE,
            Keyboard::Last => glue::KEY_LAST,
            Keyboard::Left => glue::KEY_LEFT,
            Keyboard::LeftDown => glue::KEY_LEFT_DOWN,
            Keyboard::LeftUp => glue::KEY_LEFT_UP,
            Keyboard::LeftAlt => glue::KEY_LEFTALT,
            Keyboard::LeftBrace => glue::KEY_LEFTBRACE,
            Keyboard::LeftCtrl => glue::KEY_LEFTCTRL,
            Keyboard::LeftMeta => glue::KEY_LEFTMETA,
            Keyboard::LeftShift => glue::KEY_LEFTSHIFT,
            Keyboard::LightsToggle => glue::KEY_LIGHTS_TOGGLE,
            Keyboard::LineFeed => glue::KEY_LINEFEED,
            Keyboard::List => glue::KEY_LIST,
            Keyboard::LogOff => glue::KEY_LOGOFF,
            Keyboard::M => glue::KEY_M,
            Keyboard::Macro => glue::KEY_MACRO,
            Keyboard::Macro1 => glue::KEY_MACRO1,
            Keyboard::Macro10 => glue::KEY_MACRO10,
            Keyboard::Macro11 => glue::KEY_MACRO11,
            Keyboard::Macro12 => glue::KEY_MACRO12,
            Keyboard::Macro13 => glue::KEY_MACRO13,
            Keyboard::Macro14 => glue::KEY_MACRO14,
            Keyboard::Macro15 => glue::KEY_MACRO15,
            Keyboard::Macro16 => glue::KEY_MACRO16,
            Keyboard::Macro17 => glue::KEY_MACRO17,
            Keyboard::Macro18 => glue::KEY_MACRO18,
            Keyboard::Macro19 => glue::KEY_MACRO19,
            Keyboard::Macro2 => glue::KEY_MACRO2,
            Keyboard::Macro20 => glue::KEY_MACRO20,
            Keyboard::Macro21 => glue::KEY_MACRO21,
            Keyboard::Macro22 => glue::KEY_MACRO22,
            Keyboard::Macro23 => glue::KEY_MACRO23,
            Keyboard::Macro24 => glue::KEY_MACRO24,
            Keyboard::Macro25 => glue::KEY_MACRO25,
            Keyboard::Macro26 => glue::KEY_MACRO26,
            Keyboard::Macro27 => glue::KEY_MACRO27,
            Keyboard::Macro28 => glue::KEY_MACRO28,
            Keyboard::Macro29 => glue::KEY_MACRO29,
            Keyboard::Macro3 => glue::KEY_MACRO3,
            Keyboard::Macro30 => glue::KEY_MACRO30,
            Keyboard::Macro4 => glue::KEY_MACRO4,
            Keyboard::Macro5 => glue::KEY_MACRO5,
            Keyboard::Macro6 => glue::KEY_MACRO6,
            Keyboard::Macro7 => glue::KEY_MACRO7,
            Keyboard::Macro8 => glue::KEY_MACRO8,
            Keyboard::Macro9 => glue::KEY_MACRO9,
            Keyboard::MacroPreset1 => glue::KEY_MACRO_PRESET1,
            Keyboard::MacroPreset2 => glue::KEY_MACRO_PRESET2,
            Keyboard::MacroPreset3 => glue::KEY_MACRO_PRESET3,
            Keyboard::MacroPresetCycle => glue::KEY_MACRO_PRESET_CYCLE,
            Keyboard::MacroRecordStart => glue::KEY_MACRO_RECORD_START,
            Keyboard::MacroRecordStop => glue::KEY_MACRO_RECORD_STOP,
            Keyboard::Mail => glue::KEY_MAIL,
            Keyboard::Media => glue::KEY_MEDIA,
            Keyboard::MediaRepeat => glue::KEY_MEDIA_REPEAT,
            Keyboard::MediaTopMenu => glue::KEY_MEDIA_TOP_MENU,
            Keyboard::Memo => glue::KEY_MEMO,
            Keyboard::Menu => glue::KEY_MENU,
            Keyboard::Messenger => glue::KEY_MESSENGER,
            Keyboard::Mhp => glue::KEY_MHP,
            Keyboard::MicMute => glue::KEY_MICMUTE,
            Keyboard::Minus => glue::KEY_MINUS,
            Keyboard::Mode => glue::KEY_MODE,
            Keyboard::Move => glue::KEY_MOVE,
            Keyboard::Mp3 => glue::KEY_MP3,
            Keyboard::MsDos => glue::KEY_MSDOS,
            Keyboard::Muhenkan => glue::KEY_MUHENKAN,
            Keyboard::Mute => glue::KEY_MUTE,
            Keyboard::N => glue::KEY_N,
            Keyboard::N0 => glue::KEY_0,
            Keyboard::N1 => glue::KEY_1,
            Keyboard::N102nd => glue::KEY_102ND,
            Keyboard::N10ChannelsDown => glue::KEY_10CHANNELSDOWN,
            Keyboard::N10ChannelsUp => glue::KEY_10CHANNELSUP,
            Keyboard::N2 => glue::KEY_2,
            Keyboard::N3 => glue::KEY_3,
            Keyboard::N3dMode => glue::KEY_3D_MODE,
            Keyboard::N4 => glue::KEY_4,
            Keyboard::N5 => glue::KEY_5,
            Keyboard::N6 => glue::KEY_6,
            Keyboard::N7 => glue::KEY_7,
            Keyboard::N8 => glue::KEY_8,
            Keyboard::N9 => glue::KEY_9,
            Keyboard::New => glue::KEY_NEW,
            Keyboard::News => glue::KEY_NEWS,
            Keyboard::Next => glue::KEY_NEXT,
            Keyboard::NextFavorite => glue::KEY_NEXT_FAVORITE,
            Keyboard::NextSong => glue::KEY_NEXTSONG,
            Keyboard::Numeric0 => glue::KEY_NUMERIC_0,
            Keyboard::Numeric1 => glue::KEY_NUMERIC_1,
            Keyboard::Numeric11 => glue::KEY_NUMERIC_11,
            Keyboard::Numeric12 => glue::KEY_NUMERIC_12,
            Keyboard::Numeric2 => glue::KEY_NUMERIC_2,
            Keyboard::Numeric3 => glue::KEY_NUMERIC_3,
            Keyboard::Numeric4 => glue::KEY_NUMERIC_4,
            Keyboard::Numeric5 => glue::KEY_NUMERIC_5,
            Keyboard::Numeric6 => glue::KEY_NUMERIC_6,
            Keyboard::Numeric7 => glue::KEY_NUMERIC_7,
            Keyboard::Numeric8 => glue::KEY_NUMERIC_8,
            Keyboard::Numeric9 => glue::KEY_NUMERIC_9,
            Keyboard::NumericA => glue::KEY_NUMERIC_A,
            Keyboard::NumericB => glue::KEY_NUMERIC_B,
            Keyboard::NumericC => glue::KEY_NUMERIC_C,
            Keyboard::NumericD => glue::KEY_NUMERIC_D,
            Keyboard::NumericPound => glue::KEY_NUMERIC_POUND,
            Keyboard::NumericStar => glue::KEY_NUMERIC_STAR,
            Keyboard::NumLock => glue::KEY_NUMLOCK,
            Keyboard::O => glue::KEY_O,
            Keyboard::Ok => glue::KEY_OK,
            Keyboard::OnscreenKeyboard => glue::KEY_ONSCREEN_KEYBOARD,
            Keyboard::Open => glue::KEY_OPEN,
            Keyboard::Option => glue::KEY_OPTION,
            Keyboard::P => glue::KEY_P,
            Keyboard::PageDown => glue::KEY_PAGEDOWN,
            Keyboard::PageUp => glue::KEY_PAGEUP,
            Keyboard::Paste => glue::KEY_PASTE,
            Keyboard::Pause => glue::KEY_PAUSE,
            Keyboard::PauseRecord => glue::KEY_PAUSE_RECORD,
            Keyboard::PauseCd => glue::KEY_PAUSECD,
            Keyboard::Pc => glue::KEY_PC,
            Keyboard::Phone => glue::KEY_PHONE,
            Keyboard::Play => glue::KEY_PLAY,
            Keyboard::PlayCd => glue::KEY_PLAYCD,
            Keyboard::Player => glue::KEY_PLAYER,
            Keyboard::PlayPause => glue::KEY_PLAYPAUSE,
            Keyboard::Power => glue::KEY_POWER,
            Keyboard::Power2 => glue::KEY_POWER2,
            Keyboard::Presentation => glue::KEY_PRESENTATION,
            Keyboard::Previous => glue::KEY_PREVIOUS,
            Keyboard::PreviousSong => glue::KEY_PREVIOUSSONG,
            Keyboard::Print => glue::KEY_PRINT,
            Keyboard::PrivacyScreenToggle => glue::KEY_PRIVACY_SCREEN_TOGGLE,
            Keyboard::Prog1 => glue::KEY_PROG1,
            Keyboard::Prog2 => glue::KEY_PROG2,
            Keyboard::Prog3 => glue::KEY_PROG3,
            Keyboard::Prog4 => glue::KEY_PROG4,
            Keyboard::Program => glue::KEY_PROGRAM,
            Keyboard::Props => glue::KEY_PROPS,
            Keyboard::Pvr => glue::KEY_PVR,
            Keyboard::Q => glue::KEY_Q,
            Keyboard::Question => glue::KEY_QUESTION,
            Keyboard::R => glue::KEY_R,
            Keyboard::Radio => glue::KEY_RADIO,
            Keyboard::Record => glue::KEY_RECORD,
            Keyboard::Red => glue::KEY_RED,
            Keyboard::Redo => glue::KEY_REDO,
            Keyboard::Refresh => glue::KEY_REFRESH,
            Keyboard::Reply => glue::KEY_REPLY,
            Keyboard::Reserved => glue::KEY_RESERVED,
            Keyboard::Restart => glue::KEY_RESTART,
            Keyboard::Rewind => glue::KEY_REWIND,
            Keyboard::RfKill => glue::KEY_RFKILL,
            Keyboard::Right => glue::KEY_RIGHT,
            Keyboard::RightDown => glue::KEY_RIGHT_DOWN,
            Keyboard::RightUp => glue::KEY_RIGHT_UP,
            Keyboard::RightAlt => glue::KEY_RIGHTALT,
            Keyboard::RightBrace => glue::KEY_RIGHTBRACE,
            Keyboard::RightCtrl => glue::KEY_RIGHTCTRL,
            Keyboard::RightMeta => glue::KEY_RIGHTMETA,
            Keyboard::RightShift => glue::KEY_RIGHTSHIFT,
            Keyboard::Ro => glue::KEY_RO,
            Keyboard::RootMenu => glue::KEY_ROOT_MENU,
            Keyboard::RotateDisplay => glue::KEY_ROTATE_DISPLAY,
            Keyboard::RotateLockToggle => glue::KEY_ROTATE_LOCK_TOGGLE,
            Keyboard::S => glue::KEY_S,
            Keyboard::Sat => glue::KEY_SAT,
            Keyboard::Sat2 => glue::KEY_SAT2,
            Keyboard::Save => glue::KEY_SAVE,
            Keyboard::Scale => glue::KEY_SCALE,
            Keyboard::Screensaver => glue::KEY_SCREENSAVER,
            Keyboard::ScrollDown => glue::KEY_SCROLLDOWN,
            Keyboard::ScrollLock => glue::KEY_SCROLLLOCK,
            Keyboard::ScrollUp => glue::KEY_SCROLLUP,
            Keyboard::Search => glue::KEY_SEARCH,
            Keyboard::Select => glue::KEY_SELECT,
            Keyboard::SelectiveScreenshot => glue::KEY_SELECTIVE_SCREENSHOT,
            Keyboard::Semicolon => glue::KEY_SEMICOLON,
            Keyboard::Send => glue::KEY_SEND,
            Keyboard::SendFile => glue::KEY_SENDFILE,
            Keyboard::Setup => glue::KEY_SETUP,
            Keyboard::Shop => glue::KEY_SHOP,
            Keyboard::Shuffle => glue::KEY_SHUFFLE,
            Keyboard::Slash => glue::KEY_SLASH,
            Keyboard::Sleep => glue::KEY_SLEEP,
            Keyboard::Slow => glue::KEY_SLOW,
            Keyboard::SlowReverse => glue::KEY_SLOWREVERSE,
            Keyboard::Sound => glue::KEY_SOUND,
            Keyboard::Space => glue::KEY_SPACE,
            Keyboard::Spellcheck => glue::KEY_SPELLCHECK,
            Keyboard::Sport => glue::KEY_SPORT,
            Keyboard::Spreadsheet => glue::KEY_SPREADSHEET,
            Keyboard::Stop => glue::KEY_STOP,
            Keyboard::StopRecord => glue::KEY_STOP_RECORD,
            Keyboard::StopCd => glue::KEY_STOPCD,
            Keyboard::Subtitle => glue::KEY_SUBTITLE,
            Keyboard::Suspend => glue::KEY_SUSPEND,
            Keyboard::SwitchVideoMode => glue::KEY_SWITCHVIDEOMODE,
            Keyboard::SysRq => glue::KEY_SYSRQ,
            Keyboard::T => glue::KEY_T,
            Keyboard::Tab => glue::KEY_TAB,
            Keyboard::Tape => glue::KEY_TAPE,
            Keyboard::TaskManager => glue::KEY_TASKMANAGER,
            Keyboard::Teen => glue::KEY_TEEN,
            Keyboard::Text => glue::KEY_TEXT,
            Keyboard::Time => glue::KEY_TIME,
            Keyboard::Title => glue::KEY_TITLE,
            Keyboard::TouchpadOff => glue::KEY_TOUCHPAD_OFF,
            Keyboard::TouchpadOn => glue::KEY_TOUCHPAD_ON,
            Keyboard::TouchpadToggle => glue::KEY_TOUCHPAD_TOGGLE,
            Keyboard::Tuner => glue::KEY_TUNER,
            Keyboard::Tv => glue::KEY_TV,
            Keyboard::Tv2 => glue::KEY_TV2,
            Keyboard::Twen => glue::KEY_TWEN,
            Keyboard::U => glue::KEY_U,
            Keyboard::Undo => glue::KEY_UNDO,
            Keyboard::Unknown => glue::KEY_UNKNOWN,
            Keyboard::Unmute => glue::KEY_UNMUTE,
            Keyboard::Up => glue::KEY_UP,
            Keyboard::Uwb => glue::KEY_UWB,
            Keyboard::V => glue::KEY_V,
            Keyboard::Vcr => glue::KEY_VCR,
            Keyboard::Vcr2 => glue::KEY_VCR2,
            Keyboard::Vendor => glue::KEY_VENDOR,
            Keyboard::Video => glue::KEY_VIDEO,
            Keyboard::VideoNext => glue::KEY_VIDEO_NEXT,
            Keyboard::VideoPrev => glue::KEY_VIDEO_PREV,
            Keyboard::VideoPhone => glue::KEY_VIDEOPHONE,
            Keyboard::Vod => glue::KEY_VOD,
            Keyboard::VoiceCommand => glue::KEY_VOICECOMMAND,
            Keyboard::VoiceMail => glue::KEY_VOICEMAIL,
            Keyboard::VolumeDown => glue::KEY_VOLUMEDOWN,
            Keyboard::VolumeUp => glue::KEY_VOLUMEUP,
            Keyboard::W => glue::KEY_W,
            Keyboard::WakeUp => glue::KEY_WAKEUP,
            Keyboard::Wlan => glue::KEY_WLAN,
            Keyboard::WordProcessor => glue::KEY_WORDPROCESSOR,
            Keyboard::WpsButton => glue::KEY_WPS_BUTTON,
            Keyboard::Wwan => glue::KEY_WWAN,
            Keyboard::Www => glue::KEY_WWW,
            Keyboard::X => glue::KEY_X,
            Keyboard::Xfer => glue::KEY_XFER,
            Keyboard::Y => glue::KEY_Y,
            Keyboard::Yellow => glue::KEY_YELLOW,
            Keyboard::Yen => glue::KEY_YEN,
            Keyboard::Z => glue::KEY_Z,
            Keyboard::ZenkakuHankaku => glue::KEY_ZENKAKUHANKAKU,
            Keyboard::ZoomIn => glue::KEY_ZOOMIN,
            Keyboard::ZoomOut => glue::KEY_ZOOMOUT,
            Keyboard::ZoomReset => glue::KEY_ZOOMRESET,
        };

        Some(raw as _)
    }

    fn from_raw(raw: Self::Raw) -> Option<Self> {
        let keyboard = match raw as _ {
            glue::KEY_A => Keyboard::A,
            glue::KEY_AB => Keyboard::Ab,
            glue::KEY_ADDRESSBOOK => Keyboard::AddressBook,
            glue::KEY_AGAIN => Keyboard::Again,
            glue::KEY_ALS_TOGGLE => Keyboard::AlsToggle,
            glue::KEY_ALTERASE => Keyboard::AltErase,
            glue::KEY_ANGLE => Keyboard::Angle,
            glue::KEY_APOSTROPHE => Keyboard::Apostrophe,
            glue::KEY_APPSELECT => Keyboard::Appselect,
            glue::KEY_ARCHIVE => Keyboard::Archive,
            glue::KEY_ASPECT_RATIO => Keyboard::AspectRatio,
            glue::KEY_ASSISTANT => Keyboard::Assistant,
            glue::KEY_ATTENDANT_OFF => Keyboard::AttendantOff,
            glue::KEY_ATTENDANT_ON => Keyboard::AttendantOn,
            glue::KEY_ATTENDANT_TOGGLE => Keyboard::AttendantToggle,
            glue::KEY_AUDIO => Keyboard::Audio,
            glue::KEY_AUDIO_DESC => Keyboard::AudioDesc,
            glue::KEY_AUX => Keyboard::Aux,
            glue::KEY_B => Keyboard::B,
            glue::KEY_BACK => Keyboard::Back,
            glue::KEY_BACKSLASH => Keyboard::Backslash,
            glue::KEY_BACKSPACE => Keyboard::Backspace,
            glue::KEY_BASSBOOST => Keyboard::BassBoost,
            glue::KEY_BATTERY => Keyboard::Battery,
            glue::KEY_BLUE => Keyboard::Blue,
            glue::KEY_BLUETOOTH => Keyboard::Bluetooth,
            glue::KEY_BOOKMARKS => Keyboard::Bookmarks,
            glue::KEY_BREAK => Keyboard::Break,
            glue::KEY_BRIGHTNESS_AUTO => Keyboard::BrightnessAuto,
            glue::KEY_BRIGHTNESS_CYCLE => Keyboard::BrightnessCycle,
            glue::KEY_BRIGHTNESS_MAX => Keyboard::BrightnessMax,
            glue::KEY_BRIGHTNESS_MIN => Keyboard::BrightnessMin,
            glue::KEY_BRIGHTNESS_TOGGLE => Keyboard::BrightnessToggle,
            glue::KEY_BRIGHTNESSDOWN => Keyboard::BrightnessDown,
            glue::KEY_BRIGHTNESSUP => Keyboard::BrightnessUp,
            glue::KEY_BRL_DOT1 => Keyboard::BrlDot1,
            glue::KEY_BRL_DOT10 => Keyboard::BrlDot10,
            glue::KEY_BRL_DOT2 => Keyboard::BrlDot2,
            glue::KEY_BRL_DOT3 => Keyboard::BrlDot3,
            glue::KEY_BRL_DOT4 => Keyboard::BrlDot4,
            glue::KEY_BRL_DOT5 => Keyboard::BrlDot5,
            glue::KEY_BRL_DOT6 => Keyboard::BrlDot6,
            glue::KEY_BRL_DOT7 => Keyboard::BrlDot7,
            glue::KEY_BRL_DOT8 => Keyboard::BrlDot8,
            glue::KEY_BRL_DOT9 => Keyboard::BrlDot9,
            glue::KEY_BUTTONCONFIG => Keyboard::ButtonConfig,
            glue::KEY_C => Keyboard::C,
            glue::KEY_CALC => Keyboard::Calc,
            glue::KEY_CALENDAR => Keyboard::Calendar,
            glue::KEY_CAMERA => Keyboard::Camera,
            glue::KEY_CAMERA_DOWN => Keyboard::CameraDown,
            glue::KEY_CAMERA_FOCUS => Keyboard::CameraFocus,
            glue::KEY_CAMERA_LEFT => Keyboard::CameraLeft,
            glue::KEY_CAMERA_RIGHT => Keyboard::CameraRight,
            glue::KEY_CAMERA_UP => Keyboard::CameraUp,
            glue::KEY_CAMERA_ZOOMIN => Keyboard::CameraZoomIn,
            glue::KEY_CAMERA_ZOOMOUT => Keyboard::CameraZoomOut,
            glue::KEY_CANCEL => Keyboard::Cancel,
            glue::KEY_CAPSLOCK => Keyboard::CapsLock,
            glue::KEY_CD => Keyboard::Cd,
            glue::KEY_CHANNEL => Keyboard::Channel,
            glue::KEY_CHANNELDOWN => Keyboard::ChannelDown,
            glue::KEY_CHANNELUP => Keyboard::ChannelUp,
            glue::KEY_CHAT => Keyboard::Chat,
            glue::KEY_CLEAR => Keyboard::Clear,
            glue::KEY_CLOSE => Keyboard::Close,
            glue::KEY_CLOSECD => Keyboard::CloseCd,
            glue::KEY_COFFEE => Keyboard::Coffee,
            glue::KEY_COMMA => Keyboard::Comma,
            glue::KEY_COMPOSE => Keyboard::Compose,
            glue::KEY_COMPUTER => Keyboard::Computer,
            glue::KEY_CONFIG => Keyboard::Config,
            glue::KEY_CONNECT => Keyboard::Connect,
            glue::KEY_CONTEXT_MENU => Keyboard::ContextMenu,
            glue::KEY_CONTROLPANEL => Keyboard::Controlpanel,
            glue::KEY_COPY => Keyboard::Copy,
            glue::KEY_CUT => Keyboard::Cut,
            glue::KEY_CYCLEWINDOWS => Keyboard::CycleWindows,
            glue::KEY_D => Keyboard::D,
            glue::KEY_DASHBOARD => Keyboard::Dashboard,
            glue::KEY_DATA => Keyboard::Data,
            glue::KEY_DATABASE => Keyboard::Database,
            glue::KEY_DEL_EOL => Keyboard::DelEol,
            glue::KEY_DEL_EOS => Keyboard::DelEos,
            glue::KEY_DEL_LINE => Keyboard::DelLine,
            glue::KEY_DELETE => Keyboard::Delete,
            glue::KEY_DELETEFILE => Keyboard::DeleteFile,
            glue::KEY_DIGITS => Keyboard::Digits,
            glue::KEY_DIRECTORY => Keyboard::Directory,
            glue::KEY_DISPLAY_OFF => Keyboard::DisplayOff,
            glue::KEY_DOCUMENTS => Keyboard::Documents,
            glue::KEY_DOLLAR => Keyboard::Dollar,
            glue::KEY_DOT => Keyboard::Dot,
            glue::KEY_DOWN => Keyboard::Down,
            glue::KEY_DVD => Keyboard::Dvd,
            glue::KEY_E => Keyboard::E,
            glue::KEY_EDIT => Keyboard::Edit,
            glue::KEY_EDITOR => Keyboard::Editor,
            glue::KEY_EJECTCD => Keyboard::EjectCd,
            glue::KEY_EJECTCLOSECD => Keyboard::EjectCloseCd,
            glue::KEY_EMAIL => Keyboard::Email,
            glue::KEY_END => Keyboard::End,
            glue::KEY_ENTER => Keyboard::Enter,
            glue::KEY_EPG => Keyboard::Epg,
            glue::KEY_EQUAL => Keyboard::Equal,
            glue::KEY_ESC => Keyboard::Esc,
            glue::KEY_EURO => Keyboard::Euro,
            glue::KEY_EXIT => Keyboard::Exit,
            glue::KEY_F => Keyboard::F,
            glue::KEY_F1 => Keyboard::F1,
            glue::KEY_F10 => Keyboard::F10,
            glue::KEY_F11 => Keyboard::F11,
            glue::KEY_F12 => Keyboard::F12,
            glue::KEY_F13 => Keyboard::F13,
            glue::KEY_F14 => Keyboard::F14,
            glue::KEY_F15 => Keyboard::F15,
            glue::KEY_F16 => Keyboard::F16,
            glue::KEY_F17 => Keyboard::F17,
            glue::KEY_F18 => Keyboard::F18,
            glue::KEY_F19 => Keyboard::F19,
            glue::KEY_F2 => Keyboard::F2,
            glue::KEY_F20 => Keyboard::F20,
            glue::KEY_F21 => Keyboard::F21,
            glue::KEY_F22 => Keyboard::F22,
            glue::KEY_F23 => Keyboard::F23,
            glue::KEY_F24 => Keyboard::F24,
            glue::KEY_F3 => Keyboard::F3,
            glue::KEY_F4 => Keyboard::F4,
            glue::KEY_F5 => Keyboard::F5,
            glue::KEY_F6 => Keyboard::F6,
            glue::KEY_F7 => Keyboard::F7,
            glue::KEY_F8 => Keyboard::F8,
            glue::KEY_F9 => Keyboard::F9,
            glue::KEY_FASTFORWARD => Keyboard::FastForward,
            glue::KEY_FASTREVERSE => Keyboard::FastReverse,
            glue::KEY_FAVORITES => Keyboard::Favorites,
            glue::KEY_FILE => Keyboard::File,
            glue::KEY_FINANCE => Keyboard::Finance,
            glue::KEY_FIND => Keyboard::Find,
            glue::KEY_FIRST => Keyboard::First,
            glue::KEY_FN => Keyboard::Fn,
            glue::KEY_FN_1 => Keyboard::Fn1,
            glue::KEY_FN_2 => Keyboard::Fn2,
            glue::KEY_FN_B => Keyboard::FnB,
            glue::KEY_FN_D => Keyboard::FnD,
            glue::KEY_FN_E => Keyboard::FnE,
            glue::KEY_FN_ESC => Keyboard::FnEsc,
            glue::KEY_FN_F => Keyboard::FnF,
            glue::KEY_FN_F1 => Keyboard::FnF1,
            glue::KEY_FN_F10 => Keyboard::FnF10,
            glue::KEY_FN_F11 => Keyboard::FnF11,
            glue::KEY_FN_F12 => Keyboard::FnF12,
            glue::KEY_FN_F2 => Keyboard::FnF2,
            glue::KEY_FN_F3 => Keyboard::FnF3,
            glue::KEY_FN_F4 => Keyboard::FnF4,
            glue::KEY_FN_F5 => Keyboard::FnF5,
            glue::KEY_FN_F6 => Keyboard::FnF6,
            glue::KEY_FN_F7 => Keyboard::FnF7,
            glue::KEY_FN_F8 => Keyboard::FnF8,
            glue::KEY_FN_F9 => Keyboard::FnF9,
            glue::KEY_FN_S => Keyboard::FnS,
            glue::KEY_FORWARD => Keyboard::Forward,
            glue::KEY_FORWARDMAIL => Keyboard::ForwardMail,
            glue::KEY_FRAMEBACK => Keyboard::Frameback,
            glue::KEY_FRAMEFORWARD => Keyboard::FrameForward,
            glue::KEY_FRONT => Keyboard::Front,
            glue::KEY_FULL_SCREEN => Keyboard::FullScreen,
            glue::KEY_G => Keyboard::G,
            glue::KEY_GAMES => Keyboard::Games,
            glue::KEY_GOTO => Keyboard::Goto,
            glue::KEY_GRAPHICSEDITOR => Keyboard::GraphicsEditor,
            glue::KEY_GRAVE => Keyboard::Grave,
            glue::KEY_GREEN => Keyboard::Green,
            glue::KEY_H => Keyboard::H,
            glue::KEY_HANGEUL => Keyboard::Hangeul,
            glue::KEY_HANJA => Keyboard::Hanja,
            glue::KEY_HELP => Keyboard::Help,
            glue::KEY_HENKAN => Keyboard::Henkan,
            glue::KEY_HIRAGANA => Keyboard::Hiragana,
            glue::KEY_HOME => Keyboard::Home,
            glue::KEY_HOMEPAGE => Keyboard::Homepage,
            glue::KEY_HP => Keyboard::Hp,
            glue::KEY_I => Keyboard::I,
            glue::KEY_IMAGES => Keyboard::Images,
            glue::KEY_INFO => Keyboard::Info,
            glue::KEY_INS_LINE => Keyboard::InsLine,
            glue::KEY_INSERT => Keyboard::Insert,
            glue::KEY_ISO => Keyboard::Iso,
            glue::KEY_J => Keyboard::J,
            glue::KEY_JOURNAL => Keyboard::Journal,
            glue::KEY_K => Keyboard::K,
            glue::KEY_KATAKANA => Keyboard::Katakana,
            glue::KEY_KATAKANAHIRAGANA => Keyboard::KatakanaHiragana,
            glue::KEY_KBD_LAYOUT_NEXT => Keyboard::KbdLayoutNext,
            glue::KEY_KBD_LCD_MENU1 => Keyboard::KbdLcdMenu1,
            glue::KEY_KBD_LCD_MENU2 => Keyboard::KbdLcdMenu2,
            glue::KEY_KBD_LCD_MENU3 => Keyboard::KbdLcdMenu3,
            glue::KEY_KBD_LCD_MENU4 => Keyboard::KbdLcdMenu4,
            glue::KEY_KBD_LCD_MENU5 => Keyboard::KbdLcdMenu5,
            glue::KEY_KBDILLUMDOWN => Keyboard::KbdIllumDown,
            glue::KEY_KBDILLUMTOGGLE => Keyboard::KbdIllumToggle,
            glue::KEY_KBDILLUMUP => Keyboard::KbdIllumUp,
            glue::KEY_KBDINPUTASSIST_ACCEPT => Keyboard::KbdInputAssistAccept,
            glue::KEY_KBDINPUTASSIST_CANCEL => Keyboard::KbdInputAssistCancel,
            glue::KEY_KBDINPUTASSIST_NEXT => Keyboard::KbdInputAssistNext,
            glue::KEY_KBDINPUTASSIST_NEXTGROUP => Keyboard::KbdInputAssistNextgroup,
            glue::KEY_KBDINPUTASSIST_PREV => Keyboard::KbdInputAssistPrev,
            glue::KEY_KBDINPUTASSIST_PREVGROUP => Keyboard::KbdInputAssistPrevgroup,
            glue::KEY_KEYBOARD => Keyboard::Keyboard,
            glue::KEY_KP0 => Keyboard::Kp0,
            glue::KEY_KP1 => Keyboard::Kp1,
            glue::KEY_KP2 => Keyboard::Kp2,
            glue::KEY_KP3 => Keyboard::Kp3,
            glue::KEY_KP4 => Keyboard::Kp4,
            glue::KEY_KP5 => Keyboard::Kp5,
            glue::KEY_KP6 => Keyboard::Kp6,
            glue::KEY_KP7 => Keyboard::Kp7,
            glue::KEY_KP8 => Keyboard::Kp8,
            glue::KEY_KP9 => Keyboard::Kp9,
            glue::KEY_KPASTERISK => Keyboard::KpAsterisk,
            glue::KEY_KPCOMMA => Keyboard::KpComma,
            glue::KEY_KPDOT => Keyboard::KpDot,
            glue::KEY_KPENTER => Keyboard::KpEnter,
            glue::KEY_KPEQUAL => Keyboard::KpEqual,
            glue::KEY_KPJPCOMMA => Keyboard::KpJpComma,
            glue::KEY_KPLEFTPAREN => Keyboard::KpLeftParen,
            glue::KEY_KPMINUS => Keyboard::KpMinus,
            glue::KEY_KPPLUS => Keyboard::KpPlus,
            glue::KEY_KPPLUSMINUS => Keyboard::KpPlusMinus,
            glue::KEY_KPRIGHTPAREN => Keyboard::KpRightParen,
            glue::KEY_KPSLASH => Keyboard::KpSlash,
            glue::KEY_L => Keyboard::L,
            glue::KEY_LANGUAGE => Keyboard::Language,
            glue::KEY_LAST => Keyboard::Last,
            glue::KEY_LEFT => Keyboard::Left,
            glue::KEY_LEFT_DOWN => Keyboard::LeftDown,
            glue::KEY_LEFT_UP => Keyboard::LeftUp,
            glue::KEY_LEFTALT => Keyboard::LeftAlt,
            glue::KEY_LEFTBRACE => Keyboard::LeftBrace,
            glue::KEY_LEFTCTRL => Keyboard::LeftCtrl,
            glue::KEY_LEFTMETA => Keyboard::LeftMeta,
            glue::KEY_LEFTSHIFT => Keyboard::LeftShift,
            glue::KEY_LIGHTS_TOGGLE => Keyboard::LightsToggle,
            glue::KEY_LINEFEED => Keyboard::LineFeed,
            glue::KEY_LIST => Keyboard::List,
            glue::KEY_LOGOFF => Keyboard::LogOff,
            glue::KEY_M => Keyboard::M,
            glue::KEY_MACRO => Keyboard::Macro,
            glue::KEY_MACRO1 => Keyboard::Macro1,
            glue::KEY_MACRO10 => Keyboard::Macro10,
            glue::KEY_MACRO11 => Keyboard::Macro11,
            glue::KEY_MACRO12 => Keyboard::Macro12,
            glue::KEY_MACRO13 => Keyboard::Macro13,
            glue::KEY_MACRO14 => Keyboard::Macro14,
            glue::KEY_MACRO15 => Keyboard::Macro15,
            glue::KEY_MACRO16 => Keyboard::Macro16,
            glue::KEY_MACRO17 => Keyboard::Macro17,
            glue::KEY_MACRO18 => Keyboard::Macro18,
            glue::KEY_MACRO19 => Keyboard::Macro19,
            glue::KEY_MACRO2 => Keyboard::Macro2,
            glue::KEY_MACRO20 => Keyboard::Macro20,
            glue::KEY_MACRO21 => Keyboard::Macro21,
            glue::KEY_MACRO22 => Keyboard::Macro22,
            glue::KEY_MACRO23 => Keyboard::Macro23,
            glue::KEY_MACRO24 => Keyboard::Macro24,
            glue::KEY_MACRO25 => Keyboard::Macro25,
            glue::KEY_MACRO26 => Keyboard::Macro26,
            glue::KEY_MACRO27 => Keyboard::Macro27,
            glue::KEY_MACRO28 => Keyboard::Macro28,
            glue::KEY_MACRO29 => Keyboard::Macro29,
            glue::KEY_MACRO3 => Keyboard::Macro3,
            glue::KEY_MACRO30 => Keyboard::Macro30,
            glue::KEY_MACRO4 => Keyboard::Macro4,
            glue::KEY_MACRO5 => Keyboard::Macro5,
            glue::KEY_MACRO6 => Keyboard::Macro6,
            glue::KEY_MACRO7 => Keyboard::Macro7,
            glue::KEY_MACRO8 => Keyboard::Macro8,
            glue::KEY_MACRO9 => Keyboard::Macro9,
            glue::KEY_MACRO_PRESET1 => Keyboard::MacroPreset1,
            glue::KEY_MACRO_PRESET2 => Keyboard::MacroPreset2,
            glue::KEY_MACRO_PRESET3 => Keyboard::MacroPreset3,
            glue::KEY_MACRO_PRESET_CYCLE => Keyboard::MacroPresetCycle,
            glue::KEY_MACRO_RECORD_START => Keyboard::MacroRecordStart,
            glue::KEY_MACRO_RECORD_STOP => Keyboard::MacroRecordStop,
            glue::KEY_MAIL => Keyboard::Mail,
            glue::KEY_MEDIA => Keyboard::Media,
            glue::KEY_MEDIA_REPEAT => Keyboard::MediaRepeat,
            glue::KEY_MEDIA_TOP_MENU => Keyboard::MediaTopMenu,
            glue::KEY_MEMO => Keyboard::Memo,
            glue::KEY_MENU => Keyboard::Menu,
            glue::KEY_MESSENGER => Keyboard::Messenger,
            glue::KEY_MHP => Keyboard::Mhp,
            glue::KEY_MICMUTE => Keyboard::MicMute,
            glue::KEY_MINUS => Keyboard::Minus,
            glue::KEY_MODE => Keyboard::Mode,
            glue::KEY_MOVE => Keyboard::Move,
            glue::KEY_MP3 => Keyboard::Mp3,
            glue::KEY_MSDOS => Keyboard::MsDos,
            glue::KEY_MUHENKAN => Keyboard::Muhenkan,
            glue::KEY_MUTE => Keyboard::Mute,
            glue::KEY_N => Keyboard::N,
            glue::KEY_0 => Keyboard::N0,
            glue::KEY_1 => Keyboard::N1,
            glue::KEY_102ND => Keyboard::N102nd,
            glue::KEY_10CHANNELSDOWN => Keyboard::N10ChannelsDown,
            glue::KEY_10CHANNELSUP => Keyboard::N10ChannelsUp,
            glue::KEY_2 => Keyboard::N2,
            glue::KEY_3 => Keyboard::N3,
            glue::KEY_3D_MODE => Keyboard::N3dMode,
            glue::KEY_4 => Keyboard::N4,
            glue::KEY_5 => Keyboard::N5,
            glue::KEY_6 => Keyboard::N6,
            glue::KEY_7 => Keyboard::N7,
            glue::KEY_8 => Keyboard::N8,
            glue::KEY_9 => Keyboard::N9,
            glue::KEY_NEW => Keyboard::New,
            glue::KEY_NEWS => Keyboard::News,
            glue::KEY_NEXT => Keyboard::Next,
            glue::KEY_NEXT_FAVORITE => Keyboard::NextFavorite,
            glue::KEY_NEXTSONG => Keyboard::NextSong,
            glue::KEY_NUMERIC_0 => Keyboard::Numeric0,
            glue::KEY_NUMERIC_1 => Keyboard::Numeric1,
            glue::KEY_NUMERIC_11 => Keyboard::Numeric11,
            glue::KEY_NUMERIC_12 => Keyboard::Numeric12,
            glue::KEY_NUMERIC_2 => Keyboard::Numeric2,
            glue::KEY_NUMERIC_3 => Keyboard::Numeric3,
            glue::KEY_NUMERIC_4 => Keyboard::Numeric4,
            glue::KEY_NUMERIC_5 => Keyboard::Numeric5,
            glue::KEY_NUMERIC_6 => Keyboard::Numeric6,
            glue::KEY_NUMERIC_7 => Keyboard::Numeric7,
            glue::KEY_NUMERIC_8 => Keyboard::Numeric8,
            glue::KEY_NUMERIC_9 => Keyboard::Numeric9,
            glue::KEY_NUMERIC_A => Keyboard::NumericA,
            glue::KEY_NUMERIC_B => Keyboard::NumericB,
            glue::KEY_NUMERIC_C => Keyboard::NumericC,
            glue::KEY_NUMERIC_D => Keyboard::NumericD,
            glue::KEY_NUMERIC_POUND => Keyboard::NumericPound,
            glue::KEY_NUMERIC_STAR => Keyboard::NumericStar,
            glue::KEY_NUMLOCK => Keyboard::NumLock,
            glue::KEY_O => Keyboard::O,
            glue::KEY_OK => Keyboard::Ok,
            glue::KEY_ONSCREEN_KEYBOARD => Keyboard::OnscreenKeyboard,
            glue::KEY_OPEN => Keyboard::Open,
            glue::KEY_OPTION => Keyboard::Option,
            glue::KEY_P => Keyboard::P,
            glue::KEY_PAGEDOWN => Keyboard::PageDown,
            glue::KEY_PAGEUP => Keyboard::PageUp,
            glue::KEY_PASTE => Keyboard::Paste,
            glue::KEY_PAUSE => Keyboard::Pause,
            glue::KEY_PAUSE_RECORD => Keyboard::PauseRecord,
            glue::KEY_PAUSECD => Keyboard::PauseCd,
            glue::KEY_PC => Keyboard::Pc,
            glue::KEY_PHONE => Keyboard::Phone,
            glue::KEY_PLAY => Keyboard::Play,
            glue::KEY_PLAYCD => Keyboard::PlayCd,
            glue::KEY_PLAYER => Keyboard::Player,
            glue::KEY_PLAYPAUSE => Keyboard::PlayPause,
            glue::KEY_POWER => Keyboard::Power,
            glue::KEY_POWER2 => Keyboard::Power2,
            glue::KEY_PRESENTATION => Keyboard::Presentation,
            glue::KEY_PREVIOUS => Keyboard::Previous,
            glue::KEY_PREVIOUSSONG => Keyboard::PreviousSong,
            glue::KEY_PRINT => Keyboard::Print,
            glue::KEY_PRIVACY_SCREEN_TOGGLE => Keyboard::PrivacyScreenToggle,
            glue::KEY_PROG1 => Keyboard::Prog1,
            glue::KEY_PROG2 => Keyboard::Prog2,
            glue::KEY_PROG3 => Keyboard::Prog3,
            glue::KEY_PROG4 => Keyboard::Prog4,
            glue::KEY_PROGRAM => Keyboard::Program,
            glue::KEY_PROPS => Keyboard::Props,
            glue::KEY_PVR => Keyboard::Pvr,
            glue::KEY_Q => Keyboard::Q,
            glue::KEY_QUESTION => Keyboard::Question,
            glue::KEY_R => Keyboard::R,
            glue::KEY_RADIO => Keyboard::Radio,
            glue::KEY_RECORD => Keyboard::Record,
            glue::KEY_RED => Keyboard::Red,
            glue::KEY_REDO => Keyboard::Redo,
            glue::KEY_REFRESH => Keyboard::Refresh,
            glue::KEY_REPLY => Keyboard::Reply,
            glue::KEY_RESERVED => Keyboard::Reserved,
            glue::KEY_RESTART => Keyboard::Restart,
            glue::KEY_REWIND => Keyboard::Rewind,
            glue::KEY_RFKILL => Keyboard::RfKill,
            glue::KEY_RIGHT => Keyboard::Right,
            glue::KEY_RIGHT_DOWN => Keyboard::RightDown,
            glue::KEY_RIGHT_UP => Keyboard::RightUp,
            glue::KEY_RIGHTALT => Keyboard::RightAlt,
            glue::KEY_RIGHTBRACE => Keyboard::RightBrace,
            glue::KEY_RIGHTCTRL => Keyboard::RightCtrl,
            glue::KEY_RIGHTMETA => Keyboard::RightMeta,
            glue::KEY_RIGHTSHIFT => Keyboard::RightShift,
            glue::KEY_RO => Keyboard::Ro,
            glue::KEY_ROOT_MENU => Keyboard::RootMenu,
            glue::KEY_ROTATE_DISPLAY => Keyboard::RotateDisplay,
            glue::KEY_ROTATE_LOCK_TOGGLE => Keyboard::RotateLockToggle,
            glue::KEY_S => Keyboard::S,
            glue::KEY_SAT => Keyboard::Sat,
            glue::KEY_SAT2 => Keyboard::Sat2,
            glue::KEY_SAVE => Keyboard::Save,
            glue::KEY_SCALE => Keyboard::Scale,
            glue::KEY_SCREENSAVER => Keyboard::Screensaver,
            glue::KEY_SCROLLDOWN => Keyboard::ScrollDown,
            glue::KEY_SCROLLLOCK => Keyboard::ScrollLock,
            glue::KEY_SCROLLUP => Keyboard::ScrollUp,
            glue::KEY_SEARCH => Keyboard::Search,
            glue::KEY_SELECT => Keyboard::Select,
            glue::KEY_SELECTIVE_SCREENSHOT => Keyboard::SelectiveScreenshot,
            glue::KEY_SEMICOLON => Keyboard::Semicolon,
            glue::KEY_SEND => Keyboard::Send,
            glue::KEY_SENDFILE => Keyboard::SendFile,
            glue::KEY_SETUP => Keyboard::Setup,
            glue::KEY_SHOP => Keyboard::Shop,
            glue::KEY_SHUFFLE => Keyboard::Shuffle,
            glue::KEY_SLASH => Keyboard::Slash,
            glue::KEY_SLEEP => Keyboard::Sleep,
            glue::KEY_SLOW => Keyboard::Slow,
            glue::KEY_SLOWREVERSE => Keyboard::SlowReverse,
            glue::KEY_SOUND => Keyboard::Sound,
            glue::KEY_SPACE => Keyboard::Space,
            glue::KEY_SPELLCHECK => Keyboard::Spellcheck,
            glue::KEY_SPORT => Keyboard::Sport,
            glue::KEY_SPREADSHEET => Keyboard::Spreadsheet,
            glue::KEY_STOP => Keyboard::Stop,
            glue::KEY_STOP_RECORD => Keyboard::StopRecord,
            glue::KEY_STOPCD => Keyboard::StopCd,
            glue::KEY_SUBTITLE => Keyboard::Subtitle,
            glue::KEY_SUSPEND => Keyboard::Suspend,
            glue::KEY_SWITCHVIDEOMODE => Keyboard::SwitchVideoMode,
            glue::KEY_SYSRQ => Keyboard::SysRq,
            glue::KEY_T => Keyboard::T,
            glue::KEY_TAB => Keyboard::Tab,
            glue::KEY_TAPE => Keyboard::Tape,
            glue::KEY_TASKMANAGER => Keyboard::TaskManager,
            glue::KEY_TEEN => Keyboard::Teen,
            glue::KEY_TEXT => Keyboard::Text,
            glue::KEY_TIME => Keyboard::Time,
            glue::KEY_TITLE => Keyboard::Title,
            glue::KEY_TOUCHPAD_OFF => Keyboard::TouchpadOff,
            glue::KEY_TOUCHPAD_ON => Keyboard::TouchpadOn,
            glue::KEY_TOUCHPAD_TOGGLE => Keyboard::TouchpadToggle,
            glue::KEY_TUNER => Keyboard::Tuner,
            glue::KEY_TV => Keyboard::Tv,
            glue::KEY_TV2 => Keyboard::Tv2,
            glue::KEY_TWEN => Keyboard::Twen,
            glue::KEY_U => Keyboard::U,
            glue::KEY_UNDO => Keyboard::Undo,
            glue::KEY_UNKNOWN => Keyboard::Unknown,
            glue::KEY_UNMUTE => Keyboard::Unmute,
            glue::KEY_UP => Keyboard::Up,
            glue::KEY_UWB => Keyboard::Uwb,
            glue::KEY_V => Keyboard::V,
            glue::KEY_VCR => Keyboard::Vcr,
            glue::KEY_VCR2 => Keyboard::Vcr2,
            glue::KEY_VENDOR => Keyboard::Vendor,
            glue::KEY_VIDEO => Keyboard::Video,
            glue::KEY_VIDEO_NEXT => Keyboard::VideoNext,
            glue::KEY_VIDEO_PREV => Keyboard::VideoPrev,
            glue::KEY_VIDEOPHONE => Keyboard::VideoPhone,
            glue::KEY_VOD => Keyboard::Vod,
            glue::KEY_VOICECOMMAND => Keyboard::VoiceCommand,
            glue::KEY_VOICEMAIL => Keyboard::VoiceMail,
            glue::KEY_VOLUMEDOWN => Keyboard::VolumeDown,
            glue::KEY_VOLUMEUP => Keyboard::VolumeUp,
            glue::KEY_W => Keyboard::W,
            glue::KEY_WAKEUP => Keyboard::WakeUp,
            glue::KEY_WLAN => Keyboard::Wlan,
            glue::KEY_WORDPROCESSOR => Keyboard::WordProcessor,
            glue::KEY_WPS_BUTTON => Keyboard::WpsButton,
            glue::KEY_WWAN => Keyboard::Wwan,
            glue::KEY_WWW => Keyboard::Www,
            glue::KEY_X => Keyboard::X,
            glue::KEY_XFER => Keyboard::Xfer,
            glue::KEY_Y => Keyboard::Y,
            glue::KEY_YELLOW => Keyboard::Yellow,
            glue::KEY_YEN => Keyboard::Yen,
            glue::KEY_Z => Keyboard::Z,
            glue::KEY_ZENKAKUHANKAKU => Keyboard::ZenkakuHankaku,
            glue::KEY_ZOOMIN => Keyboard::ZoomIn,
            glue::KEY_ZOOMOUT => Keyboard::ZoomOut,
            glue::KEY_ZOOMRESET => Keyboard::ZoomReset,
            _ => return None,
        };

        Some(keyboard)
    }
}
