use crate::convert::Convert;
use crate::glue;

use serde::{Deserialize, Serialize};

#[derive(Clone, Copy, Debug, Eq, PartialEq, Hash, Serialize, Deserialize)]
pub enum Button {
    B0,
    B1,
    B2,
    B3,
    B4,
    B5,
    B6,
    B7,
    B8,
    B9,
    Left,
    Right,
    Middle,
    Side,
    Extra,
    Forward,
    Back,
    Task,
    Trigger,
    Thumb,
    Thumb2,
    Top,
    Top2,
    Pinkie,
    Base,
    Base2,
    Base3,
    Base4,
    Base5,
    Base6,
    Dead,
    South,
    East,
    C,
    North,
    West,
    Z,
    TL,
    Tr,
    Tl2,
    Tr2,
    Select,
    Start,
    Mode,
    ThumbL,
    ThumbR,
    ToolPen,
    ToolRubber,
    ToolBrush,
    ToolPencil,
    ToolAirbrush,
    ToolFinger,
    ToolMouse,
    ToolLens,
    QuintTap,
    Stylus3,
    Touch,
    Stylus,
    Stylus2,
    DoubleTap,
    TripleTap,
    QuadTap,
    GearDown,
    GearUp,
    DPadUp,
    DPadDown,
    DPadLeft,
    DPadRight,
    TriggerHappy1,
    TrigerHappy2,
    TriggerHappy3,
    TriggerHappy4,
    TriggerHappy5,
    TriggerHappy6,
    TriggerHappy7,
    TriggerHappy8,
    TriggerHappy9,
    TriggerHappy10,
    TriggerHappy11,
    TriggerHappy12,
    TriggerHappy13,
    TriggerHappy14,
    TriggerHappy15,
    TriggerHappy16,
    TriggerHappy17,
    TriggerHappy18,
    TriggerHappy19,
    TriggerHappy20,
    TriggerHappy21,
    TriggerHappy22,
    TriggerHappy23,
    TriggerHappy24,
    TriggerHappy25,
    TriggerHappy26,
    TriggerHappy27,
    TriggerHappy28,
    TriggerHappy29,
    TriggerHappy30,
    TriggerHappy31,
    TriggerHappy32,
    TriggerHappy33,
    TriggerHappy34,
    TriggerHappy35,
    TriggerHappy36,
    TriggerHappy37,
    TriggerHappy38,
    TriggerHappy39,
    TriggerHappy40,
}

impl Convert for Button {
    type Raw = u16;

    fn to_raw(&self) -> Option<Self::Raw> {
        let raw = match self {
            Self::B0 => glue::BTN_0,
            Self::B1 => glue::BTN_1,
            Self::B2 => glue::BTN_2,
            Self::B3 => glue::BTN_3,
            Self::B4 => glue::BTN_4,
            Self::B5 => glue::BTN_5,
            Self::B6 => glue::BTN_6,
            Self::B7 => glue::BTN_7,
            Self::B8 => glue::BTN_8,
            Self::B9 => glue::BTN_9,
            Self::Left => glue::BTN_LEFT,
            Self::Right => glue::BTN_RIGHT,
            Self::Middle => glue::BTN_MIDDLE,
            Self::Side => glue::BTN_SIDE,
            Self::Extra => glue::BTN_EXTRA,
            Self::Forward => glue::BTN_FORWARD,
            Self::Back => glue::BTN_BACK,
            Self::Task => glue::BTN_TASK,
            Self::Trigger => glue::BTN_TRIGGER,
            Self::Thumb => glue::BTN_THUMB,
            Self::Thumb2 => glue::BTN_THUMB2,
            Self::Top => glue::BTN_TOP,
            Self::Top2 => glue::BTN_TOP2,
            Self::Pinkie => glue::BTN_PINKIE,
            Self::Base => glue::BTN_BASE,
            Self::Base2 => glue::BTN_BASE2,
            Self::Base3 => glue::BTN_BASE3,
            Self::Base4 => glue::BTN_BASE4,
            Self::Base5 => glue::BTN_BASE5,
            Self::Base6 => glue::BTN_BASE6,
            Self::Dead => glue::BTN_DEAD,
            Self::South => glue::BTN_SOUTH,
            Self::East => glue::BTN_EAST,
            Self::C => glue::BTN_C,
            Self::North => glue::BTN_NORTH,
            Self::West => glue::BTN_WEST,
            Self::Z => glue::BTN_Z,
            Self::TL => glue::BTN_TL,
            Self::Tr => glue::BTN_TR,
            Self::Tl2 => glue::BTN_TL2,
            Self::Tr2 => glue::BTN_TR2,
            Self::Select => glue::BTN_SELECT,
            Self::Start => glue::BTN_START,
            Self::Mode => glue::BTN_MODE,
            Self::ThumbL => glue::BTN_THUMBL,
            Self::ThumbR => glue::BTN_THUMBR,
            Self::ToolPen => glue::BTN_TOOL_PEN,
            Self::ToolRubber => glue::BTN_TOOL_RUBBER,
            Self::ToolBrush => glue::BTN_TOOL_BRUSH,
            Self::ToolPencil => glue::BTN_TOOL_PENCIL,
            Self::ToolAirbrush => glue::BTN_TOOL_AIRBRUSH,
            Self::ToolFinger => glue::BTN_TOOL_FINGER,
            Self::ToolMouse => glue::BTN_TOOL_MOUSE,
            Self::ToolLens => glue::BTN_TOOL_LENS,
            Self::QuintTap => glue::BTN_TOOL_QUINTTAP,
            Self::Stylus3 => glue::BTN_STYLUS3,
            Self::Touch => glue::BTN_TOUCH,
            Self::Stylus => glue::BTN_STYLUS,
            Self::Stylus2 => glue::BTN_STYLUS2,
            Self::DoubleTap => glue::BTN_TOOL_DOUBLETAP,
            Self::TripleTap => glue::BTN_TOOL_TRIPLETAP,
            Self::QuadTap => glue::BTN_TOOL_QUADTAP,
            Self::GearDown => glue::BTN_GEAR_DOWN,
            Self::GearUp => glue::BTN_GEAR_UP,
            Self::DPadUp => glue::BTN_DPAD_UP,
            Self::DPadDown => glue::BTN_DPAD_DOWN,
            Self::DPadLeft => glue::BTN_DPAD_LEFT,
            Self::DPadRight => glue::BTN_DPAD_RIGHT,
            Self::TriggerHappy1 => glue::BTN_TRIGGER_HAPPY1,
            Self::TrigerHappy2 => glue::BTN_TRIGGER_HAPPY2,
            Self::TriggerHappy3 => glue::BTN_TRIGGER_HAPPY3,
            Self::TriggerHappy4 => glue::BTN_TRIGGER_HAPPY4,
            Self::TriggerHappy5 => glue::BTN_TRIGGER_HAPPY5,
            Self::TriggerHappy6 => glue::BTN_TRIGGER_HAPPY6,
            Self::TriggerHappy7 => glue::BTN_TRIGGER_HAPPY7,
            Self::TriggerHappy8 => glue::BTN_TRIGGER_HAPPY8,
            Self::TriggerHappy9 => glue::BTN_TRIGGER_HAPPY9,
            Self::TriggerHappy10 => glue::BTN_TRIGGER_HAPPY10,
            Self::TriggerHappy11 => glue::BTN_TRIGGER_HAPPY11,
            Self::TriggerHappy12 => glue::BTN_TRIGGER_HAPPY12,
            Self::TriggerHappy13 => glue::BTN_TRIGGER_HAPPY13,
            Self::TriggerHappy14 => glue::BTN_TRIGGER_HAPPY14,
            Self::TriggerHappy15 => glue::BTN_TRIGGER_HAPPY15,
            Self::TriggerHappy16 => glue::BTN_TRIGGER_HAPPY16,
            Self::TriggerHappy17 => glue::BTN_TRIGGER_HAPPY17,
            Self::TriggerHappy18 => glue::BTN_TRIGGER_HAPPY18,
            Self::TriggerHappy19 => glue::BTN_TRIGGER_HAPPY19,
            Self::TriggerHappy20 => glue::BTN_TRIGGER_HAPPY20,
            Self::TriggerHappy21 => glue::BTN_TRIGGER_HAPPY21,
            Self::TriggerHappy22 => glue::BTN_TRIGGER_HAPPY22,
            Self::TriggerHappy23 => glue::BTN_TRIGGER_HAPPY23,
            Self::TriggerHappy24 => glue::BTN_TRIGGER_HAPPY24,
            Self::TriggerHappy25 => glue::BTN_TRIGGER_HAPPY25,
            Self::TriggerHappy26 => glue::BTN_TRIGGER_HAPPY26,
            Self::TriggerHappy27 => glue::BTN_TRIGGER_HAPPY27,
            Self::TriggerHappy28 => glue::BTN_TRIGGER_HAPPY28,
            Self::TriggerHappy29 => glue::BTN_TRIGGER_HAPPY29,
            Self::TriggerHappy30 => glue::BTN_TRIGGER_HAPPY30,
            Self::TriggerHappy31 => glue::BTN_TRIGGER_HAPPY31,
            Self::TriggerHappy32 => glue::BTN_TRIGGER_HAPPY32,
            Self::TriggerHappy33 => glue::BTN_TRIGGER_HAPPY33,
            Self::TriggerHappy34 => glue::BTN_TRIGGER_HAPPY34,
            Self::TriggerHappy35 => glue::BTN_TRIGGER_HAPPY35,
            Self::TriggerHappy36 => glue::BTN_TRIGGER_HAPPY36,
            Self::TriggerHappy37 => glue::BTN_TRIGGER_HAPPY37,
            Self::TriggerHappy38 => glue::BTN_TRIGGER_HAPPY38,
            Self::TriggerHappy39 => glue::BTN_TRIGGER_HAPPY39,
            Self::TriggerHappy40 => glue::BTN_TRIGGER_HAPPY40,
        };

        Some(raw as _)
    }

    fn from_raw(raw: Self::Raw) -> Option<Self> {
        let button = match raw as _ {
            glue::BTN_0 => Self::B0,
            glue::BTN_1 => Self::B1,
            glue::BTN_2 => Self::B2,
            glue::BTN_3 => Self::B3,
            glue::BTN_4 => Self::B4,
            glue::BTN_5 => Self::B5,
            glue::BTN_6 => Self::B6,
            glue::BTN_7 => Self::B7,
            glue::BTN_8 => Self::B8,
            glue::BTN_9 => Self::B9,
            glue::BTN_LEFT => Self::Left,
            glue::BTN_RIGHT => Self::Right,
            glue::BTN_MIDDLE => Self::Middle,
            glue::BTN_SIDE => Self::Side,
            glue::BTN_EXTRA => Self::Extra,
            glue::BTN_FORWARD => Self::Forward,
            glue::BTN_BACK => Self::Back,
            glue::BTN_TASK => Self::Task,
            glue::BTN_TRIGGER => Self::Trigger,
            glue::BTN_THUMB => Self::Thumb,
            glue::BTN_THUMB2 => Self::Thumb2,
            glue::BTN_TOP => Self::Top,
            glue::BTN_TOP2 => Self::Top2,
            glue::BTN_PINKIE => Self::Pinkie,
            glue::BTN_BASE => Self::Base,
            glue::BTN_BASE2 => Self::Base2,
            glue::BTN_BASE3 => Self::Base3,
            glue::BTN_BASE4 => Self::Base4,
            glue::BTN_BASE5 => Self::Base5,
            glue::BTN_BASE6 => Self::Base6,
            glue::BTN_DEAD => Self::Dead,
            glue::BTN_SOUTH => Self::South,
            glue::BTN_EAST => Self::East,
            glue::BTN_C => Self::C,
            glue::BTN_NORTH => Self::North,
            glue::BTN_WEST => Self::West,
            glue::BTN_Z => Self::Z,
            glue::BTN_TL => Self::TL,
            glue::BTN_TR => Self::Tr,
            glue::BTN_TL2 => Self::Tl2,
            glue::BTN_TR2 => Self::Tr2,
            glue::BTN_SELECT => Self::Select,
            glue::BTN_START => Self::Start,
            glue::BTN_MODE => Self::Mode,
            glue::BTN_THUMBL => Self::ThumbL,
            glue::BTN_THUMBR => Self::ThumbR,
            glue::BTN_TOOL_PEN => Self::ToolPen,
            glue::BTN_TOOL_RUBBER => Self::ToolRubber,
            glue::BTN_TOOL_BRUSH => Self::ToolBrush,
            glue::BTN_TOOL_PENCIL => Self::ToolPencil,
            glue::BTN_TOOL_AIRBRUSH => Self::ToolAirbrush,
            glue::BTN_TOOL_FINGER => Self::ToolFinger,
            glue::BTN_TOOL_MOUSE => Self::ToolMouse,
            glue::BTN_TOOL_LENS => Self::ToolLens,
            glue::BTN_TOOL_QUINTTAP => Self::QuintTap,
            glue::BTN_STYLUS3 => Self::Stylus3,
            glue::BTN_TOUCH => Self::Touch,
            glue::BTN_STYLUS => Self::Stylus,
            glue::BTN_STYLUS2 => Self::Stylus2,
            glue::BTN_TOOL_DOUBLETAP => Self::DoubleTap,
            glue::BTN_TOOL_TRIPLETAP => Self::TripleTap,
            glue::BTN_TOOL_QUADTAP => Self::QuadTap,
            glue::BTN_GEAR_DOWN => Self::GearDown,
            glue::BTN_GEAR_UP => Self::GearUp,
            glue::BTN_DPAD_UP => Self::DPadUp,
            glue::BTN_DPAD_DOWN => Self::DPadDown,
            glue::BTN_DPAD_LEFT => Self::DPadLeft,
            glue::BTN_DPAD_RIGHT => Self::DPadRight,
            glue::BTN_TRIGGER_HAPPY1 => Self::TriggerHappy1,
            glue::BTN_TRIGGER_HAPPY2 => Self::TrigerHappy2,
            glue::BTN_TRIGGER_HAPPY3 => Self::TriggerHappy3,
            glue::BTN_TRIGGER_HAPPY4 => Self::TriggerHappy4,
            glue::BTN_TRIGGER_HAPPY5 => Self::TriggerHappy5,
            glue::BTN_TRIGGER_HAPPY6 => Self::TriggerHappy6,
            glue::BTN_TRIGGER_HAPPY7 => Self::TriggerHappy7,
            glue::BTN_TRIGGER_HAPPY8 => Self::TriggerHappy8,
            glue::BTN_TRIGGER_HAPPY9 => Self::TriggerHappy9,
            glue::BTN_TRIGGER_HAPPY10 => Self::TriggerHappy10,
            glue::BTN_TRIGGER_HAPPY11 => Self::TriggerHappy11,
            glue::BTN_TRIGGER_HAPPY12 => Self::TriggerHappy12,
            glue::BTN_TRIGGER_HAPPY13 => Self::TriggerHappy13,
            glue::BTN_TRIGGER_HAPPY14 => Self::TriggerHappy14,
            glue::BTN_TRIGGER_HAPPY15 => Self::TriggerHappy15,
            glue::BTN_TRIGGER_HAPPY16 => Self::TriggerHappy16,
            glue::BTN_TRIGGER_HAPPY17 => Self::TriggerHappy17,
            glue::BTN_TRIGGER_HAPPY18 => Self::TriggerHappy18,
            glue::BTN_TRIGGER_HAPPY19 => Self::TriggerHappy19,
            glue::BTN_TRIGGER_HAPPY20 => Self::TriggerHappy20,
            glue::BTN_TRIGGER_HAPPY21 => Self::TriggerHappy21,
            glue::BTN_TRIGGER_HAPPY22 => Self::TriggerHappy22,
            glue::BTN_TRIGGER_HAPPY23 => Self::TriggerHappy23,
            glue::BTN_TRIGGER_HAPPY24 => Self::TriggerHappy24,
            glue::BTN_TRIGGER_HAPPY25 => Self::TriggerHappy25,
            glue::BTN_TRIGGER_HAPPY26 => Self::TriggerHappy26,
            glue::BTN_TRIGGER_HAPPY27 => Self::TriggerHappy27,
            glue::BTN_TRIGGER_HAPPY28 => Self::TriggerHappy28,
            glue::BTN_TRIGGER_HAPPY29 => Self::TriggerHappy29,
            glue::BTN_TRIGGER_HAPPY30 => Self::TriggerHappy30,
            glue::BTN_TRIGGER_HAPPY31 => Self::TriggerHappy31,
            glue::BTN_TRIGGER_HAPPY32 => Self::TriggerHappy32,
            glue::BTN_TRIGGER_HAPPY33 => Self::TriggerHappy33,
            glue::BTN_TRIGGER_HAPPY34 => Self::TriggerHappy34,
            glue::BTN_TRIGGER_HAPPY35 => Self::TriggerHappy35,
            glue::BTN_TRIGGER_HAPPY36 => Self::TriggerHappy36,
            glue::BTN_TRIGGER_HAPPY37 => Self::TriggerHappy37,
            glue::BTN_TRIGGER_HAPPY38 => Self::TriggerHappy38,
            glue::BTN_TRIGGER_HAPPY39 => Self::TriggerHappy39,
            glue::BTN_TRIGGER_HAPPY40 => Self::TriggerHappy40,
            _ => return None,
        };

        Some(button)
    }
}
