/*
 * Copyright 2016-2017 Axioma srl.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.holonplatform.core.messaging;

import java.util.Map;
import java.util.Optional;

import com.holonplatform.core.internal.utils.ObjectUtils;

/**
 * Generic message headers representation.
 * 
 * @param <H> Message headers value type
 * 
 * @since 5.0.0
 */
public interface MessageHeaders<H> {

	/**
	 * Get message headers. This method should never return <code>null</code>.
	 * @return Message headers, or an empty map if message has no headers
	 */
	Map<String, H> getHeaders();

	/**
	 * Get header value using given header <code>name</code>
	 * @param name Header name
	 * @return Optional Header value. Returns an empty Optional if header with given name is not present or has no value
	 */
	default Optional<H> getHeader(String name) {
		ObjectUtils.argumentNotNull(name, "Header name must be not null");
		return Optional.ofNullable(getHeaders().get(name));
	}

}
