package com.wt.hibernate.one_to_one.foreign;

import static org.junit.Assert.*;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;

import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.jdbc.Work;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class HibernateText {

	private SessionFactory sessionFactory;
	private Session session;
	private Transaction transaction;

	@Before
	public void init() {
		// 
		// System.out.println("init");

		Configuration configuration = new Configuration().configure();
		ServiceRegistry serviceRegistry = new ServiceRegistryBuilder()
				.applySettings(configuration.getProperties())
				.buildServiceRegistry();

		sessionFactory = configuration.buildSessionFactory(serviceRegistry);

		session = sessionFactory.openSession();

		transaction = session.beginTransaction();
	}

	@After
	public void destroy() {
		// 
		// System.out.println("destroy");

		transaction.commit();
		session.close();
		sessionFactory.close();
	}
	
	@Test
	public void testGet2() {
		// ڲѯûʵʹӲѯһѯĶ
		// Ѿгʼ
		Manager manager = (Manager) session.get(Manager.class, 1);
		System.out.println(manager.getManagerName());
		System.out.println(manager.getDepartment().getDepartmentName());
	}
	
	@Test
	public void testGet() {
		// 1. Ĭ£Թʹ
		Department department = (Department) session.get(Department.class, 1);
		System.out.println(department.getDepartmentName());

		// 2. Իص쳣
//		session.close();
//		Manager manager = new Manager();
//		System.out.println(manager.getManagerName());

		// 3. ѯ Manager Ӧ department.manager_id = manager.manager_id
		// Ӧ department.department_id = manager.manager_id 
		Manager manager = department.getManager();
		System.out.println(manager.getManagerName());
	}
	
	@Test
	public void test(){
		
		Department department = new Department();
		department.setDepartmentName("AA");
		
		Manager manager = new Manager();
		manager.setManagerName("Manager_AA");
		
		// 趨ϵ
		department.setManager(manager);
		manager.setDepartment(department);
		
		//  
		// ȱûǸ update 
		session.save(manager);
		session.save(department);
		
	}
	
}
