package com.wt.hibernate.n_to_1.both;

import static org.junit.Assert.*;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;

import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.jdbc.Work;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class HibernateText {

	private SessionFactory sessionFactory;
	private Session session;
	private Transaction transaction;

	@Before
	public void init() {
		// 
		// System.out.println("init");

		Configuration configuration = new Configuration().configure();
		ServiceRegistry serviceRegistry = new ServiceRegistryBuilder()
				.applySettings(configuration.getProperties())
				.buildServiceRegistry();

		sessionFactory = configuration.buildSessionFactory(serviceRegistry);

		session = sessionFactory.openSession();

		transaction = session.beginTransaction();
	}

	@After
	public void destroy() {
		// 
		// System.out.println("destroy");

		transaction.commit();
		session.close();
		sessionFactory.close();
	}
	
	@Test
	public void testCasecade() {
		Customer customer = (Customer) session.get(Customer.class, 2);
		customer.getOrders().clear();
	}
	
	@Test
	public void testDelete() {
		// ڲ趨ϵ£ 1 һ˵Ķ   n ãֱɾ 1 һ˵Ķ 
		Customer customer = (Customer) session.get(Customer.class, 1);
		session.delete(customer);
	}
	
	@Test
	public void testUpdate2() {
		Customer customer = (Customer) session.get(Customer.class, 1);
		customer.getOrders().iterator().next().setOrderName("GGG");
	}
	
	@Test
	public void testUpdate() {
		Order order = (Order) session.get(Order.class, 1);
		order.getCustomer().setCustomerName("AAA");
	}
	
	@Test
	public void testOneToManyGet() {
		// 1. Զһ˵ļʹӳټ
		Customer customer = (Customer) session.get(Customer.class, 5);
		System.out.println(customer.getCustomerName());
		
		// 2. ضһ˵ļ Hibernate õļ
		// ӳټغʹŴĹ
		System.out.println(customer.getOrders().getClass());
		
		// 3. ܻ׳ LazyInitializationException 쳣
		System.out.println(customer.getOrders().size());
		
		// ѯĽǷΪӳļͨorder-by="ORDER_NAME DESC"
		//  order ORDER_NAMEн
		Set<Order> orders = customer.getOrders();
		
		for (Order order : orders) {
			System.out.println("--------------");
			System.out.println(order.getOrderName());
		}
		
		// 4. ҪʹüԪصʱгʼ
	}
	
	@Test
	public void testManyToOneGet() {
		// 1. ѯһ˵һĬ£ֻѯ˶һ˵Ķ
		// ûвѯĹһһ˵Ķӳټ
		Order order = (Order) session.get(Order.class, 1);
		System.out.println(order.getOrderName());
		
		// 2. ҪʹõĶʱŷͶӦ SQL 
		Customer customer = order.getCustomer();
		System.out.println(customer.getCustomerName());
		
		
		// 3. ڲѯ Customer ʱɶһ˵һһʱ
		// ܻᷢ LazyInitializationException 쳣
		
		// 4. ȡ Order ʱĬ£ Customer һ
		System.out.println(customer.getClass().getName());
	}
	
	@Test
	public void testManyToOneBothSave() {
		Customer customer = new Customer();
		customer.setCustomerName("AA");
		
		Order order1 = new Order(); 
		order1.setOrderName("ORDER-1");
		
		Order order2 = new Order();
		order2.setOrderName("ORDER-2");

		// 趨ϵ
		order1.setCustomer(customer);
		order2.setCustomer(customer);
		
		customer.getOrders().add(order1);
		customer.getOrders().add(order2);
		
		// ִ save  Ȳ customerٲ order 
		// Ϊִinsertupdate
		// Ϊ 1 һ˺nһ˶άϵԻ update
		//  1 һ˵ set ڵָ inverse=true 1 һ˷ϵ
		// 趨 set  inverse=trueȲ 1 һٲ n һ
		// ôǲ update 
		session.save(customer);
		
//		session.save(order1);
//		session.save(order2);	

		// Ȳ Orderٲ Customer
		// Ϊִ insert update
//		session.save(order1);
//		session.save(order2);	
//		
//		session.save(customer);
		
	}
	
	@Test
	public void testManyToOneSave() {
		Customer customer = new Customer();
		customer.setCustomerName("AA");
		
		Order order1 = new Order();
		order1.setOrderName("ORDER-1");
		
		Order order2 = new Order();
		order2.setOrderName("ORDER-2");

		// 趨ϵ
		order1.setCustomer(customer);
		order2.setCustomer(customer);
		
		// ִ save  Ȳ customerٲ order Ϊִinsert
		// Ȳһһˣٲһˣֻ insert 
//		session.save(customer);
//		
//		session.save(order1);
//		session.save(order2);	
		
		// ִ save  Ȳ orderٲ  customer
		// Ϊִ insert update 
		// Ȳһˣٲһһˣ update 
		// Ϊڲһʱ޷ȷʵһһ˵ֵֻܵһһ˲룬ٶⷢ update 
		// ƼȲһһˣһ
		session.save(order1);
		session.save(order2);	
		
		session.save(customer);
		
	}

}
