package com.wt.hibernate.entity;

import static org.junit.Assert.*;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;

import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.jdbc.Work;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class HibernateText {

	private SessionFactory sessionFactory;
	private Session session;
	private Transaction transaction;

	@Before
	public void init() {
		// 
		// System.out.println("init");

		Configuration configuration = new Configuration().configure();
		ServiceRegistry serviceRegistry = new ServiceRegistryBuilder()
				.applySettings(configuration.getProperties())
				.buildServiceRegistry();

		sessionFactory = configuration.buildSessionFactory(serviceRegistry);

		session = sessionFactory.openSession();

		transaction = session.beginTransaction();
	}

	@After
	public void destroy() {
		// 
		// System.out.println("destroy");

		transaction.commit();
		session.close();
		sessionFactory.close();
	}
	
	@Test
	public void testComponent() {
		Worker worker = new Worker();
		Pay pay = new Pay();
		
		pay.setMonthlyPay(1000);
		pay.setYearPay(80000);
		pay.setVocationWithPay(5);
		
		worker.setName("ABCD");
		worker.setPay(pay);
		
		session.save(worker);
	}

	@Test
	public void testBlob() throws Exception {
//		News news = new News();
//		news.setAuthor("cc");
//		news.setContent("CONTENT");
//		news.setDate(new Date());
//		news.setDesc("DESC");
//		news.setTitle("CC");
//
//		InputStream stream = new FileInputStream("img.jpg");
//		Blob image = Hibernate.getLobCreator(session)
//							  .createBlob(stream, stream.available());
//		news.setImage(image);
//		
//		session.save(news);

		News news = (News) session.get(News.class, 1);
		Blob image = news.getImage();

		InputStream in = image.getBinaryStream();
		System.out.println(in.available());
	}

	@Test
	public void testPropertyUpdate() {
		News news = (News) session.get(News.class, 1);
		news.setTitle("aaaaaa");

		System.out.println(news.getDesc());
	}

	@Test
	public void testIdGenerator() throws InterruptedException {
		News news = new News("AA", "aa", new Date());

		session.save(news);

	}

	@Test
	public void testDynamicUpdate() {
		News news = (News) session.get(News.class, 3);
		news.setAuthor("hoho");

	}

	@Test
	public void testDoWork() {
		session.doWork(new Work() {

			@Override
			public void execute(Connection connection) throws SQLException {
				// TODO Auto-generated method stub
				System.out.println(connection);

				// ô洢̣
			}
		});

	}

	/**
	 * exict :  session аָĳ־ûƳ
	 * 
	 */
	@Test
	public void testEvict() {
		News news3 = (News) session.get(News.class, 3);
		News news4 = (News) session.get(News.class, 4);

		news3.setTitle("QQ");
		news4.setTitle("HH");

		session.evict(news3);
	}

	/**
	 * Delete: ִɾֻҪ OID ݱ׼еһ¼Ӧͻִ delete   OID
	 * ݱûӦĶ׳쳣
	 * 
	 * ͨ hibernate ļ hibernate.use_identifier_rollback Ϊtrue ʹɾ󣬰
	 * OID Ϊ null
	 */
	@Test
	public void testDelete() {
		// 
		// News news = new News();
		// news.setId(1);

		// ־û
		News news = (News) session.get(News.class, 2);

		session.delete(news);

		System.out.println(news);
	}

	/**
	 * ע⣺ 1.  OID Ϊnull ݱлûкӦļ¼׳һ쳣 2. ˽ OID ֵ unsave-value
	 * ֵĶҲΪһ
	 * 
	 */
	@Test
	public void testSaveOrUpdate() {
		News news = new News("FF", "ff", new Date());
		news.setId(1);
		session.saveOrUpdate(news);
	}

	/**
	 * update: 1. һ־û󣬲Ҫʾõ update  Ϊ ڵ Transaction commit()
	 * ʱִ session  flush  2. һҪʽĵ session  update 
	 * ԰һΪ־û
	 * 
	 * Ҫעģ 1. Ҫµݱļ¼Ƿ񣬶ᷢ update   update äĿķ update
	 * أ   .hbm.xml ļclass ڵе select-before-update="true"
	 * (ĬΪfalse), ͨҪøԡ
	 * 
	 * 2. ݱûжӦļ¼ update ׳쳣
	 * 
	 * 3.  update һʱ  session ĻѾͬ OID ĳ־ö󣬻׳쳣 Ϊ
	 * sessionв OID ͬĶ
	 */
	@Test
	public void testUpdate() {
		News news = (News) session.get(News.class, 1);

		transaction.commit();
		session.close();

		session = sessionFactory.openSession();
		transaction = session.beginTransaction();

		// news.setAuthor("dddddd");

		News news2 = (News) session.get(News.class, 1);

		session.update(news);
	}

	/**
	 * get & load : 1. ִ get ض ִ load ʹøö򲻻ִвѯһ
	 * 
	 * get load ӳټ
	 * 
	 * 2. load ܻ׳ LazyInitializationException 쳣 ҪʼʱѾر session
	 * 
	 * 3. ݿûӦļ¼ get  null load ׳쳣
	 * 
	 */
	@Test
	public void testLoad() {
		News news = (News) session.load(News.class, 1);
		System.out.println(news.getClass().getName());

		session.close();

		System.out.println(news);
	}

	@Test
	public void testGet() {
		News news = (News) session.get(News.class, 1);

		session.close();

		System.out.println(news);
	}

	/**
	 * persist Ҳִ insert 
	 * 
	 *  save : persist ֮ǰѾ id ˣ 򲻻ִ insert ׳쳣
	 */
	@Test
	public void testPersist() {
		News news = new News();
		news.setTitle("DD");
		news.setAuthor("dd");
		news.setDate(new Date());

		session.persist(news);
	}

	/**
	 * 1. save()  1.1> ʹһʱΪ־û 1.2> Ϊ ID 1.3> flush ʱᷢһ
	 * insert  1.4>  save() ֮ǰ ID Ч 1.5> ־û ID ǲܱ޸ĵģ
	 */
	@Test
	public void testSave() {
		News news = new News();
		news.setTitle("CC");
		news.setAuthor("cc");
		news.setDate(new Date());
		news.setId(666);

		System.out.println(news);

		session.save(news);

		System.out.println(news);
	}

	/**
	 * Clear(): 
	 */
	@Test
	public void testClear() {
		News news1 = (News) session.get(News.class, 1);

		session.clear();

		News news2 = (News) session.get(News.class, 1);
	}

	/**
	 * refresh(): ǿƷ select 䣬 ʹ Session ж״̬ݱжӦļ¼һ£
	 * 
	 */
	@Test
	public void testRefresh() {
		News news = (News) session.get(News.class, 1);
		System.out.println(news);

		session.refresh(news);
		System.out.println(news);

	}

	/**
	 * flush: ʹݱеļ¼ Session еĶ״̬һ£Ϊ˱һ£ ܻᷢͶӦ SQL , 1. 
	 * Transaction  commit() Уȵ session flushύ 2. flush ܻᷢ
	 * SQL 䣬ύ 3. ע: δύʽĵ session.flush() ֮ǰҲпܻ flush() 
	 * 3.1> ִ HQL  QBC ѯȽ flush()  Եõݱµļ¼ 3.2> ¼ ID
	 * ݿʹķʽɵģڵ save() 󣬾ͻ insert 䣬 Ϊ save 뱣֤ ID
	 * Ǵڵ
	 * 
	 */

	@Test
	public void testSessionFlush2() {
		News news = new News("HTML", "haha", new Date());
		session.save(news);
	}

	@Test
	public void testSessionFlush() {
		News news = (News) session.get(News.class, 1);
		news.setAuthor("hohott");

		// session.flush();
		// System.out.println("flush");

		News news2 = (News) session.createCriteria(News.class).uniqueResult();
		System.out.println(news2);

	}

	@Test
	public void test() {
		// 
		// System.out.println("test");

		News news = (News) session.get(News.class, 1);
		System.out.println(news);

		News news2 = (News) session.get(News.class, 1);
		System.out.println(news2);

	}

}
