package com.wt.dao;

import java.util.List;

import org.hibernate.Query;

import com.wt.entity.User;

public class UserDao extends BaseDao{

	// ѯеû
	public List<User> getAll(){
	
		String hql = "FROM User";
		
		return getSession().createQuery(hql).list();
		
	}
	
	// ûĵ¼֤
	public User userCheck(String username, String password) {
		
		User user = null;
		
		String hql = "FROM User u WHERE u.user_name = ? and u.user_password = ?";
		
		Query query = getSession().createQuery(hql);
		
		query.setString(0, username);
		query.setString(1, password);
		
		user = (User) query.uniqueResult();
		
		return user;
	}
	
	// ûעᣬݿв;
	// û޸Ϣͬķ
	public void saveOrUpdate(User user){
		
		getSession().saveOrUpdate(user);
		
	}
	
	// ֤
	public User emailCheck(String email){
		User user = null;
		
		String hql = "FROM User u WHERE u.user_email = ?";
		
		Query query = getSession().createQuery(hql);
		
		query.setString(0, email);
		
		user = (User) query.uniqueResult();
		
		return user;
	}
	
	// ûǷעļ
	public User usernameCheck(String username){
		User user = null;
		
		String hql = "FROM User u WHERE u.user_name = ?";
		
		Query query = getSession().createQuery(hql);
		
		query.setString(0, username);
		
		user = (User) query.uniqueResult();
		
		return user;
	}
	
	// ɾû
	public void delete(Integer id){
		
		String hql = "DELETE FROM User u WHERE u.id = ?";
		
		getSession().createQuery(hql).setInteger(0, id).executeUpdate();
		
	}
	
}
