/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardClassMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.util.MultiValueMap;

public class StandardAnnotationMetadata
extends StandardClassMetadata
implements AnnotationMetadata {
    private final boolean nestedAnnotationsAsMap;

    public StandardAnnotationMetadata(Class<?> introspectedClass) {
        this(introspectedClass, false);
    }

    public StandardAnnotationMetadata(Class<?> introspectedClass, boolean nestedAnnotationsAsMap) {
        super(introspectedClass);
        this.nestedAnnotationsAsMap = nestedAnnotationsAsMap;
    }

    @Override
    public Set<String> getAnnotationTypes() {
        Annotation[] anns;
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        for (Annotation ann : anns = this.getIntrospectedClass().getAnnotations()) {
            types.add(ann.annotationType().getName());
        }
        return types;
    }

    @Override
    public Set<String> getMetaAnnotationTypes(String annotationType) {
        return AnnotatedElementUtils.getMetaAnnotationTypes(this.getIntrospectedClass(), annotationType);
    }

    @Override
    public boolean hasAnnotation(String annotationType) {
        Annotation[] anns;
        for (Annotation ann : anns = this.getIntrospectedClass().getAnnotations()) {
            if (!ann.annotationType().getName().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMetaAnnotation(String annotationType) {
        return AnnotatedElementUtils.hasMetaAnnotationTypes(this.getIntrospectedClass(), annotationType);
    }

    @Override
    public boolean isAnnotated(String annotationType) {
        return AnnotatedElementUtils.isAnnotated(this.getIntrospectedClass(), annotationType);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        return this.getAnnotationAttributes(annotationType, false);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType, boolean classValuesAsString) {
        return AnnotatedElementUtils.getAnnotationAttributes(this.getIntrospectedClass(), annotationType, classValuesAsString, this.nestedAnnotationsAsMap);
    }

    @Override
    public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationType) {
        return this.getAllAnnotationAttributes(annotationType, false);
    }

    @Override
    public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationType, boolean classValuesAsString) {
        return AnnotatedElementUtils.getAllAnnotationAttributes(this.getIntrospectedClass(), annotationType, classValuesAsString, this.nestedAnnotationsAsMap);
    }

    @Override
    public boolean hasAnnotatedMethods(String annotationType) {
        Method[] methods;
        for (Method method : methods = this.getIntrospectedClass().getDeclaredMethods()) {
            if (!AnnotatedElementUtils.isAnnotated(method, annotationType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<MethodMetadata> getAnnotatedMethods(String annotationType) {
        Method[] methods = this.getIntrospectedClass().getDeclaredMethods();
        LinkedHashSet<MethodMetadata> annotatedMethods = new LinkedHashSet<MethodMetadata>();
        for (Method method : methods) {
            if (!AnnotatedElementUtils.isAnnotated(method, annotationType)) continue;
            annotatedMethods.add(new StandardMethodMetadata(method, this.nestedAnnotationsAsMap));
        }
        return annotatedMethods;
    }
}

