/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;

public abstract class JAXBContext {
    private static final Class[] CONTEXT_CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = JAXBContext.class$("java.lang.String")) : class$java$lang$String, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = JAXBContext.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
    public static final String JAXB_CONTEXT_FACTORY = "javax.xml.bind.context.factory";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$javax$xml$bind$JAXBContext;

    public static JAXBContext newInstance(String pPath) throws JAXBException {
        return JAXBContext.newInstance(pPath, Thread.currentThread().getContextClassLoader());
    }

    public static JAXBContext newInstance(String pPath, ClassLoader pClassLoader) throws JAXBException {
        if (pPath == null) {
            throw new JAXBException("The context path must not be null.");
        }
        if (pClassLoader == null) {
            throw new JAXBException("The classloader must not be null.");
        }
        StringTokenizer st = new StringTokenizer(pPath, ":");
        while (st.hasMoreTokens()) {
            Object o;
            Method m;
            Class<?> c;
            String packageName = st.nextToken();
            String resourceName = packageName.replace('.', '/') + "/jaxb.properties";
            URL resource = pClassLoader.getResource(resourceName);
            if (resource == null) continue;
            Properties props = new Properties();
            try {
                props.load(resource.openStream());
            }
            catch (IOException e) {
                throw new JAXBException("Failed to load property file " + resource, e);
            }
            String className = props.getProperty(JAXB_CONTEXT_FACTORY);
            if (className == null) {
                throw new JAXBException("The property javax.xml.bind.context.factory is not set in " + resource);
            }
            try {
                c = pClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new JAXBException("The class " + className + ", referenced by property " + JAXB_CONTEXT_FACTORY + " in " + resource + ", could not be loaded.");
            }
            try {
                m = c.getMethod("createContext", CONTEXT_CLASSES);
            }
            catch (NoSuchMethodException e) {
                throw new JAXBException("The class " + c + " does not have a method 'public static createContext(String, ClassLoader) throws JAXBException'");
            }
            int modifiers = m.getModifiers();
            if (m == null || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
                throw new JAXBException("The class " + c + " does not have a method 'public static createContext(String, ClassLoader) throws JAXBException'");
            }
            try {
                o = m.invoke(null, pPath, pClassLoader);
            }
            catch (IllegalAccessException e) {
                throw new JAXBException("Illegal access to method " + c.getName() + ".createContext(String,ClassLoader).", e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                throw new JAXBException(t.getClass().getName() + " in method " + c.getName() + ".createContext(String,ClassLoader): " + t.getMessage(), t);
            }
            if (o == null) {
                throw new JAXBException("The method " + c.getName() + ".createContext(String,ClassLoader) returned null.");
            }
            try {
                return (JAXBContext)o;
            }
            catch (ClassCastException e) {
                throw new JAXBException("The object created by " + c.getName() + ".createContext(String,ClassLoader) cannot be casted to " + (class$javax$xml$bind$JAXBContext == null ? (class$javax$xml$bind$JAXBContext = JAXBContext.class$("javax.xml.bind.JAXBContext")) : class$javax$xml$bind$JAXBContext).getName() + ".", e);
            }
        }
        throw new JAXBException("Failed to resolve resource jaxb.properties via path " + pPath + " and ClassLoader " + pClassLoader);
    }

    public abstract Marshaller createMarshaller() throws JAXBException;

    public abstract Unmarshaller createUnmarshaller() throws JAXBException;

    public abstract Validator createValidator() throws JAXBException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

