# Contribute to nextjs-mongodb-app

:+1::tada: Thank you for being here. It is people like you that make `nextjs-mongodb-app` great and help shape a better open-source community.

Following this guideline improves communication and organization, which helps save your and other developers' times and effort in future development.

## What `nextjs-mongodb-app` is looking for

I welcome all contributions from the community. There are many ways to contribute:

- :art: Submit PR to fix bugs, enhance/add existed/new features.
- :children_crossing: Submit bug reports and feature requests.
- :pencil: Improve documentation and writing examples.

However, please avoid using the issue tracker for support questions. You can receive help on my [Spectrum community](https://spectrum.chat/luvbitstudio).

## How to contribute

### Bug reports

If you are submitting a :bug: bug report, please:
- Use a clear and descriptive title. Describe the behavior you observed and the expected behavior.
- Describe the exact steps which reproduce the problem. A minimal reproduction repo is greatly appreciated.
- Include Node version, OS, or other information that may be helpful in the troubleshooting.

### Process on submitting a PR

*Generally, all pull requests should have references to an issue.*

If you are :sparkles: **adding a new feature** or :zap: **improving an algorithm**, please first [create an issue](../../issues/new) for discussion.

The steps to submit a PR are:

1. [Fork](https://help.github.com/articles/fork-a-repo/) this repository to your own GitHub account and then [clone](https://help.github.com/articles/cloning-a-repository/) it to your local device.

2. Install all dependencies and dev dependencies by `npm install`.

3. Make changes and commit (following [commit message styleguides](#commit-message)).

4. Make sure your code is linted by running `npm run lint`.

5. [Create a pull request](https://help.github.com/en/articles/creating-a-pull-request-from-a-fork)

## Styleguides

### Javascript style

`nextjs-mongodb-app` follows [Airbnb JavaScript Style Guide](https://github.com/airbnb/javascript). Please run `npm run lint` and fix any linting warnings.

### Commit message

- Use the present tense and imperative mood ("Add feature" instead of "Adds feature" or "Added feature")
- Consider starting the commit message with an applicable emoji (ex. [gitmoji](https://gitmoji.carloscuesta.me)) for a more beautiful world :rainbow:.

:heart: Thank you,
Hoang Vo
