---
layout: default
---

# What's this?

Speechy provides an easy interface for **paid** Text-to-Speech (TTS) APIs. Simply select text and click Speechy from the context menu—that's it. Your browser will read the text aloud using a high-quality voice, which is superior to your OS's default TTS engine or free online APIs.

We currently support the following APIs:
- Google Cloud Text-to-Speech API
- OpenAI Text-to-Speech API

# Features

Available:

- Read selected text aloud from context menu
- Support Google Cloud Text-to-Speech API
- Support OpenAI Text-to-Speech API

| Feature | Google API | OpenAI API |
| --- | --- | --- |
| Streaming | Impossible | OK |
| English Proficiency | Good | Excellent |
| Other Languages | Language selection required, but good | Language selection not needed, but not native |
| Speed Control | Available | Not available |

- Google has de, fr, ja, ko, nl, pt, sv, tr language options.
- Choose OpenAI if you need faster response or for English.
- Choose Google for non-English texts.

![Screenshot_2](/images/screenshot_2.png)

# Why Paid APIs?

There are many other Chrome extensions that use free TTS APIs or your OS's default TTS engine. The voices generated by these engines are often low quality and uncomfortable to listen to. In contrast, paid APIs provide much better quality. Specifically, Google's Cloud Text-to-Speech API and OpenAI Speech API generate high-quality voices using deep learning technology.

The author wanted an easy way to use these high-quality APIs within Chrome, so this extension was developed. If you prefer not to pay for a TTS engine, this extension may not be the best fit for you. However, these APIs are reasonably priced. For example, Google’s Cloud Text-to-Speech API costs $16.00 USD per 1 million characters after a free tier of 1 million characters. The author would be delighted if you gave it a try!

# Help and Setup
For setup instructions, see this [page](https://hmirin.github.io/speechy/installed).

# Disclaimer

This software is provided “as is” without any expressed or implied warranties, including but not limited to implied warranties of merchantability and fitness for a particular purpose. 

Please ensure you protect your API key for security reasons!
