# Speechy

This repository is the source code of [Speechy](https://chrome.google.com/webstore/detail/speechy/flpjdaabfegkkifhogoilelmjcipihnp), a Chrome Extension for high quality Text-to-Speech (TTS) APIs.

Speechy provides an easy interface for **paid** Text-to-Speech (TTS) APIs. Simply select text and click Speechy from the context menu—that's it. Your browser will read the text aloud using a high-quality voice, which is superior to your OS's default TTS engine or free online APIs.

See [project page](https://hmirin.github.io/speechy/).

## Features

Available:

- Read selected text aloud from context menu
- Support Google Cloud Text-to-Speech API
- Support OpenAI Text-to-Speech API

| Feature | Google API | OpenAI API |
| --- | --- | --- |
| Streaming | Impossible | OK |
| English Proficiency | Good | Excellent |
| Other Languages | Language selection required, but good | Language selection not needed, but not native |
| Speed Control | Available | Not available |

- Google has de, fr, ja, ko, nl, pt, sv, tr language options.
- Choose OpenAI if you need faster response or for English.
- Choose Google for non-English texts.

Planned:

- Stop voice from extension menu.
- Add Speed Control for OpenAI in client side.

