# Contributing to FreeAPI

Thank you for your interest in contributing to FreeAPI! We welcome contributions from the software community to help improve and enhance this project.

By contributing, you can help make FreeAPI a more valuable resource for developers and contribute to the growth of the open-source community.

## Table of Contents

1. [📙 How to Contribute](#how-to-contribute)
2. [䷫ Commit Message Format](#commit-message-format)
3. [👨🏻‍⚖️ Guidelines for Contribution](#contribution-guidelines)
4. [🚀 Contribute as a frontend developer](#frontend-contributor)

## How to Contribute <a name="how-to-contribute"></a>

To contribute to FreeAPI, please follow these guidelines:

1. Fork the repository on GitHub.
2. Clone your forked repository to your local machine.
3. Create a new branch for your feature or bug fix: `git checkout -b feat/your-feature-name` or `git checkout -b fix/your-bug-fix-name` and make your changes.
4. Run all the tests 🧪 before committing the changes and make sure all tests are passed.
5. After all tests are passed, commit your changes with a descriptive messages: `git commit -am 'add your commit message'`.
6. Push your changes to your forked repository: `git push origin feat/your-feature-name`.
7. Submit a pull request to the main repository.

## Commit Message Format <a name="commit-message-format"></a>

We follow the conventional commit message format to provide a clear and standardized history of our project's changes. Each commit message should consist of a type and a descriptive message.

| Type     | Heading  | Rule                                       | Description                                                                       |
| -------- | -------- | ------------------------------------------ | --------------------------------------------------------------------------------- |
| ci       | CI       | Continuous Integration                     | Changes related to continuous integration.                                        |
| chore    | Chore    | Maintenance tasks                          | Other changes that don't affect production.                                       |
| docs     | Docs     | Documentation                              | Changes related to documentation.                                                 |
| feat     | Feature  | New Feature                                | New feature implementations or additions.                                         |
| fix      | Fix      | Bug Fixes                                  | Bug fixes or corrections.                                                         |
| perf     | Perf     | Performance Improvements                   | Performance-related improvements.                                                 |
| refactor | Refactor | Code Refactoring                           | Code changes that don't fix bugs or add features, but improve the code structure. |
| revert   | Revert   | Revert Previous Commits                    | Reverting previous commits.                                                       |
| style    | Style    | Code Formatting or Style                   | Changes related to code formatting or style.                                      |
| assets   | Assets   | Add or Update Assets (e.g., images, files) | Changes related to adding or updating assets, such as images or other files.      |

### Format

The commit message should start with the type, followed by a colon and a space, and then the descriptive message in present tense.

Example:

- feat: add user authentication feature
- fix: correct typo in README

Please adhere to this format when making commits. This will help us maintain a clean and organized commit history.

## Guidelines for Contribution <a name="contribution-guidelines"></a>

Here's a guide on how you can effectively contribute to our API hub:

1. Pull Requests for Readme Updates: Please refrain from sending pull requests solely for updating the project's readme file. While we appreciate the importance of clear and concise documentation, we prefer to focus on substantial code contributions and feature enhancements.

2. Grammar Updates: Our team values effective communication, but we're not grammar sticklers. You don't need to send pull requests solely for grammar fixes or minor language improvements. Instead, concentrate on the core functionalities and features of the project.

3. Avoid Updating Existing Public APIs: To maintain stability and consistency, we discourage direct updates to existing public APIs within the API hub. These APIs have been thoroughly tested and approved. However, if you encounter any bugs or issues, we encourage you to open an issue on our project's issue tracker to notify us.

4. Build New Project APIs: We encourage you to explore your creativity and contribute by building complete project APIs. These APIs should provide comprehensive solutions that can assist developers in constructing complex projects to showcase their skills and abilities. Your contributions in this area will greatly benefit the community.

5. Draft a Proposal and Discuss on Discord: Before diving into your project, we recommend drafting a proposal. This can include a mind map or outline of the API you intend to build and its potential benefits. Join our Discord community, where you can share your proposal, discuss ideas, and gather feedback from fellow contributors. Engaging in these discussions will enhance your backend portfolio and help shape the future direction of the project.

We appreciate your enthusiasm and look forward to your valuable contributions to our open source API hub project.

Together, we can foster a collaborative environment and make a significant impact in the API integration landscape.

## Contribute as a frontend developer <a name="frontend-contributor"></a>

Are you a Frontend developer looking to create elegant mobile/web apps which consumes FreeAPIs? Then follow this [Frontend Contribution guide](https://github.com/hiteshchoudhary/apihub/blob/main/CONTRIBUTING_FRONTEND.md) and contribute as a frontend developer
