<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Statement Report</title>

    <style>
        body {
            background: #fff none;
            font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 12px;
        }

        h2 {
            font-size: 28px;
            color: #ccc;
        }

        .container {
            padding-top: 30px;
        }

        .invoice-head td {
            padding: 0 8px;
        }

        .table th {
            vertical-align: bottom;
            font-weight: bold;
            padding: 8px;
            line-height: 14px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }

        .table tr.row td {
            border-bottom: 1px solid #ddd;
        }

        .table td {
            padding: 8px;
            line-height: 14px;
            text-align: left;
            vertical-align: top;
        }
    </style>
</head>
<body>
    <div class="container">
        <table style="margin-left: auto; margin-right: auto;" width="550">
            <tr>
                <td width="160">
                    <span style="font-size: 28px;">
                        <svg height="20px" viewBox="0 0 1454 305" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g id="t-copy-2" transform="translate(-34.000000, -117.000000)" fill-rule="nonzero">
                                    <g id="hisabi" transform="translate(34.000000, 117.000000)">
                                        <path d="M460,300 L460,193.6 C460,188 459.666667,183.066667 459,178.8 C458.333333,174.533333 456.866667,171 454.6,168.2 C452.333333,165.4 448.933333,163.266667 444.4,161.8 C439.866667,160.333333 433.733333,159.6 426,159.6 L417.6,159.6 C413.066667,159.6 409.533333,160.6 407,162.6 C404.466667,164.6 402.666667,167.2 401.6,170.4 C400.533333,173.6 399.933333,177.333333 399.8,181.6 C399.666667,185.866667 399.6,190.266667 399.6,194.8 L399.6,300 L324,300 L324,16 L332.4,12.4 C342.8,7.86666667 352.866667,4.66666667 362.6,2.8 C372.333333,0.933333333 382.8,0 394,0 L400,0 L400,92.4 C407.466667,89.2 413.466667,87.0666667 418,86 C422.533333,84.9333333 427.066667,84.4 431.6,84.4 C450,84.4 465.733333,86.3333333 478.8,90.2 C491.866667,94.0666667 502.666667,100.333333 511.2,109 C519.733333,117.666667 526,128.8 530,142.4 C534,156 536,172.533333 536,192 L536,300 L460,300 Z" id="Path" fill="#1F1F1F"></path>
                                        <path d="M292,57 L291.999526,201.480327 C291.90128,202.322838 291.834771,203.194729 291.8,204.096 C291.666667,207.552 291.6,211.116 291.6,214.788 L291.6,300 L216,300 L216,69.96 L224.4,67.044 C234.8,63.372 244.866667,60.78 254.6,59.268 C264.333333,57.756 274.8,57 286,57 L292,57 Z" id="Combined-Shape" fill="#42EF44"></path>
                                        <path d="M184,115 L183.999676,224.994332 C183.901347,225.636053 183.834789,226.300165 183.8,226.986667 C183.666667,229.617778 183.6,232.331111 183.6,235.126667 L183.6,300 L108,300 L108,124.866667 L116.4,122.646667 C126.8,119.851111 136.866667,117.877778 146.6,116.726667 C156.333333,115.575556 166.8,115 178,115 L184,115 Z" id="Combined-Shape-Copy" fill="#42EF44"></path>
                                        <path d="M76,178 L75.9997221,250.536602 C75.9013685,250.959854 75.8347944,251.397875 75.8,251.850667 C75.6666667,253.585778 75.6,255.375111 75.6,257.218667 L75.6,300 L0,300 L0,184.506667 L8.4,183.042667 C18.8,181.199111 28.8666667,179.897778 38.6,179.138667 C48.3333333,178.379556 58.8,178 70,178 L76,178 Z" id="Combined-Shape-Copy-2" fill="#42EF44"></path>
                                        <path d="M572,300 L572,104 L580.4,100.4 C590.8,95.8666667 600.866667,92.6666667 610.6,90.8 C620.333333,88.9333333 630.8,88 642,88 L648,88 L648,300 L572,300 Z M610,80 C604.666667,80 599.733333,79.5333333 595.2,78.6 C590.666667,77.6666667 586.666667,75.8666667 583.2,73.2 C579.733333,70.5333333 577,66.7333333 575,61.8 C573,56.8666667 572,50.2666667 572,42 C572,33.7333333 573,27.1333333 575,22.2 C577,17.2666667 579.733333,13.4666667 583.2,10.8 C586.666667,8.13333333 590.666667,6.33333333 595.2,5.4 C599.733333,4.46666667 604.666667,4 610,4 C615.066667,4 619.933333,4.46666667 624.6,5.4 C629.266667,6.33333333 633.333333,8.13333333 636.8,10.8 C640.266667,13.4666667 643,17.2666667 645,22.2 C647,27.1333333 648,33.7333333 648,42 C648,50.2666667 647,56.8666667 645,61.8 C643,66.7333333 640.266667,70.5333333 636.8,73.2 C633.333333,75.8666667 629.266667,77.6666667 624.6,78.6 C619.933333,79.5333333 615.066667,80 610,80 Z" id="Shape" fill="#1F1F1F"></path>
                                        <path d="M705.2,225.6 C708.133333,226.133333 711.933333,227.066667 716.6,228.4 C721.266667,229.733333 726.6,231 732.6,232.2 C738.6,233.4 744.933333,234.466667 751.6,235.4 C758.266667,236.333333 765.066667,236.8 772,236.8 C777.066667,236.8 780.466667,236.466667 782.2,235.8 C783.933333,235.133333 784.8,234.133333 784.8,232.8 C784.8,231.466667 784.333333,230.133333 783.4,228.8 C782.466667,227.466667 781.6,226.666667 780.8,226.4 C766.4,222.933333 753.4,220 741.8,217.6 C730.2,215.2 720.4,211.8 712.4,207.4 C704.4,203 698.266667,196.866667 694,189 C689.733333,181.133333 687.6,169.866667 687.6,155.2 C687.6,141.6 689.466667,130.2 693.2,121 C696.933333,111.8 702.4,104.466667 709.6,99 C716.8,93.5333333 725.666667,89.6666667 736.2,87.4 C746.733333,85.1333333 758.666667,84 772,84 C781.6,84 791.066667,84.4666667 800.4,85.4 C809.733333,86.3333333 818.4,87.5333333 826.4,89 C834.4,90.4666667 841.466667,92.1333333 847.6,94 C853.733333,95.8666667 858.4,97.7333333 861.6,99.6 L840.4,160.8 C836.133333,158.933333 830.466667,157.266667 823.4,155.8 C816.333333,154.333333 809.2,153.133333 802,152.2 C794.8,151.266667 788.066667,150.733333 781.8,150.6 C775.533333,150.466667 771.066667,150.666667 768.4,151.2 C766.266667,151.733333 764.866667,152.466667 764.2,153.4 C763.533333,154.333333 763.2,155.066667 763.2,155.6 C763.2,156.666667 763.733333,157.666667 764.8,158.6 C765.866667,159.533333 766.8,160.133333 767.6,160.4 C782,163.6 795.066667,166.533333 806.8,169.2 C818.533333,171.866667 828.666667,175.533333 837.2,180.2 C845.733333,184.866667 852.333333,191.266667 857,199.4 C861.666667,207.533333 864,218.933333 864,233.6 C864,247.2 862,258.466667 858,267.4 C854,276.333333 848.266667,283.533333 840.8,289 C833.333333,294.466667 824.333333,298.333333 813.8,300.6 C803.266667,302.866667 791.466667,304 778.4,304 C767.733333,304 757.2,303.4 746.8,302.2 C736.4,301 726.733333,299.533333 717.8,297.8 C708.866667,296.066667 701.066667,294.2 694.4,292.2 C687.733333,290.2 682.933333,288.4 680,286.8 L705.2,225.6 Z" id="Path" fill="#1F1F1F"></path>
                                        <path d="M1047.2,300 L1019.6,282 C1016.4,286.533333 1012.93333,290.2 1009.2,293 C1005.46667,295.8 1001.8,298.066667 998.2,299.8 C994.6,301.533333 991.133333,302.733333 987.8,303.4 C984.466667,304.066667 981.733333,304.4 979.6,304.4 C962,304.4 947.333333,303.466667 935.6,301.6 C923.866667,299.733333 914.266667,296.533333 906.8,292 C899.333333,287.466667 893.933333,281.266667 890.6,273.4 C887.266667,265.533333 885.2,255.6 884.4,243.6 C883.6,231.333333 884.4,221.066667 886.8,212.8 C889.2,204.533333 893.266667,197.866667 899,192.8 C904.733333,187.733333 912.4,184.133333 922,182 C931.6,179.866667 943.333333,178.8 957.2,178.8 L1006,178.8 C1005.73333,174.266667 1004.73333,170.733333 1003,168.2 C1001.26667,165.666667 999,163.8 996.2,162.6 C993.4,161.4 990.2,160.733333 986.6,160.6 C983,160.466667 979.2,160.4 975.2,160.4 C968.8,160.4 963.333333,160.533333 958.8,160.8 C954.266667,161.066667 949.933333,161.466667 945.8,162 C941.666667,162.533333 937.266667,163.333333 932.6,164.4 C927.933333,165.466667 922.4,166.933333 916,168.8 L893.6,100 C901.6,97.0666667 912.266667,93.7333333 925.6,90 C938.933333,86.2666667 955.866667,84.4 976.4,84.4 C1012.4,84.4 1039.53333,93 1057.8,110.2 C1076.06667,127.4 1085.2,155.466667 1085.2,194.4 L1085.2,300 L1047.2,300 Z M972.8,226.8 C967.733333,226.8 964.666667,227.866667 963.6,230 C962.533333,232.133333 962,234.666667 962,237.6 C962,240.533333 962.533333,243.066667 963.6,245.2 C964.666667,247.333333 967.733333,248.4 972.8,248.4 L981.6,248.4 C984.8,248.4 988,248.2 991.2,247.8 C994.4,247.4 997.133333,246.533333 999.4,245.2 C1001.66667,243.866667 1003.4,241.733333 1004.6,238.8 C1005.8,235.866667 1006.13333,231.866667 1005.6,226.8 L972.8,226.8 Z" id="Shape" fill="#1F1F1F"></path>
                                        <path d="M1159.2,300 L1121.2,300 L1121.2,16 L1129.6,12.4 C1140,7.86666667 1150.06667,4.66666667 1159.8,2.8 C1169.53333,0.933333333 1180,0 1191.2,0 L1197.2,0 L1197.2,92.4 C1200.93333,90.8 1204.26667,89.4666667 1207.2,88.4 C1210.13333,87.3333333 1213.13333,86.5333333 1216.2,86 C1219.26667,85.4666667 1222.4,85.0666667 1225.6,84.8 C1228.8,84.5333333 1232.53333,84.4 1236.8,84.4 C1255.2,84.4 1270.93333,86.3333333 1284,90.2 C1297.06667,94.0666667 1307.86667,100.333333 1316.4,109 C1324.93333,117.666667 1331.2,128.8 1335.2,142.4 C1339.2,156 1341.2,172.533333 1341.2,192 C1341.2,232 1332.86667,260.6 1316.2,277.8 C1299.53333,295 1274.26667,303.6 1240.4,303.6 C1234.26667,303.6 1228.86667,303.333333 1224.2,302.8 C1219.53333,302.266667 1215.13333,301.2 1211,299.6 C1206.86667,298 1202.86667,295.8 1199,293 C1195.13333,290.2 1191.06667,286.533333 1186.8,282 L1159.2,300 Z M1231.2,227.6 C1238.93333,227.6 1245.06667,227.266667 1249.6,226.6 C1254.13333,225.933333 1257.53333,224.466667 1259.8,222.2 C1262.06667,219.933333 1263.53333,216.533333 1264.2,212 C1264.86667,207.466667 1265.2,201.333333 1265.2,193.6 C1265.2,185.866667 1264.86667,179.733333 1264.2,175.2 C1263.53333,170.666667 1262.06667,167.266667 1259.8,165 C1257.53333,162.733333 1254.13333,161.266667 1249.6,160.6 C1245.06667,159.933333 1238.93333,159.6 1231.2,159.6 L1214.8,159.6 C1210.26667,159.6 1206.73333,160.6 1204.2,162.6 C1201.66667,164.6 1199.86667,167.2 1198.8,170.4 C1197.73333,173.6 1197.13333,177.333333 1197,181.6 C1196.86667,185.866667 1196.8,190.266667 1196.8,194.8 C1196.8,199.333333 1196.86667,203.6 1197,207.6 C1197.13333,211.6 1197.73333,215.066667 1198.8,218 C1199.86667,220.933333 1201.66667,223.266667 1204.2,225 C1206.73333,226.733333 1210.26667,227.6 1214.8,227.6 L1231.2,227.6 Z" id="Shape" fill="#1F1F1F"></path>
                                        <path d="M1377.2,300 L1377.2,104 L1385.6,100.4 C1396,95.8666667 1406.06667,92.6666667 1415.8,90.8 C1425.53333,88.9333333 1436,88 1447.2,88 L1453.2,88 L1453.2,300 L1377.2,300 Z M1415.2,80 C1409.86667,80 1404.93333,79.5333333 1400.4,78.6 C1395.86667,77.6666667 1391.86667,75.8666667 1388.4,73.2 C1384.93333,70.5333333 1382.2,66.7333333 1380.2,61.8 C1378.2,56.8666667 1377.2,50.2666667 1377.2,42 C1377.2,33.7333333 1378.2,27.1333333 1380.2,22.2 C1382.2,17.2666667 1384.93333,13.4666667 1388.4,10.8 C1391.86667,8.13333333 1395.86667,6.33333333 1400.4,5.4 C1404.93333,4.46666667 1409.86667,4 1415.2,4 C1420.26667,4 1425.13333,4.46666667 1429.8,5.4 C1434.46667,6.33333333 1438.53333,8.13333333 1442,10.8 C1445.46667,13.4666667 1448.2,17.2666667 1450.2,22.2 C1452.2,27.1333333 1453.2,33.7333333 1453.2,42 C1453.2,50.2666667 1452.2,56.8666667 1450.2,61.8 C1448.2,66.7333333 1445.46667,70.5333333 1442,73.2 C1438.53333,75.8666667 1434.46667,77.6666667 1429.8,78.6 C1425.13333,79.5333333 1420.26667,80 1415.2,80 Z" id="Shape" fill="#1F1F1F"></path>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </span>
                </td>

                <td align="right">
                    Statement Report <br>
                    <strong>{{ $range }}</strong>
                </td>
            </tr>
            <tr style="height: 3px; background: lightgray; width: 100%;">
                <td colspan="2"></td>
            </tr>
            <tr style="height: 10px; width: 100%;">
                <td colspan="2"></td>
            </tr>
            @foreach ($sections as $sectionName => $sectionRows)
                <tr valign="top">
                    <td>
                        <span style="font-size: 18px;">
                            {{ $sectionName }}
                        </span>
                    </td>
                    <td>
                        <table width="100%" class="table" border="0">
                            <tr>
                                <th align="left">Name</th>
                                <th align="right">Total ({{ $currency }})</th>
                                <th align="right">Prev. Month ({{ $currency }})</th>
                                <th align="right">Change</th>
                            </tr>

                            @foreach ($sectionRows as $sectionRow)
                                <tr @if($sectionRow['name'] == 'All')style="background-color: #eaeaea;"@endif class="row">
                                    <td>{{ $sectionRow['name'] }} @if(isset($sectionRow['is_new']) && $sectionRow['is_new'])<span style="color: red;">(new)</span>@endif</td>
                                    <td>{{ number_format((float) $sectionRow['total_current_month']) }}</td>
                                    <td>{{ number_format((float) $sectionRow['total_previous_month']) }}</td>
                                    <td style="color: {{ $sectionRow['change_color'] }};">{{ $sectionRow['change'] }}{{$sectionRow['change'] == '-' ? '' : '%'}}</td>
                                </tr>
                            @endforeach
                        </table>
                    </td>
                </tr>
                <tr style="height: 10px; width: 100%;">
                    <td colspan="2"></td>
                </tr>
            @endforeach
        </table>
    </div>
</body>
</html>
