# FPNN 协议说明

**一、概述**

  在不同的语境下，协议有不同的含义。  
  FPNN 是基于 TCP 与 UDP 之上的二进制私有协议。

  根据场景的不同，FPNN 协议分为以下3个层次：  
  封包协议、编码协议、接口协议。

**二、FPNN 封包协议**

  FPNN 封包协议，即一般泛指的 FPNN 协议。是对经过编码协议编码后的数据，组装成可在 TCP 协议之上传输的数据包的约定。

  FPNN 封包协议细节，可参见 [FPNN Protocol Spec](../common/fpnn-protocol-spec.txt)

**三、FPNN 编码协议**

  FPNN 仅支持两种编码协议：

  + [Json (UTF-8 only)](http://json.org)
  + [msgpack](https://msgpack.org)

**四、FPNN 接口协议**

  接口协议，即对各个服务接口调用的参数与方式的约定。

  FPNN 支持可选参数，且对参数顺序，没有要求。

  因 FPNN 协议可与 JSON 等价互转，因此可以使用类似于 JSON 的格式进行描述。

  接口描述格式说明：

  | 标识 | 说明 |
  |-----|------|
  | => | 请求 |
  | <= | 回复 |
  | ~ | oneway 请求(无回复) |
  | ? | 可选参数 |
  | [] | 列表 |
  | {} | 字典 |
  | % | 格式标识 |

  参数格式说明：

  | 标识 | 说明 |
  |-----|------|
  | b | 布尔型 |
  | B | Blob 类型 |
  | d, i | 整形 |
  | f | 浮点型 |
  | s | 字符串 |
  | x | b, B, d, i, f, s 某种类型 |
  | X | b, B, d, i, f, s, 列表, 字典 某种类型 |

