# FPNN 术语表

| 术语 | 含义 |
|-----|------|
| cluster | 集群。但 cluster 在 FPNN 技术生态内，随上下文语境，含义可能不同。在 FPZK 系统和 [FPZKClient](APIs/extends/FPZKClient.md) 中，因历史原因，特指“分组”，即普遍含义上的集群的下一级分组，也称为子集群。在 [DBProxyCluster](https://github.com/highras/dbproxy) 中，特指数据分组。 |
| duplex | 双工。指支持 server push。即：允许服务器向客户端发送请求，客户端对服务端的请求做出应答。 |
| FPZK | FPNN 技术生态的服务发现和集群管理服务，暂未开源。 |
| oneway | 同“单向消息”。指只有请求，不用回应的消息。 |
| push | 一般特指移动端的推送信息。比如苹果的推送，Android 的消息推送。 |
| server push | 指服务端向客户端发送请求。发送的请求可能是单向消息或双向消息。如果是双向消息，客户端必须做出应答。 |
| twoway | 同“双向消息”。指必须有回应的请求，和其对应的回应。 |
|---|---|
| 单向消息 | 同“oneway”。指只有请求，不用回应的消息。 |
| 二级分组 | 即集群的下一级分类，简称“分组”。例：所有的 [DBProxy](https://github.com/highras/dbproxy)，视为一个集群。其中分为三个分组：北美分组，欧洲分组，和亚洲分组。以上三个分组各自构成一个子集群，但共同构成了 [DBProxy](https://github.com/highras/dbproxy) 整个集群。 |
| 二级集群 | 即：二级分组 |
| 分组 | 即“二级分组”的简称。 |
| 集群全名 | 对于一级集群，即服务名称，对于二级集群，即“服务名@分组名”。 |
| 集群名称 | 根据上下文，可能指仅含服务名的“一级集群”，也可能指“服务名@分组名”的“二级集群”。 |
| 双向消息 | 同“twoway”。指必须有回应的请求，和其对应的回应。 |
| 一级集群 | 即忽略二级分组的同类服务构成的集群。 |