## sha1

### 介绍

SHA-2 摘要算法。

### 命名空间

无命名空间约束。

### 全局函数

#### sha256_context

	typedef struct {
			uint32_t total[2];
			uint32_t state[8];
			unsigned char buffer[64];
		} sha256_context;

sha-2 上下文结构。

#### sha256_start

	void sha256_start(sha256_context *ctx);

初始化 sha-2 上下文结构。

#### sha256_update

	void sha256_update(sha256_context *ctx, const void *input, size_t length);

使用 `sha256_context *ctx` 指定的上下文，继续计算 `const void *input` 指向的 `size_t length` 字节长的数据的 sha-2 值。

#### sha256_finish

	void sha256_finish(sha256_context *ctx, unsigned char digest[32]);

sha-2 计算完成，获取 sha-2 数值。

#### sha256_checksum

	void sha256_checksum(unsigned char digest[32], const void *input, size_t length);

计算 `const void *input` 所指向 `size_t length` 字节长的数据的 sha-2 值，并在 `unsigned char digest[32]` 中返回。