#ifndef FPNN_UDP_Assembler_v2_h
#define FPNN_UDP_Assembler_v2_h

#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <string>
#include <list>
#include <map>
#include "UDPCommon.v2.h"

namespace fpnn
{
	//-- Original data generated by FPQuest::raw() or FPAnswer::raw().
	struct UDPDataUnit
	{
		bool discardable;
		std::string* data;
		int64_t expiredMS;

		UDPDataUnit(std::string* data_, bool discardable_, int64_t expiredMS_):
			discardable(discardable_), data(data_), expiredMS(expiredMS_) {}

		~UDPDataUnit()
		{
			delete data;
		}
	};

	struct SegmentInfo
	{
		UDPDataUnit* data;
		uint32_t nextIndex;
		size_t offset;

		SegmentInfo(): data(NULL), nextIndex(1), offset(0) {}
		~SegmentInfo()
		{
			if (data)
				delete data;
		}

		void reset()
		{
			if (data)
			{
				delete data;
				data = NULL;
			}
			nextIndex = 1;
			offset = 0;
		}
	};

	struct UDPPackage
	{
		//-- Basic Part
		void* buffer;
		size_t len;
		int sentCount;
		int64_t expiredMsec;
		int64_t firstSentMsec;
		int64_t lastSentMsec;
		bool resending;
		bool cancelled;
		bool requireDeleted;

		//-- Enhancement Part
		void* encryptedBuffer;
		

		UDPPackage(): buffer(NULL), len(0), sentCount(0),
			expiredMsec(0x7FFFFFFFFFFFFFFF), firstSentMsec(0),
			resending(false), cancelled(false), requireDeleted(false),
			encryptedBuffer(NULL)
		{}
		~UDPPackage()
		{
			free(buffer);

			if (encryptedBuffer)
				free(encryptedBuffer);
		}
		void updateSendingInfo()
		{
			sentCount += 1;
			lastSentMsec = slack_real_msec();

			if (!firstSentMsec)
				firstSentMsec = lastSentMsec;
		}
		void expireCheck(int64_t now);
		void expireCombinedPackage();
	};

	struct CurrentSendingBuffer
	{
		uint8_t* rawBuffer;
		size_t bufferLength;

		uint8_t* dataBuffer;
		size_t dataLength;

		uint8_t protocolVersion;
		bool discardable;
		uint32_t packageSeq;

		bool newPackage;
		bool sendDone;
		//bool requireUpdateSeq;

		int sentCount;
		int64_t lastSentMsec;
		int64_t dataExpiredMsec;

		UDPEncryptor* encryptor;
		UDPPackage* resendingPackage;
		std::list<UDPPackage*> assembledPackages;

	public:
		CurrentSendingBuffer();
		~CurrentSendingBuffer()
		{
			if (rawBuffer)
				free(rawBuffer);

			//-- DO NOT delete encryptor!!! It belong to UDPIOBuffer.
		}

		void init(int bufferSize);
		void reset();
		void configProtocolVersion(uint8_t version) { protocolVersion = version; *dataBuffer = version; }
		void updateSendingInfo();
		UDPPackage* dumpPackage();
		void resendPackage(uint32_t seq, UDPPackage* package);
		void setType(uint8_t type);
		void setType(ARQType type);
		void addFlag(uint8_t flag);
		void setFlag(uint8_t flag);
		void setSign(uint8_t sign);
		void setUDPSeq(uint32_t seqBE);
		void setComponentType(uint8_t* componentBegin, uint8_t type);
		void setComponentType(uint8_t* componentBegin, ARQType type);
		void setComponentFlag(uint8_t* componentBegin, uint8_t flag);
		void setComponentBytes(uint8_t* componentBegin, size_t bytes);
		void setDataComponentPackageSeq(uint8_t* segmentBegin, uint16_t seq);
		size_t setDataComponentSegmentIndex(uint8_t* segmentBegin, uint32_t index);		//-- return index space size.
		bool changeCombinedPackageToSinglepackage();

		void changeForPackageAssembling();
		void assemblePackage(UDPPackage* package);
		void updateDataExpiredMsec(int64_t expireMsec);
	};

	class UDPAssembler
	{
		int _MTU;
		uint32_t _UDPSeqBase;
		uint16_t _packageIdNumber;
		uint8_t _protocolVersion;

		std::list<UDPDataUnit*> _dataQueue;
		ARQChecksum* _arqChecksum;
		ARQPeerSeqManager* _seqManager;
		SegmentInfo _sendingSegmentInfo;
		CurrentSendingBuffer _currentSendingBuffer;
		UDPEncryptor* _dataEncryptor;

	private:
		uint8_t genChecksum(uint32_t udpSeqBE);
		void prepareForceSyncSection();
		void prepareUNASection();
		void prepareAcksSection();
		bool prepareDataSection(int sectionCount);
		void prepareSingleDataSection(size_t availableSpace);
		bool prepareFirstSegmentedDataSection(size_t availableSpace);
		bool prepareSegmentedDataSection(int sectionCount);
		void prepareSegmentedDataExpiredSection(uint8_t flag, size_t idxSize);
		bool completeCommonPackage(int sectionCount);
		void fillDataSection(int& sectionCount);
		void preparePackageCompleted(bool discardable, uint32_t udpSeq, uint32_t udpSeqBE, uint8_t sign);
		void updateUDPSeq();

	public:
		UDPAssembler();
		~UDPAssembler();

		void init(int MTU);
		void configProtocolVersion(uint8_t version);
		void configDataEncryptor(UDPEncryptor* encryptor) { _dataEncryptor = encryptor; }
		void configARQPeerSeqManager(ARQPeerSeqManager* seqManager) { _seqManager = seqManager; }
		void pushDataToSendingQueue(std::string* data, int64_t expiredMS, bool discardable);

		void prepareClosePackage();
		void prepareHeartbeatPackage();
		//void updateUDPSeq();
		bool prepareCommonPackage();
		bool prepareUrgentARQSyncPackage(bool includeForceSyncSection, bool feedbackForceSync, bool canFillDataSections);
		void prepareECDHPackageAsInitiator(bool reinforcePackage, const std::string* packagePubKey, bool reinforceData, const std::string* dataPubKey = NULL);

		inline CurrentSendingBuffer* getSendingBuffer() { return &_currentSendingBuffer; }
	};
}

#endif
