# FPNN 介绍

**FPNN一句话总结：**

+ **客户端**：一个API解决所有操作
+ **服务器**：一个类继承解决所有 RPC、同步/异步、编码/解码、TCP/UDP 问题

## 一、开发背景

没有人想重复制造轮子。

但，当所有的轮都不好使的时候，怎么办？

鉴于之前的项目使用Thrift开发遇到了太多的坑，耗费大量的资源解决Thrift本身问题。  
基于对公司基础架构工具的准备及技术积累，结合之前对ICE、ACE、Codra等知名RPC框架的使用经验，于是决定开发一个更适合公司业务及基础架构的RPC框架。

轮子没有最好，只有最合适。

RPC框架也一样。

## 二、FPNN框架提供功能

* 支持 IPv4
* 支持 IPv6
* 支持 TCP 二进制私有协议
* 支持 UDP 二进制私有协议
* 支持可靠 UDP 链接
* 支持可靠/不可靠 UDP 数据混合发送
* 支持 HTTP 1.1 (选择性支持)
* 支持 WebSocket
* 支持 SSL/TLS
* 支持 msgpack 编码
* 支持 Json 格式
* 支持 可选参数
* 支持 不定类型参数
* 支持 不定长度不定类型参数
* 支持 接口灰度兼容
* 支持 TCP 二进制私有协议和 HTTP Json 格式互转

* 支持 Server Push
* 支持 异步操作
* 支持 同步操作
* 支持 Lambda 函数
* 支持 动态调整系统级参数
* 支持 动态调整框架级参数
* 支持 实时查看服务运行状态
* 支持 实时查看各参数状态
* 支持 failover
* 支持 统一 Log 汇总
* 支持 优雅退出
* 支持 统一处理异常
* 支持 同一端口多种协议(TCP/HTTP/WebSocket)
* 支持 应答提前返回
* 支持 应答异步返回
* 支持 请求响应时间统计
* 支持 QPS 统计
* 支持 慢请求统计
* 支持 优先执行系统内置命令

* 支持 AES 加密
* 支持 ECDH 秘钥交换
* 支持 128 位或 256 位秘钥
* 支持 IP 白名单
* 支持 IP 段白名单
* 支持 访问用户自定义接口时的加密限制
* 支持 访问用户自定义接口时的内网限制

在 FPNN 技术生态中，提供以下额外功能

* 支持 集群注册
* 支持 集群管理
* 支持 数据协调
* 支持 数据同步
* 支持 大规模分布式测试部署、监控、协调
* 支持 FPNN 集群透明代理
* 支持 MySQL 透明代理
* 支持 数据行级缓存

## 三、FPNN框架性能概览

压力测试(v1.0.0)：

**TCP 数据概要**

* 同一局域网

	| 机型 | 虚拟 CPU | 内存（GB） | 链接数量 | QPS | 平均响应时间（usec） |
	|-----|---------|-----------|---------|-----|------------------|
	| AWS m5.xlarge | 4 | 16 | 1000 | 49,708 | 335 |
	|---|---|---|---|---|---|
	| AWS m5.xlarge | 4 | 16 | 130 | 227,919 | 12,854 |
	| AWS m5.xlarge | 4 | 16 | 1,500 | 148,959 | 10,403 |
	| AWS m5.xlarge | 4 | 16 | 2,000 | 99,552 | 356 |
	| AWS m5.xlarge | 4 | 16 | 3,000 | 149,615 | 27,456 |

* 洲际传输：德国法兰克福 到 美国西部俄勒冈

	| 机型 | 虚拟 CPU | 内存（GB） | 链接数量 | QPS | 平均响应时间（usec） | ping/2 (msec) |
	|-----|---------|-----------|---------|-----|-------------------|---------------|
	| AWS m5.xlarge | 4 | 16 | 10 | 17,921 | 147,825 | 137 |
	|---|---|---|---|---|----|---|
	| AWS m5.xlarge | 4 | 16 | 190 | 338,601 | 151,772 | 139 |
	| AWS m5.xlarge | 4 | 16 | 700 | 339,240 | 183,541 | 136 ~ 137 |
	| AWS m5.xlarge | 4 | 16 | 3,200 | 312,073 | 256,980 | 139 ~ 141 |
	| AWS m5.xlarge | 4 | 16 | 6,000 | 299,175 | 346,927 | 136 ~ 137 |

**UDP 数据概要**

* 同一局域网

	| 机型 | 虚拟 CPU | 内存（GB） | 链接数量 | QPS | 平均响应时间（usec） |
	|-----|---------|-----------|---------|-----|------------------|
	| AWS m5.xlarge | 4 | 16 | 10 | 17,628 | 199 |
	|---|---|---|---|---|---|
	| AWS m5.xlarge | 4 | 16 | 70 | 123,009 | 1,174 |
	| AWS m5.xlarge | 4 | 16 | 80 | 122,641 | 24,623 |
	| AWS m5.xlarge | 4 | 16 | 800 | 73,030 | 1,306 |
	| AWS m5.xlarge | 4 | 16 | 200 | 95,894 | 400 |
	| AWS m5.xlarge | 4 | 16 | 1,000 | 49,590 | 3,832 |

* 洲际传输：德国法兰克福 到 美国西部俄勒冈

	| 机型 | 虚拟 CPU | 内存（GB） | 链接数量 | QPS | 平均响应时间（usec） | ping/2 (msec) |
	|-----|---------|-----------|---------|-----|-------------------|---------------|
	| AWS m5.xlarge | 4 | 16 | 100 | 48,493 | 138,859 | 138 |
	|---|---|---|---|---|----|---|
	| AWS m5.xlarge | 4 | 16 | 60 | 107,528 | 139,968 | 140 |
	| AWS m5.xlarge | 4 | 16 | 800 | 79,503 | 139,974 | 138 ~ 139 |


海量链接(v1.0.0)：

**TCP 数据概要**

| 机型 | 虚拟 CPU | 内存（GB） | 链接数量 | QPS | 平均响应时间（usec） |
|-----|---------|-----------|---------|-----|------------------|
| AWS m5.2xlarge | 8 | 32 | 2,040,000 | 81,351 | 446 |
| AWS m5.2xlarge | 8 | 32 | 2,040,000 | 137,294 | 4,985 |
| AWS m5.2xlarge | 8 | 32 | 2,040,000 | 179,794 | 11,345 |

**UDP 数据概要**

| 机型 | 虚拟 CPU | 内存（GB） | 链接数量 | QPS | 平均响应时间（usec） |
|-----|---------|-----------|---------|-----|------------------|
| AWS m5.2xlarge | 8 | 32 | 12,200 | 5,957 | 11,480 |
| AWS m5.2xlarge | 8 | 32 | 19,000 | 721 | 1,857 |

具体性能介绍及更多数据请参见 [FPNN 性能报告](doc/zh-cn/fpnn-performance.md)


## 四、使用

1. 环境需求

	| 操作系统 | 编译器 |
	|---------|-------|
	| CentOS 7 | GCC/G++ 4.8.5 |
	| CentOS 8 | GCC/G++ 8 |
	| Ubuntu 20 | GCC/G++ 9 |
	| MacOS 11.5 | XCode/Apple clang 12 |

1. 第三方库依赖

	+ gcc
	+ g++
	+ libcurl
	+ tcmalloc
	+ openssl

1. 编译安装FPNN框架

	在项目根目录下执行 `make` 即可。

	详细可参见 [FPNN 安装与集成](doc/zh-cn/fpnn-install.md)

1. 使用 FPNN 框架开发

	请参见

	1. [FPNN 服务端基础使用说明](doc/zh-cn/fpnn-server-basic-tutorial.md)
	1. [FPNN 服务端高级使用说明](doc/zh-cn/fpnn-server-advanced-tutorial.md)
	1. [FPNN 客户端基础使用说明](doc/zh-cn/fpnn-client-basic-tutorial.md)
	1. [FPNN 客户端高级使用说明](doc/zh-cn/fpnn-client-advanced-tutorial.md)

1. 注意事项 & 问题排查

	注意事项请参见 [FPNN 注意事项](doc/zh-cn/fpnn-notices.md)

	问题排查请参见 [FPNN 问题排查](doc/zh-cn/fpnn-troubleshooting.md)

1. 最佳实践

	1. [FPNN 最佳实践](doc/zh-cn/fpnn-best-practice.md)
	1. [FPNN 服务治理与服务网格](doc/zh-cn/fpnn-SOA-governance-service-mesh.md)

## 五、全部文档索引

[中文文档索引](doc/zh-cn/README.md)
 
