/*******************************************************************************
*
*  (C) COPYRIGHT AUTHORS, 2016
*
*  TITLE:       TABLES.H
*
*  VERSION:     1.00
*
*  DATE:        11 July 2016
*
*  Shadow table names for 7/8/8.1
*
* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
* ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
* TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
* PARTICULAR PURPOSE.
*
*******************************************************************************/
#pragma once

#define W32pServiceTableLimit_7601 827
#define W32pServiceTableLimit_9200 986
#define W32pServiceTableLimit_9600 1038

static const char *W32pServiceTableNames_7601[] = {
    "NtUserGetThreadState",
    "NtUserPeekMessage",
    "NtUserCallOneParam",
    "NtUserGetKeyState",
    "NtUserInvalidateRect",
    "NtUserCallNoParam",
    "NtUserGetMessage",
    "NtUserMessageCall",
    "NtGdiBitBlt",
    "NtGdiGetCharSet",
    "NtUserGetDC",
    "NtGdiSelectBitmap",
    "NtUserWaitMessage",
    "NtUserTranslateMessage",
    "NtUserGetProp",
    "NtUserPostMessage",
    "NtUserQueryWindow",
    "NtUserTranslateAccelerator",
    "NtGdiFlush",
    "NtUserRedrawWindow",
    "NtUserWindowFromPoint",
    "NtUserCallMsgFilter",
    "NtUserValidateTimerCallback",
    "NtUserBeginPaint",
    "NtUserSetTimer",
    "NtUserEndPaint",
    "NtUserSetCursor",
    "NtUserKillTimer",
    "NtUserBuildHwndList",
    "NtUserSelectPalette",
    "NtUserCallNextHookEx",
    "NtUserHideCaret",
    "NtGdiIntersectClipRect",
    "NtUserCallHwndLock",
    "NtUserGetProcessWindowStation",
    "NtGdiDeleteObjectApp",
    "NtUserSetWindowPos",
    "NtUserShowCaret",
    "NtUserEndDeferWindowPosEx",
    "NtUserCallHwndParamLock",
    "NtUserVkKeyScanEx",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtUserCallTwoParam",
    "NtGdiGetRandomRgn",
    "NtUserCopyAcceleratorTable",
    "NtUserNotifyWinEvent",
    "NtGdiExtSelectClipRgn",
    "NtUserIsClipboardFormatAvailable",
    "NtUserSetScrollInfo",
    "NtGdiStretchBlt",
    "NtUserCreateCaret",
    "NtGdiRectVisible",
    "NtGdiCombineRgn",
    "NtGdiGetDCObject",
    "NtUserDispatchMessage",
    "NtUserRegisterWindowMessage",
    "NtGdiExtTextOutW",
    "NtGdiSelectFont",
    "NtGdiRestoreDC",
    "NtGdiSaveDC",
    "NtUserGetForegroundWindow",
    "NtUserShowScrollBar",
    "NtUserFindExistingCursorIcon",
    "NtGdiGetDCDword",
    "NtGdiGetRegionData",
    "NtGdiLineTo",
    "NtUserSystemParametersInfo",
    "NtGdiGetAppClipBox",
    "NtUserGetAsyncKeyState",
    "NtUserGetCPD",
    "NtUserRemoveProp",
    "NtGdiDoPalette",
    "NtGdiPolyPolyDraw",
    "NtUserSetCapture",
    "NtUserEnumDisplayMonitors",
    "NtGdiCreateCompatibleBitmap",
    "NtUserSetProp",
    "NtGdiGetTextCharsetInfo",
    "NtUserSBGetParms",
    "NtUserGetIconInfo",
    "NtUserExcludeUpdateRgn",
    "NtUserSetFocus",
    "NtGdiExtGetObjectW",
    "NtUserDeferWindowPos",
    "NtUserGetUpdateRect",
    "NtGdiCreateCompatibleDC",
    "NtUserGetClipboardSequenceNumber",
    "NtGdiCreatePen",
    "NtUserShowWindow",
    "NtUserGetKeyboardLayoutList",
    "NtGdiPatBlt",
    "NtUserMapVirtualKeyEx",
    "NtUserSetWindowLong",
    "NtGdiHfontCreate",
    "NtUserMoveWindow",
    "NtUserPostThreadMessage",
    "NtUserDrawIconEx",
    "NtUserGetSystemMenu",
    "NtGdiDrawStream",
    "NtUserInternalGetWindowText",
    "NtUserGetWindowDC",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiInvertRgn",
    "NtGdiGetRgnBox",
    "NtGdiGetAndSetDCDword",
    "NtGdiMaskBlt",
    "NtGdiGetWidthTable",
    "NtUserScrollDC",
    "NtUserGetObjectInformation",
    "NtGdiCreateBitmap",
    "NtUserFindWindowEx",
    "NtGdiPolyPatBlt",
    "NtUserUnhookWindowsHookEx",
    "NtGdiGetNearestColor",
    "NtGdiTransformPoints",
    "NtGdiGetDCPoint",
    "NtGdiCreateDIBBrush",
    "NtGdiGetTextMetricsW",
    "NtUserCreateWindowEx",
    "NtUserSetParent",
    "NtUserGetKeyboardState",
    "NtUserToUnicodeEx",
    "NtUserGetControlBrush",
    "NtUserGetClassName",
    "NtGdiAlphaBlend",
    "NtGdiDdBlt",
    "NtGdiOffsetRgn",
    "NtUserDefSetText",
    "NtGdiGetTextFaceW",
    "NtGdiStretchDIBitsInternal",
    "NtUserSendInput",
    "NtUserGetThreadDesktop",
    "NtGdiCreateRectRgn",
    "NtGdiGetDIBitsInternal",
    "NtUserGetUpdateRgn",
    "NtGdiDeleteClientObj",
    "NtUserGetIconSize",
    "NtUserFillWindow",
    "NtGdiExtCreateRegion",
    "NtGdiComputeXformCoefficients",
    "NtUserSetWindowsHookEx",
    "NtUserNotifyProcessCreate",
    "NtGdiUnrealizeObject",
    "NtUserGetTitleBarInfo",
    "NtGdiRectangle",
    "NtUserSetThreadDesktop",
    "NtUserGetDCEx",
    "NtUserGetScrollBarInfo",
    "NtGdiGetTextExtent",
    "NtUserSetWindowFNID",
    "NtGdiSetLayout",
    "NtUserCalcMenuBar",
    "NtUserThunkedMenuItemInfo",
    "NtGdiExcludeClipRect",
    "NtGdiCreateDIBSection",
    "NtGdiGetDCforBitmap",
    "NtUserDestroyCursor",
    "NtUserDestroyWindow",
    "NtUserCallHwndParam",
    "NtGdiCreateDIBitmapInternal",
    "NtUserOpenWindowStation",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiDdCanCreateSurface",
    "NtGdiDdCreateSurface",
    "NtUserSetCursorIconData",
    "NtGdiDdDestroySurface",
    "NtUserCloseDesktop",
    "NtUserOpenDesktop",
    "NtUserSetProcessWindowStation",
    "NtUserGetAtomName",
    "NtGdiDdResetVisrgn",
    "NtGdiExtCreatePen",
    "NtGdiCreatePaletteInternal",
    "NtGdiSetBrushOrg",
    "NtUserBuildNameList",
    "NtGdiSetPixel",
    "NtUserRegisterClassExWOW",
    "NtGdiCreatePatternBrushInternal",
    "NtUserGetAncestor",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiSetBitmapBits",
    "NtUserCloseWindowStation",
    "NtUserGetDoubleClickTime",
    "NtUserEnableScrollBar",
    "NtGdiCreateSolidBrush",
    "NtUserGetClassInfoEx",
    "NtGdiCreateClientObj",
    "NtUserUnregisterClass",
    "NtUserDeleteMenu",
    "NtGdiRectInRegion",
    "NtUserScrollWindowEx",
    "NtGdiGetPixel",
    "NtUserSetClassLong",
    "NtUserGetMenuBarInfo",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiDdLockD3D",
    "NtGdiDdUnlockD3D",
    "NtGdiGetCharWidthW",
    "NtUserInvalidateRgn",
    "NtUserGetClipboardOwner",
    "NtUserSetWindowRgn",
    "NtUserBitBltSysBmp",
    "NtGdiGetCharWidthInfo",
    "NtUserValidateRect",
    "NtUserCloseClipboard",
    "NtUserOpenClipboard",
    "NtGdiGetStockObject",
    "NtUserSetClipboardData",
    "NtUserEnableMenuItem",
    "NtUserAlterWindowStyle",
    "NtGdiFillRgn",
    "NtUserGetWindowPlacement",
    "NtGdiModifyWorldTransform",
    "NtGdiGetFontData",
    "NtUserGetOpenClipboardWindow",
    "NtUserSetThreadState",
    "NtGdiOpenDCW",
    "NtUserTrackMouseEvent",
    "NtGdiGetTransform",
    "NtUserDestroyMenu",
    "NtGdiGetBitmapBits",
    "NtUserConsoleControl",
    "NtUserSetActiveWindow",
    "NtUserSetInformationThread",
    "NtUserSetWindowPlacement",
    "NtUserGetControlColor",
    "NtGdiSetMetaRgn",
    "NtGdiSetMiterLimit",
    "NtGdiSetVirtualResolution",
    "NtGdiGetRasterizerCaps",
    "NtUserSetWindowWord",
    "NtUserGetClipboardFormatName",
    "NtUserRealInternalGetMessage",
    "NtUserCreateLocalMemHandle",
    "NtUserAttachThreadInput",
    "NtGdiCreateHalftonePalette",
    "NtUserPaintMenuBar",
    "NtUserSetKeyboardState",
    "NtGdiCombineTransform",
    "NtUserCreateAcceleratorTable",
    "NtUserGetCursorFrameInfo",
    "NtUserGetAltTabInfo",
    "NtUserGetCaretBlinkTime",
    "NtGdiQueryFontAssocInfo",
    "NtUserProcessConnect",
    "NtUserEnumDisplayDevices",
    "NtUserEmptyClipboard",
    "NtUserGetClipboardData",
    "NtUserRemoveMenu",
    "NtGdiSetBoundsRect",
    "NtGdiGetBitmapDimension",
    "NtUserConvertMemHandle",
    "NtUserDestroyAcceleratorTable",
    "NtUserGetGUIThreadInfo",
    "NtGdiCloseFigure",
    "NtUserSetWindowsHookAW",
    "NtUserSetMenuDefaultItem",
    "NtUserCheckMenuItem",
    "NtUserSetWinEventHook",
    "NtUserUnhookWinEvent",
    "NtUserLockWindowUpdate",
    "NtUserSetSystemMenu",
    "NtUserThunkedMenuInfo",
    "NtGdiBeginPath",
    "NtGdiEndPath",
    "NtGdiFillPath",
    "NtUserCallHwnd",
    "NtUserDdeInitialize",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserCountClipboardFormats",
    "NtGdiAddFontMemResourceEx",
    "NtGdiEqualRgn",
    "NtGdiGetSystemPaletteUse",
    "NtGdiRemoveFontMemResourceEx",
    "NtUserEnumDisplaySettings",
    "NtUserPaintDesktop",
    "NtGdiExtEscape",
    "NtGdiSetBitmapDimension",
    "NtGdiSetFontEnumeration",
    "NtUserChangeClipboardChain",
    "NtUserSetClipboardViewer",
    "NtUserShowWindowAsync",
    "NtGdiCreateColorSpace",
    "NtGdiDeleteColorSpace",
    "NtUserActivateKeyboardLayout",
    "NtGdiAbortDoc",
    "NtGdiAbortPath",
    "NtGdiAddEmbFontToDC",
    "NtGdiAddFontResourceW",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiAngleArc",
    "NtGdiAnyLinkedFonts",
    "NtGdiArcInternal",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiBeginGdiRendering",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiCancelDC",
    "NtGdiChangeGhostFont",
    "NtGdiCheckBitmapBits",
    "NtGdiClearBitmapAttributes",
    "NtGdiUnloadPrinterDriver",
    "NtGdiColorCorrectPalette",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiConvertMetafileRect",
    "NtGdiCreateBitmapFromDxSurface",
    "NtGdiCreateColorTransform",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateServerMetaFile",
    "NtGdiD3dContextCreate",
    "NtGdiD3dContextDestroy",
    "NtGdiD3dContextDestroyAll",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCIGetTimingReport",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdAlphaBlt",
    "NtGdiDdAttachSurface",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDdColorControl",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdCreateFullscreenSprite",
    "NtGdiDdCreateMoComp",
    "NtGdiDdDDIAcquireKeyedMutex",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDICheckSharedResourceAccess",
    "NtGdiDdDDICheckVidPnExclusiveOwnership",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIConfigureSharedResource",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDICreateKeyedMutex",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDIDestroyKeyedMutex",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDIGetOverlayState",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDIGetPresentQueueEvent",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDILock",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDIOpenKeyedMutex",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIOpenSynchronizationObject",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDIReleaseKeyedMutex",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIRender",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiDdDestroyFullscreenSprite",
    "NtGdiDdDestroyMoComp",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdFlip",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdGetBltStatus",
    "NtGdiDdGetDC",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdGetDriverState",
    "NtGdiDdGetDxHandle",
    "NtGdiDdGetFlipStatus",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetMoCompBuffInfo",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDdGetScanLine",
    "NtGdiDdLock",
    "NtGdiDdNotifyFullscreenSpriteUpdate",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDdQueryVisRgnUniqueness",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDdReleaseDC",
    "NtGdiDdRenderMoComp",
    "NtGdiDdSetColorKey",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdSetGammaRamp",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdUnattachSurface",
    "NtGdiDdUnlock",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDeleteColorTransform",
    "NtGdiDescribePixelFormat",
    "NtGdiDestroyOPMProtectedOutput",
    "NtGdiDestroyPhysicalMonitor",
    "NtGdiDoBanding",
    "NtGdiDrawEscape",
    "NtGdiDvpAcquireNotification",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDvpColorControl",
    "NtGdiDvpCreateVideoPort",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDvpFlipVideoPort",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpReleaseNotification",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiDxgGenericThunk",
    "NtGdiEllipse",
    "NtGdiEnableEudc",
    "NtGdiEndDoc",
    "NtGdiEndGdiRendering",
    "NtGdiEndPage",
    "NtGdiEngAlphaBlend",
    "NtGdiEngAssociateSurface",
    "NtGdiEngBitBlt",
    "NtGdiEngCheckAbort",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCopyBits",
    "NtGdiEngCreateBitmap",
    "NtGdiEngCreateClip",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreatePalette",
    "NtGdiEngDeleteClip",
    "NtGdiEngDeletePalette",
    "NtGdiEngDeletePath",
    "NtGdiEngDeleteSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngFillPath",
    "NtGdiEngGradientFill",
    "NtGdiEngLineTo",
    "NtGdiEngLockSurface",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngPaint",
    "NtGdiEngPlgBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngStretchBltROP",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngStrokePath",
    "NtGdiEngTextOut",
    "NtGdiEngTransparentBlt",
    "NtGdiEngUnlockSurface",
    "NtGdiEnumFonts",
    "NtGdiEnumObjects",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiExtFloodFill",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFlattenPath",
    "NtGdiFontIsLinked",
    "NtGdiForceUFIMapping",
    "NtGdiFrameRgn",
    "NtGdiFullscreenControl",
    "NtGdiGetBoundsRect",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetCertificate",
    "NtGdiGetCertificateSize",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetColorAdjustment",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceWidth",
    "NtGdiGetDhpdev",
    "NtGdiGetETM",
    "NtGdiGetEmbUFI",
    "NtGdiGetEmbedFonts",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetFontFileData",
    "NtGdiGetFontFileInfo",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphOutline",
    "NtGdiGetKerningPairs",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetMiterLimit",
    "NtGdiGetMonitorID",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiGetOPMInformation",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetPath",
    "NtGdiGetPerBandInfo",
    "NtGdiGetPhysicalMonitorDescription",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetRealizationInfo",
    "NtGdiGetServerMetaFileBits",
    "NtGdiSetBrushAttributes",
    "NtGdiGetStats",
    "NtGdiGetStringBitmapW",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetTextExtentExW",
    "NtGdiGetUFI",
    "NtGdiGetUFIPathname",
    "NtGdiGradientFill",
    "NtGdiHLSurfGetInformation",
    "NtGdiHLSurfSetInformation",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiIcmBrushInfo",
    "NtGdiUnmapMemFont",
    "NtGdiInitSpool",
    "NtGdiMakeFontDir",
    "NtGdiMakeInfoDC",
    "NtGdiMakeObjectUnXferable",
    "NtGdiMakeObjectXferable",
    "NtGdiMirrorWindowOrg",
    "NtGdiMonoBitmap",
    "NtGdiMoveTo",
    "NtGdiOffsetClipRgn",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiPathToRegion",
    "NtGdiPlgBlt",
    "NtGdiPolyDraw",
    "NtGdiPolyTextOutW",
    "NtGdiPtInRegion",
    "NtGdiPtVisible",
    "NtGdiQueryFonts",
    "NtGdiRemoveFontResourceW",
    "NtGdiRemoveMergeFont",
    "NtGdiResetDC",
    "NtGdiResizePalette",
    "NtGdiRoundRect",
    "NtGdiSTROBJ_bEnum",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiScaleViewportExtEx",
    "NtGdiScaleWindowExtEx",
    "NtGdiSelectBrush",
    "NtGdiSelectClipPath",
    "NtGdiSelectPen",
    "NtGdiSetBitmapAttributes",
    "NtGdiGetSpoolMessage",
    "NtGdiSetColorAdjustment",
    "NtGdiSetColorSpace",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetFontXform",
    "NtGdiSetIcmMode",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetMagicColors",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetPUMPDOBJ",
    "NtGdiSetPixelFormat",
    "NtGdiSetRectRgn",
    "NtGdiSetSizeDevice",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetTextJustification",
    "NtGdiSfmGetNotificationTokens",
    "NtGdiStartDoc",
    "NtGdiStartPage",
    "NtGdiStrokeAndFillPath",
    "NtGdiStrokePath",
    "NtGdiSwapBuffers",
    "NtGdiTransparentBlt",
    "NtGdiUMPDEngFreeUserMem",
    "NtGdiClearBrushAttributes",
    "NtGdiInit",
    "NtGdiUpdateColors",
    "NtGdiUpdateTransform",
    "NtGdiWidenPath",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiXLATEOBJ_iXlate",
    "NtUserAddClipboardFormatListener",
    "NtUserAssociateInputContext",
    "NtUserBlockInput",
    "NtUserBuildHimcList",
    "NtUserBuildPropList",
    "NtUserCalculatePopupWindowPosition",
    "NtUserCallHwndOpt",
    "NtUserChangeDisplaySettings",
    "NtUserChangeWindowMessageFilterEx",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserCheckDesktopByThreadId",
    "NtUserCheckWindowThreadDesktop",
    "NtUserChildWindowFromPointEx",
    "NtUserClipCursor",
    "NtUserCreateDesktopEx",
    "NtUserCreateInputContext",
    "NtUserCreateWindowStation",
    "NtUserCtxDisplayIOCtl",
    "NtUserDestroyInputContext",
    "NtUserDisableThreadIme",
    "NtUserDisplayConfigGetDeviceInfo",
    "NtUserDisplayConfigSetDeviceInfo",
    "NtUserDoSoundConnect",
    "NtUserDoSoundDisconnect",
    "NtUserDragDetect",
    "NtUserDragObject",
    "NtUserDrawAnimatedRects",
    "NtUserDrawCaption",
    "NtUserDrawCaptionTemp",
    "NtUserDrawMenuBarTemp",
    "NtUserDwmStartRedirection",
    "NtUserDwmStopRedirection",
    "NtUserEndMenu",
    "NtUserEndTouchOperation",
    "NtUserEvent",
    "NtUserFlashWindowEx",
    "NtUserFrostCrashedWindow",
    "NtUserGetAppImeLevel",
    "NtUserGetCaretPos",
    "NtUserGetClipCursor",
    "NtUserGetClipboardViewer",
    "NtUserGetComboBoxInfo",
    "NtUserGetCursorInfo",
    "NtUserGetDisplayConfigBufferSizes",
    "NtUserGetGestureConfig",
    "NtUserGetGestureExtArgs",
    "NtUserGetGestureInfo",
    "NtUserGetGuiResources",
    "NtUserGetImeHotKey",
    "NtUserGetImeInfoEx",
    "NtUserGetInputLocaleInfo",
    "NtUserGetInternalWindowPos",
    "NtUserGetKeyNameText",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetLayeredWindowAttributes",
    "NtUserGetListBoxInfo",
    "NtUserGetMenuIndex",
    "NtUserGetMenuItemRect",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetRawInputBuffer",
    "NtUserGetRawInputData",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetTopLevelWindow",
    "NtUserGetTouchInputInfo",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetWOWClass",
    "NtUserGetWindowCompositionAttribute",
    "NtUserGetWindowCompositionInfo",
    "NtUserGetWindowDisplayAffinity",
    "NtUserGetWindowMinimizeRect",
    "NtUserGetWindowRgnEx",
    "NtUserGhostWindowFromHungWindow",
    "NtUserHardErrorControl",
    "NtUserHiliteMenuItem",
    "NtUserHungWindowFromGhostWindow",
    "NtUserHwndQueryRedirectionInfo",
    "NtUserHwndSetRedirectionInfo",
    "NtUserImpersonateDdeClientWindow",
    "NtUserInitTask",
    "NtUserInitialize",
    "NtUserInitializeClientPfnArrays",
    "NtUserInjectGesture",
    "NtUserInternalGetWindowIcon",
    "NtUserIsTopLevelWindow",
    "NtUserIsTouchWindow",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserLockWindowStation",
    "NtUserLockWorkStation",
    "NtUserLogicalToPhysicalPoint",
    "NtUserMNDragLeave",
    "NtUserMNDragOver",
    "NtUserMagControl",
    "NtUserMagGetContextInformation",
    "NtUserMagSetContextInformation",
    "NtUserManageGestureHandlerWindow",
    "NtUserMenuItemFromPoint",
    "NtUserMinMaximize",
    "NtUserModifyWindowTouchCapability",
    "NtUserNotifyIMEStatus",
    "NtUserOpenInputDesktop",
    "NtUserOpenThreadDesktop",
    "NtUserPaintMonitor",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPrintWindow",
    "NtUserQueryDisplayConfig",
    "NtUserQueryInformationThread",
    "NtUserQueryInputContext",
    "NtUserQuerySendMessage",
    "NtUserRealChildWindowFromPoint",
    "NtUserRealWaitMessageEx",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterHotKey",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterServicesProcess",
    "NtUserRegisterSessionPort",
    "NtUserRegisterTasklist",
    "NtUserRegisterUserApiHook",
    "NtUserRemoteConnect",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteStopScreenUpdates",
    "NtUserRemoveClipboardFormatListener",
    "NtUserResolveDesktopForWOW",
    "NtUserSendTouchInput",
    "NtUserSetAppImeLevel",
    "NtUserSetChildWindowNoActivate",
    "NtUserSetClassWord",
    "NtUserSetCursorContents",
    "NtUserSetDisplayConfig",
    "NtUserSetGestureConfig",
    "NtUserSetImeHotKey",
    "NtUserSetImeInfoEx",
    "NtUserSetImeOwnerWindow",
    "NtUserSetInternalWindowPos",
    "NtUserSetLayeredWindowAttributes",
    "NtUserSetMenu",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetMirrorRendering",
    "NtUserSetObjectInformation",
    "NtUserSetProcessDPIAware",
    "NtUserSetShellWindowEx",
    "NtUserSetSysColors",
    "NtUserSetSystemCursor",
    "NtUserSetSystemTimer",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetWindowCompositionAttribute",
    "NtUserSetWindowDisplayAffinity",
    "NtUserSetWindowRgnEx",
    "NtUserSetWindowStationUser",
    "NtUserSfmDestroyLogicalSurfaceBinding",
    "NtUserSfmDxBindSwapChain",
    "NtUserSfmDxGetSwapChainStats",
    "NtUserSfmDxOpenSwapChain",
    "NtUserSfmDxQuerySwapChainBindingStatus",
    "NtUserSfmDxReleaseSwapChain",
    "NtUserSfmDxReportPendingBindingsToDwm",
    "NtUserSfmDxSetSwapChainBindingStatus",
    "NtUserSfmDxSetSwapChainStats",
    "NtUserSfmGetLogicalSurfaceBinding",
    "NtUserShowSystemCursor",
    "NtUserSoundSentry",
    "NtUserSwitchDesktop",
    "NtUserTestForInteractiveUser",
    "NtUserTrackPopupMenuEx",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnlockWindowStation",
    "NtUserUnregisterHotKey",
    "NtUserUnregisterSessionPort",
    "NtUserUnregisterUserApiHook",
    "NtUserUpdateInputContext",
    "NtUserUpdateInstance",
    "NtUserUpdateLayeredWindow",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserUpdateWindowTransform",
    "NtUserUserHandleGrantAccess",
    "NtUserValidateHandleSecure",
    "NtUserWaitForInputIdle",
    "NtUserWaitForMsgAndEvent",
    "NtUserWindowFromPhysicalPoint",
    "NtUserYieldTask",
    "NtUserSetClassLongPtr",
    "NtUserSetWindowLongPtr"
};

static const char *W32pServiceTableNames_9200[] = {
    "NtUserYieldTask",
    "NtUserGetThreadState",
    "NtUserPeekMessage",
    "NtUserCallOneParam",
    "NtUserGetKeyState",
    "NtUserInvalidateRect",
    "NtUserCallNoParam",
    "NtUserGetMessage",
    "NtUserMessageCall",
    "NtGdiBitBlt",
    "NtGdiGetCharSet",
    "NtUserGetDC",
    "NtGdiSelectBitmap",
    "NtUserWaitMessage",
    "NtUserTranslateMessage",
    "NtUserGetProp",
    "NtUserPostMessage",
    "NtUserQueryWindow",
    "NtUserTranslateAccelerator",
    "NtGdiFlush",
    "NtUserRedrawWindow",
    "NtUserWindowFromPoint",
    "NtUserCallMsgFilter",
    "NtUserValidateTimerCallback",
    "NtUserBeginPaint",
    "NtUserSetTimer",
    "NtUserEndPaint",
    "NtUserSetCursor",
    "NtUserKillTimer",
    "NtUserBuildHwndList",
    "NtUserSelectPalette",
    "NtUserCallNextHookEx",
    "NtUserHideCaret",
    "NtGdiIntersectClipRect",
    "NtUserCallHwndLock",
    "NtUserGetProcessWindowStation",
    "NtGdiDeleteObjectApp",
    "NtUserSetWindowPos",
    "NtUserShowCaret",
    "NtUserEndDeferWindowPosEx",
    "NtUserCallHwndParamLock",
    "NtUserVkKeyScanEx",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtUserCallTwoParam",
    "NtGdiGetRandomRgn",
    "NtUserCopyAcceleratorTable",
    "NtUserNotifyWinEvent",
    "NtGdiExtSelectClipRgn",
    "NtUserIsClipboardFormatAvailable",
    "NtUserSetScrollInfo",
    "NtGdiStretchBlt",
    "NtUserCreateCaret",
    "NtGdiRectVisible",
    "NtGdiCombineRgn",
    "NtGdiGetDCObject",
    "NtUserDispatchMessage",
    "NtUserRegisterWindowMessage",
    "NtGdiExtTextOutW",
    "NtGdiSelectFont",
    "NtGdiRestoreDC",
    "NtGdiSaveDC",
    "NtUserGetForegroundWindow",
    "NtUserShowScrollBar",
    "NtUserFindExistingCursorIcon",
    "NtGdiGetDCDword",
    "NtGdiGetRegionData",
    "NtGdiLineTo",
    "NtUserSystemParametersInfo",
    "NtGdiGetAppClipBox",
    "NtUserGetAsyncKeyState",
    "NtUserGetCPD",
    "NtUserRemoveProp",
    "NtGdiDoPalette",
    "NtGdiPolyPolyDraw",
    "NtUserSetCapture",
    "NtUserEnumDisplayMonitors",
    "NtGdiCreateCompatibleBitmap",
    "NtUserSetProp",
    "NtGdiGetTextCharsetInfo",
    "NtUserSBGetParms",
    "NtUserGetIconInfo",
    "NtUserExcludeUpdateRgn",
    "NtUserSetFocus",
    "NtGdiExtGetObjectW",
    "NtUserGetUpdateRect",
    "NtGdiCreateCompatibleDC",
    "NtUserGetClipboardSequenceNumber",
    "NtGdiCreatePen",
    "NtUserShowWindow",
    "NtUserGetKeyboardLayoutList",
    "NtGdiPatBlt",
    "NtUserMapVirtualKeyEx",
    "NtUserSetWindowLong",
    "NtGdiHfontCreate",
    "NtUserMoveWindow",
    "NtUserPostThreadMessage",
    "NtUserDrawIconEx",
    "NtUserGetSystemMenu",
    "NtGdiDrawStream",
    "NtUserInternalGetWindowText",
    "NtUserGetWindowDC",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiInvertRgn",
    "NtGdiGetRgnBox",
    "NtGdiGetAndSetDCDword",
    "NtGdiMaskBlt",
    "NtGdiGetWidthTable",
    "NtUserScrollDC",
    "NtUserGetObjectInformation",
    "NtGdiCreateBitmap",
    "NtUserFindWindowEx",
    "NtGdiPolyPatBlt",
    "NtUserUnhookWindowsHookEx",
    "NtGdiGetNearestColor",
    "NtGdiTransformPoints",
    "NtGdiGetDCPoint",
    "NtGdiCreateDIBBrush",
    "NtGdiGetTextMetricsW",
    "NtUserCreateWindowEx",
    "NtUserSetParent",
    "NtUserGetKeyboardState",
    "NtUserToUnicodeEx",
    "NtUserGetControlBrush",
    "NtUserGetClassName",
    "NtGdiAlphaBlend",
    "NtGdiDdCreateMoComp",
    "NtGdiOffsetRgn",
    "NtUserDefSetText",
    "NtGdiGetTextFaceW",
    "NtGdiStretchDIBitsInternal",
    "NtUserSendInput",
    "NtUserGetThreadDesktop",
    "NtGdiCreateRectRgn",
    "NtGdiGetDIBitsInternal",
    "NtUserGetUpdateRgn",
    "NtGdiDeleteClientObj",
    "NtUserGetIconSize",
    "NtUserFillWindow",
    "NtGdiExtCreateRegion",
    "NtGdiComputeXformCoefficients",
    "NtUserSetWindowsHookEx",
    "NtUserNotifyProcessCreate",
    "NtGdiUnrealizeObject",
    "NtUserGetTitleBarInfo",
    "NtGdiRectangle",
    "NtUserSetThreadDesktop",
    "NtUserGetDCEx",
    "NtUserGetScrollBarInfo",
    "NtGdiGetTextExtent",
    "NtUserSetWindowFNID",
    "NtGdiSetLayout",
    "NtUserCalcMenuBar",
    "NtUserThunkedMenuItemInfo",
    "NtGdiExcludeClipRect",
    "NtGdiCreateDIBSection",
    "NtGdiGetDCforBitmap",
    "NtUserDestroyCursor",
    "NtUserDestroyWindow",
    "NtUserCallHwndParam",
    "NtGdiCreateDIBitmapInternal",
    "NtUserOpenWindowStation",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetMoCompBuffInfo",
    "NtUserSetCursorIconData",
    "NtGdiDvpCreateVideoPort",
    "NtUserCloseDesktop",
    "NtUserOpenDesktop",
    "NtUserSetProcessWindowStation",
    "NtUserGetAtomName",
    "NtGdiDvpAcquireNotification",
    "NtGdiExtCreatePen",
    "NtGdiCreatePaletteInternal",
    "NtGdiSetBrushOrg",
    "NtUserBuildNameList",
    "NtGdiSetPixel",
    "NtUserRegisterClassExWOW",
    "NtGdiCreatePatternBrushInternal",
    "NtUserGetAncestor",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiSetBitmapBits",
    "NtUserCloseWindowStation",
    "NtUserGetDoubleClickTime",
    "NtUserEnableScrollBar",
    "NtGdiCreateSolidBrush",
    "NtUserGetClassInfoEx",
    "NtGdiCreateClientObj",
    "NtUserUnregisterClass",
    "NtUserDeleteMenu",
    "NtGdiRectInRegion",
    "NtUserScrollWindowEx",
    "NtGdiGetPixel",
    "NtUserSetClassLong",
    "NtUserGetMenuBarInfo",
    "NtGdiDdUnlockD3D",
    "NtGdiDdGetScanLine",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdResetVisrgn",
    "NtGdiGetCharWidthW",
    "NtUserInvalidateRgn",
    "NtUserGetClipboardOwner",
    "NtUserSetWindowRgn",
    "NtUserBitBltSysBmp",
    "NtGdiGetCharWidthInfo",
    "NtUserValidateRect",
    "NtUserCloseClipboard",
    "NtUserOpenClipboard",
    "NtGdiGetStockObject",
    "NtUserSetClipboardData",
    "NtUserEnableMenuItem",
    "NtUserAlterWindowStyle",
    "NtGdiFillRgn",
    "NtUserGetWindowPlacement",
    "NtGdiModifyWorldTransform",
    "NtGdiGetFontData",
    "NtUserGetOpenClipboardWindow",
    "NtUserSetThreadState",
    "NtGdiOpenDCW",
    "NtUserTrackMouseEvent",
    "NtGdiGetTransform",
    "NtUserDestroyMenu",
    "NtGdiGetBitmapBits",
    "NtUserConsoleControl",
    "NtUserSetActiveWindow",
    "NtUserSetInformationThread",
    "NtUserSetWindowPlacement",
    "NtUserGetControlColor",
    "NtGdiSetMetaRgn",
    "NtGdiSetMiterLimit",
    "NtGdiSetVirtualResolution",
    "NtGdiGetRasterizerCaps",
    "NtUserSetWindowWord",
    "NtUserGetClipboardFormatName",
    "NtUserRealInternalGetMessage",
    "NtUserCreateLocalMemHandle",
    "NtUserAttachThreadInput",
    "NtGdiCreateHalftonePalette",
    "NtUserPaintMenuBar",
    "NtUserSetKeyboardState",
    "NtGdiCombineTransform",
    "NtUserCreateAcceleratorTable",
    "NtUserGetCursorFrameInfo",
    "NtUserGetAltTabInfo",
    "NtUserGetCaretBlinkTime",
    "NtGdiQueryFontAssocInfo",
    "NtUserProcessConnect",
    "NtUserEnumDisplayDevices",
    "NtUserEmptyClipboard",
    "NtUserGetClipboardData",
    "NtUserRemoveMenu",
    "NtGdiSetBoundsRect",
    "NtGdiGetBitmapDimension",
    "NtUserConvertMemHandle",
    "NtUserDestroyAcceleratorTable",
    "NtUserGetGUIThreadInfo",
    "NtGdiCloseFigure",
    "NtUserSetWindowsHookAW",
    "NtUserSetMenuDefaultItem",
    "NtUserCheckMenuItem",
    "NtUserSetWinEventHook",
    "NtUserUnhookWinEvent",
    "NtUserLockWindowUpdate",
    "NtUserSetSystemMenu",
    "NtUserThunkedMenuInfo",
    "NtGdiBeginPath",
    "NtGdiEndPath",
    "NtGdiFillPath",
    "NtUserCallHwnd",
    "NtUserDdeInitialize",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserCountClipboardFormats",
    "NtGdiAddFontMemResourceEx",
    "NtGdiEqualRgn",
    "NtGdiGetSystemPaletteUse",
    "NtGdiRemoveFontMemResourceEx",
    "NtUserEnumDisplaySettings",
    "NtUserPaintDesktop",
    "NtGdiExtEscape",
    "NtGdiSetBitmapDimension",
    "NtGdiSetFontEnumeration",
    "NtUserChangeClipboardChain",
    "NtUserSetClipboardViewer",
    "NtUserShowWindowAsync",
    "NtGdiCreateColorSpace",
    "NtGdiDeleteColorSpace",
    "NtUserActivateKeyboardLayout",
    "NtBindCompositionSurface",
    "NtCreateCompositionSurfaceHandle",
    "NtDCompositionAddCrossDeviceVisualChild",
    "NtDCompositionAddVisualChild",
    "NtDCompositionBeginFrame",
    "NtDCompositionCommitChannel",
    "NtDCompositionConfirmFrame",
    "NtDCompositionGetChannels",
    "NtDCompositionCreateChannel",
    "NtDCompositionCreateConnectionContext",
    "NtDCompositionCreateDwmChannel",
    "NtDCompositionCreateResource",
    "NtDCompositionCurrentBatchId",
    "NtDCompositionDestroyChannel",
    "NtDCompositionDestroyConnectionContext",
    "NtDCompositionDiscardFrame",
    "NtDCompositionDwmSyncFlush",
    "NtDCompositionConnectPipe",
    "NtDCompositionGetConnectionContextBatch",
    "NtDCompositionGetDeletedResources",
    "NtDCompositionGetFrameLegacyTokens",
    "NtDCompositionGetFrameStatistics",
    "NtDCompositionGetFrameSurfaceUpdates",
    "NtDCompositionReleaseAllResources",
    "NtDCompositionReleaseResource",
    "NtDCompositionRemoveCrossDeviceVisualChild",
    "NtDCompositionRemoveVisualChild",
    "NtDCompositionReplaceVisualChildren",
    "NtDCompositionRetireFrame",
    "NtDCompositionSetChannelCommitCompletionEvent",
    "NtDCompositionSetResourceAnimationProperty",
    "NtDCompositionSetResourceBufferProperty",
    "NtDCompositionSetResourceDeletedNotificationTag",
    "NtDCompositionSetResourceFloatProperty",
    "NtDCompositionSetResourceIntegerProperty",
    "NtDCompositionSetResourceReferenceArrayProperty",
    "NtDCompositionSetResourceReferenceProperty",
    "NtDCompositionSignalGpuFence",
    "NtDCompositionSubmitDWMBatch",
    "NtDCompositionSynchronize",
    "NtDCompositionTelemetryTouchInteractionBegin",
    "NtDCompositionTelemetryTouchInteractionEnd",
    "NtDCompositionTelemetryTouchInteractionUpdate",
    "NtDCompositionValidateAndReferenceSystemVisualForHwndTarget",
    "NtDCompositionWaitForChannel",
    "NtGdiAbortDoc",
    "NtGdiAbortPath",
    "NtGdiAddEmbFontToDC",
    "NtGdiAddFontResourceW",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiAngleArc",
    "NtGdiAnyLinkedFonts",
    "NtGdiArcInternal",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiBeginGdiRendering",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiCancelDC",
    "NtGdiChangeGhostFont",
    "NtGdiCheckBitmapBits",
    "NtGdiClearBitmapAttributes",
    "NtGdiClearBrushAttributes",
    "NtGdiColorCorrectPalette",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiConvertMetafileRect",
    "NtGdiCreateBitmapFromDxSurface",
    "NtGdiCreateBitmapFromDxSurface2",
    "NtGdiCreateColorTransform",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateServerMetaFile",
    "NtGdiCreateSessionMappedDIBSection",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDdUnlock",
    "NtGdiDdCanCreateSurface",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCIGetTimingReport",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDdGetFlipStatus",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDdSetGammaRamp",
    "NtGdiD3dContextCreate",
    "NtGdiDdDestroySurface",
    "NtGdiDvpReleaseNotification",
    "NtGdiDdAlphaBlt",
    "NtGdiDdCreateFullscreenSprite",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdDDIAcquireKeyedMutex",
    "NtGdiDdDDIAcquireKeyedMutex2",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDICheckSharedResourceAccess",
    "NtGdiDdDDICheckVidPnExclusiveOwnership",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIConfigureSharedResource",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDICreateKeyedMutex",
    "NtGdiDdDDICreateKeyedMutex2",
    "NtGdiDdDDICreateOutputDupl",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDIDestroyKeyedMutex",
    "NtGdiDdDDIDestroyOutputDupl",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIEnumAdapters",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIGetContextInProcessSchedulingPriority",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDIGetOverlayState",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDIGetPresentQueueEvent",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDIGetSharedResourceAdapterLuid",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDILock",
    "NtGdiDdDDIOfferAllocations",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDIOpenAdapterFromLuid",
    "NtGdiDdDDIOpenKeyedMutex",
    "NtGdiDdDDIOpenKeyedMutex2",
    "NtGdiDdDDIOpenNtHandleFromName",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIOpenResourceFromNtHandle",
    "NtGdiDdDDIOpenSyncObjectFromNtHandle",
    "NtGdiDdDDIOpenSynchronizationObject",
    "NtGdiDdDDIOutputDuplGetFrameInfo",
    "NtGdiDdDDIOutputDuplGetMetaData",
    "NtGdiDdDDIOutputDuplGetPointerShapeData",
    "NtGdiDdDDIOutputDuplPresent",
    "NtGdiDdDDIOutputDuplReleaseFrame",
    "NtGdiDdDDIPinDirectFlipResources",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDIQueryRemoteVidPnSourceFromGdiDisplayName",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDIQueryResourceInfoFromNtHandle",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDIReclaimAllocations",
    "NtGdiDdDDIReleaseKeyedMutex",
    "NtGdiDdDDIReleaseKeyedMutex2",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIRender",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDISetContextInProcessSchedulingPriority",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDISetStereoEnabled",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDISetVidPnSourceOwner1",
    "NtGdiDdDDIShareObjects",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDIUnpinDirectFlipResources",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDDIWaitForVerticalBlankEvent2",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdDestroyFullscreenSprite",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdLockD3D",
    "NtGdiDdBlt",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiDdDestroyMoComp",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDdSetColorKey",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpFlipVideoPort",
    "NtGdiD3dContextDestroy",
    "NtGdiDvpColorControl",
    "NtGdiDdNotifyFullscreenSpriteUpdate",
    "NtGdiDdGetDC",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiDdQueryVisRgnUniqueness",
    "NtGdiDdReleaseDC",
    "NtGdiDdColorControl",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDdAttachSurface",
    "NtGdiDdGetDxHandle",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdUnattachSurface",
    "NtGdiDdGetBltStatus",
    "NtGdiDdRenderMoComp",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDeleteColorTransform",
    "NtGdiDescribePixelFormat",
    "NtGdiDestroyOPMProtectedOutput",
    "UnknownSyscall",
    "NtGdiDoBanding",
    "NtGdiDrawEscape",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiD3dContextDestroyAll",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDdGetDriverState",
    "NtGdiDdCreateSurface",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdLock",
    "NtGdiDdFlip",
    "NtGdiDwmCreatedBitmapRemotingOutput",
    "NtGdiDxgGenericThunk",
    "NtGdiEllipse",
    "NtGdiEnableEudc",
    "NtGdiEndDoc",
    "NtGdiEndGdiRendering",
    "NtGdiEndPage",
    "NtGdiEngAlphaBlend",
    "NtGdiEngAssociateSurface",
    "NtGdiEngBitBlt",
    "NtGdiEngCheckAbort",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCopyBits",
    "NtGdiEngCreateBitmap",
    "NtGdiEngCreateClip",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreatePalette",
    "NtGdiEngDeleteClip",
    "NtGdiEngDeletePalette",
    "NtGdiEngDeletePath",
    "NtGdiEngDeleteSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngFillPath",
    "NtGdiEngGradientFill",
    "NtGdiEngLineTo",
    "NtGdiEngLockSurface",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngPaint",
    "NtGdiEngPlgBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngStretchBltROP",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngStrokePath",
    "NtGdiEngTextOut",
    "NtGdiEngTransparentBlt",
    "NtGdiEngUnlockSurface",
    "NtGdiEnumFonts",
    "NtGdiEnumObjects",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiExtFloodFill",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFlattenPath",
    "NtGdiFontIsLinked",
    "NtGdiForceUFIMapping",
    "NtGdiFrameRgn",
    "NtGdiFullscreenControl",
    "NtGdiGetBoundsRect",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetCertificate",
    "NtGdiGetCertificateSize",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetColorAdjustment",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceWidth",
    "NtGdiGetDhpdev",
    "NtGdiGetETM",
    "NtGdiGetEmbUFI",
    "NtGdiGetEmbedFonts",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetFontFileData",
    "NtGdiGetFontFileInfo",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphOutline",
    "NtGdiGetKerningPairs",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetMiterLimit",
    "NtGdiGetMonitorID",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiGetOPMInformation",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetPath",
    "NtGdiGetPerBandInfo",
    "NtGdiGetPhysicalMonitorDescription",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetRealizationInfo",
    "NtGdiGetServerMetaFileBits",
    "NtGdiUnloadPrinterDriver",
    "NtGdiGetStats",
    "NtGdiGetStringBitmapW",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetTextExtentExW",
    "NtGdiGetUFI",
    "NtGdiGetUFIPathname",
    "NtGdiGradientFill",
    "NtGdiHLSurfGetInformation",
    "NtGdiHLSurfSetInformation",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiIcmBrushInfo",
    "NtGdiUnmapMemFont",
    "NtGdiInitSpool",
    "NtGdiMakeFontDir",
    "NtGdiMakeInfoDC",
    "NtGdiMakeObjectUnXferable",
    "NtGdiMakeObjectXferable",
    "NtGdiMirrorWindowOrg",
    "NtGdiMonoBitmap",
    "NtGdiMoveTo",
    "NtGdiOffsetClipRgn",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiPathToRegion",
    "NtGdiPlgBlt",
    "NtGdiPolyDraw",
    "NtGdiPolyTextOutW",
    "NtGdiPtInRegion",
    "NtGdiPtVisible",
    "NtGdiQueryFonts",
    "NtGdiRemoveFontResourceW",
    "NtGdiRemoveMergeFont",
    "NtGdiResetDC",
    "NtGdiResizePalette",
    "NtGdiRoundRect",
    "NtGdiSTROBJ_bEnum",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiScaleViewportExtEx",
    "NtGdiScaleWindowExtEx",
    "NtGdiSelectBrush",
    "NtGdiSelectClipPath",
    "NtGdiSelectPen",
    "NtGdiSetBitmapAttributes",
    "NtGdiSetBrushAttributes",
    "NtGdiSetColorAdjustment",
    "NtGdiSetColorSpace",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetFontXform",
    "NtGdiSetIcmMode",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetMagicColors",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetPUMPDOBJ",
    "NtGdiSetPixelFormat",
    "NtGdiSetRectRgn",
    "NtGdiSetSizeDevice",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetTextJustification",
    "NtGdiSetUMPDSandboxState",
    "NtGdiStartDoc",
    "NtGdiStartPage",
    "NtGdiStrokeAndFillPath",
    "NtGdiStrokePath",
    "NtGdiSwapBuffers",
    "NtGdiTransparentBlt",
    "NtGdiUMPDEngFreeUserMem",
    "NtGdiGetSpoolMessage",
    "NtGdiInit",
    "NtGdiUpdateColors",
    "NtGdiUpdateTransform",
    "NtGdiWidenPath",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiXLATEOBJ_iXlate",
    "NtNotifyPresentToCompositionSurface",
    "NtOpenCompositionSurfaceDirtyRegion",
    "NtOpenCompositionSurfaceSectionInfo",
    "NtOpenCompositionSurfaceSwapChainHandleInfo",
    "NtQueryCompositionSurfaceBinding",
    "NtQueryCompositionSurfaceRenderingRealization",
    "NtQueryCompositionSurfaceStatistics",
    "NtSetCompositionSurfaceOutOfFrameDirectFlipNotification",
    "NtSetCompositionSurfaceStatistics",
    "NtTokenManagerGetOutOfFrameDirectFlipSurfaceUpdates",
    "NtTokenManagerOpenEvent",
    "NtTokenManagerThread",
    "NtUnBindCompositionSurface",
    "NtUserAcquireIAMKey",
    "NtUserAddClipboardFormatListener",
    "NtUserAssociateInputContext",
    "NtUserAutoPromoteMouseInPointer",
    "NtUserAutoRotateScreen",
    "NtUserBlockInput",
    "NtUserBuildHimcList",
    "NtUserBuildPropList",
    "NtUserCalculatePopupWindowPosition",
    "NtUserCallHwndOpt",
    "NtUserCanBrokerForceForeground",
    "NtUserChangeDisplaySettings",
    "NtUserChangeWindowMessageFilterEx",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserCheckProcessForClipboardAccess",
    "NtUserCheckProcessSession",
    "NtUserCheckWindowThreadDesktop",
    "NtUserChildWindowFromPointEx",
    "NtUserClipCursor",
    "NtUserCreateDCompositionHwndTarget",
    "NtUserCreateDesktopEx",
    "NtUserCreateInputContext",
    "NtUserCreateWindowStation",
    "NtUserCtxDisplayIOCtl",
    "NtUserDeferWindowPosAndBand",
    "NtUserDelegateCapturePointers",
    "NtUserDelegateInput",
    "NtUserDestroyDCompositionHwndTarget",
    "NtUserDestroyInputContext",
    "NtUserDisableImmersiveOwner",
    "NtUserDisableProcessWindowFiltering",
    "NtUserDisableThreadIme",
    "NtUserDiscardPointerFrameMessages",
    "NtUserDisplayConfigGetDeviceInfo",
    "NtUserDisplayConfigSetDeviceInfo",
    "NtUserDoSoundConnect",
    "NtUserDoSoundDisconnect",
    "NtUserDragDetect",
    "NtUserDragObject",
    "NtUserDrawAnimatedRects",
    "NtUserDrawCaption",
    "NtUserDrawCaptionTemp",
    "NtUserDrawMenuBarTemp",
    "NtUserDwmGetRemoteSessionOcclusionEvent",
    "NtUserDwmGetRemoteSessionOcclusionState",
    "NtUserDwmStartRedirection",
    "NtUserDwmStopRedirection",
    "NtUserDwmValidateWindow",
    "NtUserEnableIAMAccess",
    "NtUserEnableMouseInPointer",
    "NtUserEnableMouseInputForCursorSuppression",
    "NtUserEndMenu",
    "NtUserEvent",
    "NtUserFlashWindowEx",
    "NtUserFrostCrashedWindow",
    "NtUserGetAppImeLevel",
    "NtUserGetAutoRotationState",
    "NtUserGetCIMSSM",
    "NtUserGetCaretPos",
    "NtUserGetClipCursor",
    "NtUserGetClipboardAccessToken",
    "NtUserGetClipboardViewer",
    "NtUserGetComboBoxInfo",
    "NtUserGetCurrentInputMessageSource",
    "NtUserGetCursorInfo",
    "NtUserGetDesktopID",
    "NtUserGetDisplayAutoRotationPreferences",
    "NtUserGetDisplayAutoRotationPreferencesByProcessId",
    "NtUserGetDisplayConfigBufferSizes",
    "NtUserGetGestureConfig",
    "NtUserGetGestureExtArgs",
    "NtUserGetGestureInfo",
    "NtUserGetGlobalIMEStatus",
    "NtUserGetGuiResources",
    "NtUserGetImeHotKey",
    "NtUserGetImeInfoEx",
    "NtUserGetInputLocaleInfo",
    "NtUserGetInternalWindowPos",
    "NtUserGetKeyNameText",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetLayeredWindowAttributes",
    "NtUserGetListBoxInfo",
    "NtUserGetMenuIndex",
    "NtUserGetMenuItemRect",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetPointerCursorId",
    "NtUserGetPointerDevice",
    "NtUserGetPointerDeviceCursors",
    "NtUserGetPointerDeviceProperties",
    "NtUserGetPointerDeviceRects",
    "NtUserGetPointerDevices",
    "NtUserGetPointerInfoList",
    "NtUserGetPointerType",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetProcessUIContextInformation",
    "NtUserGetQueueEventStatus",
    "NtUserGetRawInputBuffer",
    "NtUserGetRawInputData",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRawPointerDeviceData",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetTopLevelWindow",
    "NtUserGetTouchInputInfo",
    "NtUserGetTouchValidationStatus",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetWOWClass",
    "NtUserGetWindowBand",
    "NtUserGetWindowCompositionAttribute",
    "NtUserGetWindowCompositionInfo",
    "NtUserGetWindowDisplayAffinity",
    "NtUserGetWindowFeedbackSetting",
    "NtUserGetWindowMinimizeRect",
    "NtUserGetWindowRgnEx",
    "NtUserGhostWindowFromHungWindow",
    "NtUserHandleDelegatedInput",
    "NtUserHardErrorControl",
    "NtUserHidePointerContactVisualization",
    "NtUserHiliteMenuItem",
    "NtUserHungWindowFromGhostWindow",
    "NtUserHwndQueryRedirectionInfo",
    "NtUserHwndSetRedirectionInfo",
    "NtUserImpersonateDdeClientWindow",
    "NtUserInitTask",
    "NtUserInitialize",
    "NtUserInitializeClientPfnArrays",
    "NtUserInitializeTouchInjection",
    "NtUserInjectGesture",
    "NtUserInjectTouchInput",
    "NtUserInternalClipCursor",
    "NtUserInternalGetWindowIcon",
    "NtUserIsMouseInPointerEnabled",
    "NtUserIsMouseInputEnabled",
    "NtUserIsTopLevelWindow",
    "NtUserIsTouchWindow",
    "NtUserLayoutCompleted",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserLockWindowStation",
    "NtUserLockWorkStation",
    "NtUserLogicalToPhysicalPoint",
    "NtUserMNDragLeave",
    "NtUserMNDragOver",
    "NtUserMagControl",
    "NtUserMagGetContextInformation",
    "NtUserMagSetContextInformation",
    "NtUserMenuItemFromPoint",
    "NtUserMinMaximize",
    "NtUserModifyWindowTouchCapability",
    "NtUserNotifyIMEStatus",
    "NtUserOpenInputDesktop",
    "NtUserOpenThreadDesktop",
    "NtUserPaintMonitor",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPrintWindow",
    "NtUserPromoteMouseInPointer",
    "NtUserPromotePointer",
    "NtUserQueryBSDRWindow",
    "NtUserQueryDisplayConfig",
    "NtUserQueryInformationThread",
    "NtUserQueryInputContext",
    "NtUserQuerySendMessage",
    "NtUserRealChildWindowFromPoint",
    "NtUserRealWaitMessageEx",
    "NtUserRegisterBSDRWindow",
    "NtUserRegisterEdgy",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterHotKey",
    "NtUserRegisterPointerDeviceNotifications",
    "NtUserRegisterPointerInputTarget",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterServicesProcess",
    "NtUserRegisterSessionPort",
    "NtUserRegisterTasklist",
    "NtUserRegisterTouchHitTestingWindow",
    "NtUserRegisterUserApiHook",
    "NtUserRemoteConnect",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteStopScreenUpdates",
    "NtUserRemoveClipboardFormatListener",
    "NtUserResolveDesktopForWOW",
    "NtUserSendEventMessage",
    "NtUserSetActiveProcess",
    "NtUserSetAppImeLevel",
    "NtUserSetAutoRotation",
    "NtUserSetBrokeredForeground",
    "NtUserSetCalibrationData",
    "NtUserSetChildWindowNoActivate",
    "NtUserSetClassWord",
    "NtUserSetCursorContents",
    "NtUserSetDisplayAutoRotationPreferences",
    "NtUserSetDisplayConfig",
    "NtUserSetDisplayMapping",
    "NtUserSetFallbackForeground",
    "NtUserSetGestureConfig",
    "NtUserSetImeHotKey",
    "NtUserSetImeInfoEx",
    "NtUserSetImeOwnerWindow",
    "NtUserSetImmersiveBackgroundWindow",
    "NtUserSetInternalWindowPos",
    "NtUserSetLayeredWindowAttributes",
    "NtUserSetMenu",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetMirrorRendering",
    "NtUserSetObjectInformation",
    "NtUserSetProcessDPIAware",
    "NtUserSetProcessRestrictionExemption",
    "NtUserSetProcessUIAccessZorder",
    "NtUserSetSensorPresence",
    "NtUserSetShellWindowEx",
    "NtUserSetSysColors",
    "NtUserSetSystemCursor",
    "NtUserSetSystemTimer",
    "NtUserSetThreadInputBlocked",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetWindowBand",
    "NtUserSetWindowCompositionAttribute",
    "NtUserSetWindowCompositionTransition",
    "NtUserSetWindowDisplayAffinity",
    "NtUserSetWindowFeedbackSetting",
    "NtUserSetWindowRgnEx",
    "NtUserSetWindowStationUser",
    "NtUserShowSystemCursor",
    "NtUserShutdownBlockReasonCreate",
    "NtUserShutdownBlockReasonQuery",
    "NtUserShutdownReasonDestroy",
    "NtUserSignalRedirectionStartComplete",
    "NtUserSlicerControl",
    "NtUserSoundSentry",
    "NtUserSwitchDesktop",
    "NtUserTestForInteractiveUser",
    "NtUserTrackPopupMenuEx",
    "NtUserUndelegateInput",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnlockWindowStation",
    "NtUserUnregisterHotKey",
    "NtUserUnregisterSessionPort",
    "NtUserUnregisterUserApiHook",
    "NtUserUpdateDefaultDesktopThumbnail",
    "NtUserUpdateInputContext",
    "NtUserUpdateInstance",
    "NtUserUpdateLayeredWindow",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserUpdateWindowTransform",
    "NtUserUserHandleGrantAccess",
    "NtUserValidateHandleSecure",
    "NtUserWaitAvailableMessageEx",
    "NtUserWaitForInputIdle",
    "NtUserWaitForMsgAndEvent",
    "NtUserWaitForRedirectionStartComplete",
    "NtUserWindowFromPhysicalPoint",
    "NtValidateCompositionSurfaceHandle",
    "NtUserSetClassLongPtr",
    "NtUserSetWindowLongPtr"
};

static const char *W32pServiceTableNames_9600[] = {
    "NtUserYieldTask",
    "NtUserSetSensorPresence",
    "NtUserGetThreadState",
    "NtUserPeekMessage",
    "NtUserCallOneParam",
    "NtUserGetKeyState",
    "NtUserInvalidateRect",
    "NtUserCallNoParam",
    "NtUserGetMessage",
    "NtUserMessageCall",
    "NtGdiBitBlt",
    "NtGdiGetCharSet",
    "NtUserGetDC",
    "NtGdiSelectBitmap",
    "NtUserWaitMessage",
    "NtUserTranslateMessage",
    "NtUserGetProp",
    "NtUserPostMessage",
    "NtUserQueryWindow",
    "NtUserTranslateAccelerator",
    "NtGdiFlush",
    "NtUserRedrawWindow",
    "NtUserWindowFromPhysicalPoint",
    "NtUserCallMsgFilter",
    "NtUserValidateTimerCallback",
    "NtUserBeginPaint",
    "NtUserSetTimer",
    "NtUserEndPaint",
    "NtUserSetCursor",
    "NtUserKillTimer",
    "NtUserBuildHwndList",
    "NtUserSelectPalette",
    "NtUserCallNextHookEx",
    "NtUserHideCaret",
    "NtGdiIntersectClipRect",
    "NtUserCallHwndLock",
    "NtUserGetProcessWindowStation",
    "NtGdiDeleteObjectApp",
    "NtUserSetWindowPos",
    "NtUserShowCaret",
    "NtUserEndDeferWindowPosEx",
    "NtUserCallHwndParamLock",
    "NtUserVkKeyScanEx",
    "NtGdiSetDIBitsToDeviceInternal",
    "NtUserCallTwoParam",
    "NtGdiGetRandomRgn",
    "NtUserCopyAcceleratorTable",
    "NtUserNotifyWinEvent",
    "NtGdiExtSelectClipRgn",
    "NtUserIsClipboardFormatAvailable",
    "NtUserSetScrollInfo",
    "NtGdiStretchBlt",
    "NtUserCreateCaret",
    "NtGdiRectVisible",
    "NtGdiCombineRgn",
    "NtGdiGetDCObject",
    "NtUserDispatchMessage",
    "NtUserRegisterWindowMessage",
    "NtGdiExtTextOutW",
    "NtGdiSelectFont",
    "NtGdiRestoreDC",
    "NtGdiSaveDC",
    "NtUserGetForegroundWindow",
    "NtUserShowScrollBar",
    "NtUserFindExistingCursorIcon",
    "NtGdiGetDCDword",
    "NtGdiGetRegionData",
    "NtGdiLineTo",
    "NtUserSystemParametersInfo",
    "NtGdiGetAppClipBox",
    "NtUserGetAsyncKeyState",
    "NtUserGetCPD",
    "NtUserRemoveProp",
    "NtGdiDoPalette",
    "NtGdiPolyPolyDraw",
    "NtUserSetCapture",
    "NtUserEnumDisplayMonitors",
    "NtGdiCreateCompatibleBitmap",
    "NtUserSetProp",
    "NtGdiGetTextCharsetInfo",
    "NtUserSBGetParms",
    "NtUserGetIconInfo",
    "NtUserExcludeUpdateRgn",
    "NtUserSetFocus",
    "NtGdiExtGetObjectW",
    "NtUserGetUpdateRect",
    "NtGdiCreateCompatibleDC",
    "NtUserGetClipboardSequenceNumber",
    "NtGdiCreatePen",
    "NtUserShowWindow",
    "NtUserGetKeyboardLayoutList",
    "NtGdiPatBlt",
    "NtUserMapVirtualKeyEx",
    "NtUserSetWindowLong",
    "NtGdiHfontCreate",
    "NtUserMoveWindow",
    "NtUserPostThreadMessage",
    "NtUserDrawIconEx",
    "NtUserGetSystemMenu",
    "NtGdiDrawStream",
    "NtUserInternalGetWindowText",
    "NtUserGetWindowDC",
    "NtGdiDvpGetVideoPortBandwidth",
    "NtGdiInvertRgn",
    "NtGdiGetRgnBox",
    "NtGdiGetAndSetDCDword",
    "NtGdiMaskBlt",
    "NtGdiGetWidthTable",
    "NtUserScrollDC",
    "NtUserGetObjectInformation",
    "NtGdiCreateBitmap",
    "NtUserFindWindowEx",
    "NtGdiPolyPatBlt",
    "NtUserUnhookWindowsHookEx",
    "NtGdiGetNearestColor",
    "NtGdiTransformPoints",
    "NtGdiGetDCPoint",
    "NtGdiCreateDIBBrush",
    "NtGdiGetTextMetricsW",
    "NtUserCreateWindowEx",
    "NtUserSetParent",
    "NtUserGetKeyboardState",
    "NtUserToUnicodeEx",
    "NtUserGetControlBrush",
    "NtUserGetClassName",
    "NtGdiAlphaBlend",
    "NtGdiDdCreateMoComp",
    "NtGdiOffsetRgn",
    "NtUserDefSetText",
    "NtGdiGetTextFaceW",
    "NtGdiStretchDIBitsInternal",
    "NtUserSendInput",
    "NtUserGetThreadDesktop",
    "NtGdiCreateRectRgn",
    "NtGdiGetDIBitsInternal",
    "NtUserGetUpdateRgn",
    "NtGdiDeleteClientObj",
    "NtUserGetIconSize",
    "NtUserFillWindow",
    "NtGdiExtCreateRegion",
    "NtGdiComputeXformCoefficients",
    "NtUserSetWindowsHookEx",
    "NtUserNotifyProcessCreate",
    "NtGdiUnrealizeObject",
    "NtUserGetTitleBarInfo",
    "NtGdiRectangle",
    "NtUserSetThreadDesktop",
    "NtUserGetDCEx",
    "NtUserGetScrollBarInfo",
    "NtGdiGetTextExtent",
    "NtUserSetWindowFNID",
    "NtGdiSetLayout",
    "NtUserCalcMenuBar",
    "NtUserThunkedMenuItemInfo",
    "NtGdiExcludeClipRect",
    "NtGdiCreateDIBSection",
    "NtGdiGetDCforBitmap",
    "NtUserDestroyCursor",
    "NtUserDestroyWindow",
    "NtUserCallHwndParam",
    "NtGdiCreateDIBitmapInternal",
    "NtUserOpenWindowStation",
    "NtGdiDdUpdateOverlay",
    "NtGdiDdGetInternalMoCompInfo",
    "NtGdiDdGetMoCompBuffInfo",
    "NtUserSetCursorIconData",
    "NtGdiDvpCreateVideoPort",
    "NtUserCloseDesktop",
    "NtUserOpenDesktop",
    "NtUserSetProcessWindowStation",
    "NtUserGetAtomName",
    "NtGdiDvpAcquireNotification",
    "NtGdiExtCreatePen",
    "NtGdiCreatePaletteInternal",
    "NtGdiSetBrushOrg",
    "NtUserBuildNameList",
    "NtGdiSetPixel",
    "NtUserRegisterClassExWOW",
    "NtGdiCreatePatternBrushInternal",
    "NtUserGetAncestor",
    "NtGdiGetOutlineTextMetricsInternalW",
    "NtGdiSetBitmapBits",
    "NtUserCloseWindowStation",
    "NtUserGetDoubleClickTime",
    "NtUserEnableScrollBar",
    "NtGdiCreateSolidBrush",
    "NtUserGetClassInfoEx",
    "NtGdiCreateClientObj",
    "NtUserUnregisterClass",
    "NtUserDeleteMenu",
    "NtGdiRectInRegion",
    "NtUserScrollWindowEx",
    "NtGdiGetPixel",
    "NtUserSetClassLong",
    "NtUserGetMenuBarInfo",
    "NtGdiDdUnlockD3D",
    "NtGdiDdGetScanLine",
    "NtGdiGetNearestPaletteIndex",
    "NtGdiDdCreateD3DBuffer",
    "NtGdiDdResetVisrgn",
    "NtGdiGetCharWidthW",
    "NtUserInvalidateRgn",
    "NtUserGetClipboardOwner",
    "NtUserSetWindowRgn",
    "NtUserBitBltSysBmp",
    "NtGdiGetCharWidthInfo",
    "NtUserValidateRect",
    "NtUserCloseClipboard",
    "NtUserOpenClipboard",
    "NtGdiGetStockObject",
    "NtUserSetClipboardData",
    "NtUserEnableMenuItem",
    "NtUserAlterWindowStyle",
    "NtGdiFillRgn",
    "NtUserGetWindowPlacement",
    "NtGdiModifyWorldTransform",
    "NtGdiGetFontData",
    "NtUserGetOpenClipboardWindow",
    "NtUserSetThreadState",
    "NtGdiOpenDCW",
    "NtUserTrackMouseEvent",
    "NtGdiGetTransform",
    "NtUserDestroyMenu",
    "NtGdiGetBitmapBits",
    "NtUserConsoleControl",
    "NtUserSetActiveWindow",
    "NtUserSetInformationThread",
    "NtUserSetWindowPlacement",
    "NtUserGetControlColor",
    "NtGdiSetMetaRgn",
    "NtGdiSetMiterLimit",
    "NtGdiSetVirtualResolution",
    "NtGdiGetRasterizerCaps",
    "NtUserSetWindowWord",
    "NtUserGetClipboardFormatName",
    "NtUserRealInternalGetMessage",
    "NtUserCreateLocalMemHandle",
    "NtUserAttachThreadInput",
    "NtGdiCreateHalftonePalette",
    "NtUserPaintMenuBar",
    "NtUserSetKeyboardState",
    "NtGdiCombineTransform",
    "NtUserCreateAcceleratorTable",
    "NtUserGetCursorFrameInfo",
    "NtUserGetAltTabInfo",
    "NtUserGetCaretBlinkTime",
    "NtGdiQueryFontAssocInfo",
    "NtUserProcessConnect",
    "NtUserEnumDisplayDevices",
    "NtUserEmptyClipboard",
    "NtUserGetClipboardData",
    "NtUserRemoveMenu",
    "NtGdiSetBoundsRect",
    "NtGdiGetBitmapDimension",
    "NtUserConvertMemHandle",
    "NtUserDestroyAcceleratorTable",
    "NtUserGetGUIThreadInfo",
    "NtGdiCloseFigure",
    "NtUserSetWindowsHookAW",
    "NtUserSetMenuDefaultItem",
    "NtUserCheckMenuItem",
    "NtUserSetWinEventHook",
    "NtUserUnhookWinEvent",
    "NtUserLockWindowUpdate",
    "NtUserSetSystemMenu",
    "NtUserThunkedMenuInfo",
    "NtGdiBeginPath",
    "NtGdiEndPath",
    "NtGdiFillPath",
    "NtUserCallHwnd",
    "NtUserDdeInitialize",
    "NtUserModifyUserStartupInfoFlags",
    "NtUserCountClipboardFormats",
    "NtGdiAddFontMemResourceEx",
    "NtGdiEqualRgn",
    "NtGdiGetSystemPaletteUse",
    "NtGdiRemoveFontMemResourceEx",
    "NtUserEnumDisplaySettings",
    "NtUserPaintDesktop",
    "NtGdiExtEscape",
    "NtGdiSetBitmapDimension",
    "NtGdiSetFontEnumeration",
    "NtUserChangeClipboardChain",
    "NtUserSetClipboardViewer",
    "NtUserShowWindowAsync",
    "NtGdiCreateColorSpace",
    "NtGdiDeleteColorSpace",
    "NtUserActivateKeyboardLayout",
    "NtBindCompositionSurface",
    "NtCompositionInputThread",
    "NtCreateCompositionInputSink",
    "NtCreateCompositionSurfaceHandle",
    "NtDCompositionAddCrossDeviceVisualChild",
    "NtDCompositionAddVisualChild",
    "NtDCompositionBeginFrame",
    "NtDCompositionCommitChannel",
    "NtDCompositionConfirmFrame",
    "NtDCompositionGetChannels",
    "NtDCompositionCreateAndBindSharedSection",
    "NtDCompositionCreateChannel",
    "NtDCompositionCreateConnection",
    "NtDCompositionCreateDwmChannel",
    "NtDCompositionCreateResource",
    "NtDCompositionCurrentBatchId",
    "NtDCompositionDestroyChannel",
    "NtDCompositionDestroyConnection",
    "NtDCompositionDiscardFrame",
    "NtDCompositionDuplicateHandleToProcess",
    "NtDCompositionDwmSyncFlush",
    "NtDCompositionConnectPipe",
    "NtDCompositionGetConnectionBatch",
    "NtDCompositionGetDeletedResources",
    "NtDCompositionGetFrameLegacyTokens",
    "NtDCompositionGetFrameStatistics",
    "NtDCompositionGetFrameSurfaceUpdates",
    "NtDCompositionOpenSharedResource",
    "NtDCompositionOpenSharedResourceHandle",
    "NtDCompositionReferenceSharedResourceOnDwmChannel",
    "NtDCompositionRegisterThumbnailVisual",
    "NtDCompositionReleaseAllResources",
    "NtDCompositionReleaseResource",
    "NtDCompositionRemoveCrossDeviceVisualChild",
    "NtDCompositionRemoveVisualChild",
    "NtDCompositionReplaceVisualChildren",
    "NtDCompositionRetireFrame",
    "NtDCompositionSetChannelCommitCompletionEvent",
    "NtDCompositionSetDebugCounter",
    "NtDCompositionSetResourceAnimationProperty",
    "NtDCompositionSetResourceBufferProperty",
    "NtDCompositionSetResourceDeletedNotificationTag",
    "NtDCompositionSetResourceFloatProperty",
    "NtDCompositionSetResourceHandleProperty",
    "NtDCompositionSetResourceIntegerProperty",
    "NtDCompositionSetResourceReferenceArrayProperty",
    "NtDCompositionSetResourceReferenceProperty",
    "NtDCompositionSignalGpuFence",
    "NtDCompositionSubmitDWMBatch",
    "NtDCompositionSynchronize",
    "NtDCompositionTelemetryAnimationScenarioBegin",
    "NtDCompositionTelemetryAnimationScenarioReference",
    "NtDCompositionTelemetryAnimationScenarioUnreference",
    "NtDCompositionTelemetrySetApplicationId",
    "NtDCompositionTelemetryTouchInteractionBegin",
    "NtDCompositionTelemetryTouchInteractionEnd",
    "NtDCompositionTelemetryTouchInteractionUpdate",
    "NtDCompositionWaitForChannel",
    "NtDuplicateCompositionInputSink",
    "NtGdiAbortDoc",
    "NtGdiAbortPath",
    "NtGdiAddEmbFontToDC",
    "NtGdiAddFontResourceW",
    "NtGdiAddRemoteFontToDC",
    "NtGdiAddRemoteMMInstanceToDC",
    "NtGdiAngleArc",
    "NtGdiAnyLinkedFonts",
    "NtGdiArcInternal",
    "NtGdiBRUSHOBJ_DeleteRbrush",
    "NtGdiBRUSHOBJ_hGetColorTransform",
    "NtGdiBRUSHOBJ_pvAllocRbrush",
    "NtGdiBRUSHOBJ_pvGetRbrush",
    "NtGdiBRUSHOBJ_ulGetBrushColor",
    "NtGdiBeginGdiRendering",
    "NtGdiCLIPOBJ_bEnum",
    "NtGdiCLIPOBJ_cEnumStart",
    "NtGdiCLIPOBJ_ppoGetPath",
    "NtGdiCancelDC",
    "NtGdiChangeGhostFont",
    "NtGdiCheckBitmapBits",
    "NtGdiClearBitmapAttributes",
    "NtGdiUnloadPrinterDriver",
    "NtGdiColorCorrectPalette",
    "NtGdiConfigureOPMProtectedOutput",
    "NtGdiConvertMetafileRect",
    "NtGdiCreateBitmapFromDxSurface",
    "NtGdiCreateBitmapFromDxSurface2",
    "NtGdiCreateColorTransform",
    "NtGdiCreateEllipticRgn",
    "NtGdiCreateHatchBrushInternal",
    "NtGdiCreateMetafileDC",
    "NtGdiCreateOPMProtectedOutputs",
    "NtGdiCreateRoundRectRgn",
    "NtGdiCreateServerMetaFile",
    "NtGdiCreateSessionMappedDIBSection",
    "NtGdiDdDeleteDirectDrawObject",
    "NtGdiDvpUpdateVideoPort",
    "NtGdiDdUnlock",
    "NtGdiDdCanCreateSurface",
    "NtGdiDDCCIGetCapabilitiesString",
    "NtGdiDDCCIGetCapabilitiesStringLength",
    "NtGdiDDCCIGetTimingReport",
    "NtGdiDDCCIGetVCPFeature",
    "NtGdiDDCCISaveCurrentSettings",
    "NtGdiDDCCISetVCPFeature",
    "NtGdiDvpGetVideoPortOutputFormats",
    "NtGdiDdGetFlipStatus",
    "NtGdiDvpGetVideoPortField",
    "NtGdiDdSetGammaRamp",
    "NtGdiD3dContextCreate",
    "NtGdiDdDestroySurface",
    "NtGdiDvpReleaseNotification",
    "NtGdiDdAlphaBlt",
    "NtGdiDdCreateFullscreenSprite",
    "NtGdiDdGetAvailDriverMemory",
    "NtGdiDdDDIAcquireKeyedMutex",
    "NtGdiDdDDIAcquireKeyedMutex2",
    "NtGdiDdDDICacheHybridQueryValue",
    "NtGdiDdDDICheckExclusiveOwnership",
    "NtGdiDdDDICheckMonitorPowerState",
    "NtGdiDdDDICheckMultiPlaneOverlaySupport",
    "NtGdiDdDDICheckOcclusion",
    "NtGdiDdDDICheckSharedResourceAccess",
    "NtGdiDdDDICheckVidPnExclusiveOwnership",
    "NtGdiDdDDICloseAdapter",
    "NtGdiDdDDIConfigureSharedResource",
    "NtGdiDdDDICreateAllocation",
    "NtGdiDdDDICreateContext",
    "NtGdiDdDDICreateDCFromMemory",
    "NtGdiDdDDICreateDevice",
    "NtGdiDdDDICreateKeyedMutex",
    "NtGdiDdDDICreateKeyedMutex2",
    "NtGdiDdDDICreateOutputDupl",
    "NtGdiDdDDICreateOverlay",
    "NtGdiDdDDICreateSynchronizationObject",
    "NtGdiDdDDIDestroyAllocation",
    "NtGdiDdDDIDestroyContext",
    "NtGdiDdDDIDestroyDCFromMemory",
    "NtGdiDdDDIDestroyDevice",
    "NtGdiDdDDIDestroyKeyedMutex",
    "NtGdiDdDDIDestroyOutputDupl",
    "NtGdiDdDDIDestroyOverlay",
    "NtGdiDdDDIDestroySynchronizationObject",
    "NtGdiDdDDIEnumAdapters",
    "NtGdiDdDDIEscape",
    "NtGdiDdDDIFlipOverlay",
    "NtGdiDdDDIGetCachedHybridQueryValue",
    "NtGdiDdDDIGetContextInProcessSchedulingPriority",
    "NtGdiDdDDIGetContextSchedulingPriority",
    "NtGdiDdDDIGetDeviceState",
    "NtGdiDdDDIGetDisplayModeList",
    "NtGdiDdDDIGetMultisampleMethodList",
    "NtGdiDdDDIGetOverlayState",
    "NtGdiDdDDIGetPresentHistory",
    "NtGdiDdDDIGetPresentQueueEvent",
    "NtGdiDdDDIGetProcessSchedulingPriorityClass",
    "NtGdiDdDDIGetRuntimeData",
    "NtGdiDdDDIGetScanLine",
    "NtGdiDdDDIGetSharedPrimaryHandle",
    "NtGdiDdDDIGetSharedResourceAdapterLuid",
    "NtGdiDdDDIInvalidateActiveVidPn",
    "NtGdiDdDDILock",
    "NtGdiDdDDINetDispGetNextChunkInfo",
    "NtGdiDdDDINetDispQueryMiracastDisplayDeviceStatus",
    "NtGdiDdDDINetDispQueryMiracastDisplayDeviceSupport",
    "NtGdiDdDDINetDispStartMiracastDisplayDevice",
    "NtGdiDdDDINetDispStopMiracastDisplayDevice",
    "NtGdiDdDDIOfferAllocations",
    "NtGdiDdDDIOpenAdapterFromDeviceName",
    "NtGdiDdDDIOpenAdapterFromHdc",
    "NtGdiDdDDIOpenAdapterFromLuid",
    "NtGdiDdDDIOpenKeyedMutex",
    "NtGdiDdDDIOpenKeyedMutex2",
    "NtGdiDdDDIOpenNtHandleFromName",
    "NtGdiDdDDIOpenResource",
    "NtGdiDdDDIOpenResourceFromNtHandle",
    "NtGdiDdDDIOpenSyncObjectFromNtHandle",
    "NtGdiDdDDIOpenSynchronizationObject",
    "NtGdiDdDDIOutputDuplGetFrameInfo",
    "NtGdiDdDDIOutputDuplGetMetaData",
    "NtGdiDdDDIOutputDuplGetPointerShapeData",
    "NtGdiDdDDIOutputDuplPresent",
    "NtGdiDdDDIOutputDuplReleaseFrame",
    "NtGdiDdDDIPinDirectFlipResources",
    "NtGdiDdDDIPollDisplayChildren",
    "NtGdiDdDDIPresent",
    "NtGdiDdDDIPresentMultiPlaneOverlay",
    "NtGdiDdDDIQueryAdapterInfo",
    "NtGdiDdDDIQueryAllocationResidency",
    "NtGdiDdDDIQueryRemoteVidPnSourceFromGdiDisplayName",
    "NtGdiDdDDIQueryResourceInfo",
    "NtGdiDdDDIQueryResourceInfoFromNtHandle",
    "NtGdiDdDDIQueryStatistics",
    "NtGdiDdDDIReclaimAllocations",
    "NtGdiDdDDIReleaseKeyedMutex",
    "NtGdiDdDDIReleaseKeyedMutex2",
    "NtGdiDdDDIReleaseProcessVidPnSourceOwners",
    "NtGdiDdDDIRender",
    "NtGdiDdDDISetAllocationPriority",
    "NtGdiDdDDISetContextInProcessSchedulingPriority",
    "NtGdiDdDDISetContextSchedulingPriority",
    "NtGdiDdDDISetDisplayMode",
    "NtGdiDdDDISetDisplayPrivateDriverFormat",
    "NtGdiDdDDISetGammaRamp",
    "NtGdiDdDDISetProcessSchedulingPriorityClass",
    "NtGdiDdDDISetQueuedLimit",
    "NtGdiDdDDISetStereoEnabled",
    "NtGdiDdDDISetVidPnSourceOwner",
    "NtGdiDdDDISetVidPnSourceOwner1",
    "NtGdiDdDDIShareObjects",
    "NtGdiDdDDISharedPrimaryLockNotification",
    "NtGdiDdDDISharedPrimaryUnLockNotification",
    "NtGdiDdDDISignalSynchronizationObject",
    "NtGdiDdDDIUnlock",
    "NtGdiDdDDIUnpinDirectFlipResources",
    "NtGdiDdDDIUpdateOverlay",
    "NtGdiDdDDIWaitForIdle",
    "NtGdiDdDDIWaitForSynchronizationObject",
    "NtGdiDdDDIWaitForVerticalBlankEvent",
    "NtGdiDdDDIWaitForVerticalBlankEvent2",
    "NtGdiDvpCanCreateVideoPort",
    "NtGdiDdCreateSurfaceEx",
    "NtGdiDdDestroyFullscreenSprite",
    "NtGdiDdSetExclusiveMode",
    "NtGdiDdEndMoCompFrame",
    "NtGdiDdLockD3D",
    "NtGdiDdBlt",
    "NtGdiDdDestroyD3DBuffer",
    "NtGdiD3dValidateTextureStageState",
    "NtGdiDdDestroyMoComp",
    "NtGdiDvpGetVideoPortFlipStatus",
    "NtGdiDdSetColorKey",
    "NtGdiDvpGetVideoPortConnectInfo",
    "NtGdiDdWaitForVerticalBlank",
    "NtGdiDdCreateSurfaceObject",
    "NtGdiDdReenableDirectDrawObject",
    "NtGdiDvpGetVideoSignalStatus",
    "NtGdiDvpFlipVideoPort",
    "NtGdiD3dContextDestroy",
    "NtGdiDvpColorControl",
    "NtGdiDdNotifyFullscreenSpriteUpdate",
    "NtGdiDdGetDC",
    "NtGdiDdDeleteSurfaceObject",
    "NtGdiDdQueryVisRgnUniqueness",
    "NtGdiDdReleaseDC",
    "NtGdiDdColorControl",
    "NtGdiDvpDestroyVideoPort",
    "NtGdiDdAttachSurface",
    "NtGdiDdGetDxHandle",
    "NtGdiDdQueryDirectDrawObject",
    "NtGdiDdSetOverlayPosition",
    "NtGdiDdUnattachSurface",
    "NtGdiDdGetBltStatus",
    "NtGdiDdRenderMoComp",
    "NtGdiDdGetMoCompGuids",
    "NtGdiDeleteColorTransform",
    "NtGdiDescribePixelFormat",
    "NtGdiDestroyOPMProtectedOutput",
    "UnknownSyscall",
    "NtGdiDoBanding",
    "NtGdiDrawEscape",
    "NtGdiDdCanCreateD3DBuffer",
    "NtGdiDvpWaitForVideoPortSync",
    "NtGdiD3dContextDestroyAll",
    "NtGdiDdGetDriverInfo",
    "NtGdiDdQueryMoCompStatus",
    "NtGdiDvpGetVideoPortLine",
    "NtGdiDvpGetVideoPortInputFormats",
    "NtGdiDdGetDriverState",
    "NtGdiDdCreateSurface",
    "NtGdiD3dDrawPrimitives2",
    "NtGdiDdFlipToGDISurface",
    "NtGdiDdBeginMoCompFrame",
    "NtGdiDdCreateDirectDrawObject",
    "NtGdiDdAddAttachedSurface",
    "NtGdiDdGetMoCompFormats",
    "NtGdiDdLock",
    "NtGdiDdFlip",
    "NtGdiDwmCreatedBitmapRemotingOutput",
    "NtGdiDxgGenericThunk",
    "NtGdiEllipse",
    "NtGdiEnableEudc",
    "NtGdiEndDoc",
    "NtGdiEndGdiRendering",
    "NtGdiEndPage",
    "NtGdiEngAlphaBlend",
    "NtGdiEngAssociateSurface",
    "NtGdiEngBitBlt",
    "NtGdiEngCheckAbort",
    "NtGdiEngComputeGlyphSet",
    "NtGdiEngCopyBits",
    "NtGdiEngCreateBitmap",
    "NtGdiEngCreateClip",
    "NtGdiEngCreateDeviceBitmap",
    "NtGdiEngCreateDeviceSurface",
    "NtGdiEngCreatePalette",
    "NtGdiEngDeleteClip",
    "NtGdiEngDeletePalette",
    "NtGdiEngDeletePath",
    "NtGdiEngDeleteSurface",
    "NtGdiEngEraseSurface",
    "NtGdiEngFillPath",
    "NtGdiEngGradientFill",
    "NtGdiEngLineTo",
    "NtGdiEngLockSurface",
    "NtGdiEngMarkBandingSurface",
    "NtGdiEngPaint",
    "NtGdiEngPlgBlt",
    "NtGdiEngStretchBlt",
    "NtGdiEngStretchBltROP",
    "NtGdiEngStrokeAndFillPath",
    "NtGdiEngStrokePath",
    "NtGdiEngTextOut",
    "NtGdiEngTransparentBlt",
    "NtGdiEngUnlockSurface",
    "NtGdiEnumFonts",
    "NtGdiEnumObjects",
    "NtGdiEudcLoadUnloadLink",
    "NtGdiExtFloodFill",
    "NtGdiFONTOBJ_cGetAllGlyphHandles",
    "NtGdiFONTOBJ_cGetGlyphs",
    "NtGdiFONTOBJ_pQueryGlyphAttrs",
    "NtGdiFONTOBJ_pfdg",
    "NtGdiFONTOBJ_pifi",
    "NtGdiFONTOBJ_pvTrueTypeFontFile",
    "NtGdiFONTOBJ_pxoGetXform",
    "NtGdiFONTOBJ_vGetInfo",
    "NtGdiFlattenPath",
    "NtGdiFontIsLinked",
    "NtGdiForceUFIMapping",
    "NtGdiFrameRgn",
    "NtGdiFullscreenControl",
    "NtGdiGetBoundsRect",
    "NtGdiGetCOPPCompatibleOPMInformation",
    "NtGdiGetCertificate",
    "NtGdiGetCertificateSize",
    "NtGdiGetCharABCWidthsW",
    "NtGdiGetCharacterPlacementW",
    "NtGdiGetColorAdjustment",
    "NtGdiGetColorSpaceforBitmap",
    "NtGdiGetCurrentDpiInfo",
    "NtGdiGetDeviceCaps",
    "NtGdiGetDeviceCapsAll",
    "NtGdiGetDeviceGammaRamp",
    "NtGdiGetDeviceWidth",
    "NtGdiGetDhpdev",
    "NtGdiGetETM",
    "NtGdiGetEmbUFI",
    "NtGdiGetEmbedFonts",
    "NtGdiGetEudcTimeStampEx",
    "NtGdiGetFontFileData",
    "NtGdiGetFontFileInfo",
    "NtGdiGetFontResourceInfoInternalW",
    "NtGdiGetFontUnicodeRanges",
    "NtGdiGetGlyphIndicesW",
    "NtGdiGetGlyphIndicesWInternal",
    "NtGdiGetGlyphOutline",
    "NtGdiGetKerningPairs",
    "NtGdiGetLinkedUFIs",
    "NtGdiGetMiterLimit",
    "NtGdiGetMonitorID",
    "NtGdiGetNumberOfPhysicalMonitors",
    "NtGdiGetOPMInformation",
    "NtGdiGetOPMRandomNumber",
    "NtGdiGetObjectBitmapHandle",
    "NtGdiGetPath",
    "NtGdiGetPerBandInfo",
    "NtGdiGetPhysicalMonitorDescription",
    "NtGdiGetPhysicalMonitors",
    "NtGdiGetRealizationInfo",
    "NtGdiGetServerMetaFileBits",
    "NtGdiSetBrushAttributes",
    "NtGdiGetStats",
    "NtGdiGetStringBitmapW",
    "NtGdiGetSuggestedOPMProtectedOutputArraySize",
    "NtGdiGetTextExtentExW",
    "NtGdiGetUFI",
    "NtGdiGetUFIPathname",
    "NtGdiGradientFill",
    "NtGdiHLSurfGetInformation",
    "NtGdiHLSurfSetInformation",
    "NtGdiHT_Get8BPPFormatPalette",
    "NtGdiHT_Get8BPPMaskPalette",
    "NtGdiIcmBrushInfo",
    "NtGdiUnmapMemFont",
    "NtGdiInitSpool",
    "NtGdiMakeFontDir",
    "NtGdiMakeInfoDC",
    "NtGdiMakeObjectUnXferable",
    "NtGdiMakeObjectXferable",
    "NtGdiMirrorWindowOrg",
    "NtGdiMonoBitmap",
    "NtGdiMoveTo",
    "NtGdiOffsetClipRgn",
    "NtGdiPATHOBJ_bEnum",
    "NtGdiPATHOBJ_bEnumClipLines",
    "NtGdiPATHOBJ_vEnumStart",
    "NtGdiPATHOBJ_vEnumStartClipLines",
    "NtGdiPATHOBJ_vGetBounds",
    "NtGdiPathToRegion",
    "NtGdiPlgBlt",
    "NtGdiPolyDraw",
    "NtGdiPolyTextOutW",
    "NtGdiPtInRegion",
    "NtGdiPtVisible",
    "NtGdiQueryFonts",
    "NtGdiRemoveFontResourceW",
    "NtGdiRemoveMergeFont",
    "NtGdiResetDC",
    "NtGdiResizePalette",
    "NtGdiRoundRect",
    "NtGdiSTROBJ_bEnum",
    "NtGdiSTROBJ_bEnumPositionsOnly",
    "NtGdiSTROBJ_bGetAdvanceWidths",
    "NtGdiSTROBJ_dwGetCodePage",
    "NtGdiSTROBJ_vEnumStart",
    "NtGdiScaleViewportExtEx",
    "NtGdiScaleWindowExtEx",
    "NtGdiSelectBrush",
    "NtGdiSelectClipPath",
    "NtGdiSelectPen",
    "NtGdiSetBitmapAttributes",
    "NtGdiGetSpoolMessage",
    "NtGdiSetColorAdjustment",
    "NtGdiSetColorSpace",
    "NtGdiSetDeviceGammaRamp",
    "NtGdiSetFontXform",
    "NtGdiSetIcmMode",
    "NtGdiSetLinkedUFIs",
    "NtGdiSetMagicColors",
    "NtGdiSetOPMSigningKeyAndSequenceNumbers",
    "NtGdiSetPUMPDOBJ",
    "NtGdiSetPixelFormat",
    "NtGdiSetRectRgn",
    "NtGdiSetSizeDevice",
    "NtGdiSetSystemPaletteUse",
    "NtGdiSetTextJustification",
    "NtGdiSetUMPDSandboxState",
    "NtGdiStartDoc",
    "NtGdiStartPage",
    "NtGdiStrokeAndFillPath",
    "NtGdiStrokePath",
    "NtGdiSwapBuffers",
    "NtGdiTransparentBlt",
    "NtGdiUMPDEngFreeUserMem",
    "NtGdiClearBrushAttributes",
    "NtUserUpdateWindowTransform",
    "NtGdiUpdateColors",
    "NtGdiUpdateTransform",
    "NtGdiWidenPath",
    "NtGdiXFORMOBJ_bApplyXform",
    "NtGdiXFORMOBJ_iGetXform",
    "NtGdiXLATEOBJ_cGetPalette",
    "NtGdiXLATEOBJ_hGetColorTransform",
    "NtGdiXLATEOBJ_iXlate",
    "NtNotifyPresentToCompositionSurface",
    "NtOpenCompositionSurfaceDirtyRegion",
    "NtOpenCompositionSurfaceSectionInfo",
    "NtOpenCompositionSurfaceSwapChainHandleInfo",
    "NtQueryCompositionInputSink",
    "NtQueryCompositionInputSinkLuid",
    "NtQueryCompositionSurfaceBinding",
    "NtQueryCompositionSurfaceRenderingRealization",
    "NtQueryCompositionSurfaceStatistics",
    "NtSetCompositionSurfaceBufferCompositionMode",
    "NtSetCompositionSurfaceIndependentFlipInfo",
    "NtSetCompositionSurfaceOutOfFrameDirectFlipNotification",
    "NtSetCompositionSurfaceStatistics",
    "NtTokenManagerCreateCompositionTokenHandle",
    "NtTokenManagerDeleteOutstandingDirectFlipTokens",
    "NtTokenManagerGetOutOfFrameDirectFlipSurfaceUpdates",
    "NtTokenManagerOpenEvent",
    "NtTokenManagerOpenSection",
    "NtTokenManagerThread",
    "NtUnBindCompositionSurface",
    "NtUpdateInputSinkTransforms",
    "NtUserAcquireIAMKey",
    "NtUserAddClipboardFormatListener",
    "NtUserAssociateInputContext",
    "NtUserAutoPromoteMouseInPointer",
    "NtUserAutoRotateScreen",
    "NtUserBlockInput",
    "NtUserBuildHimcList",
    "NtUserBuildPropList",
    "NtUserCalculatePopupWindowPosition",
    "NtUserCallHwndOpt",
    "NtUserCanBrokerForceForeground",
    "NtUserChangeDisplaySettings",
    "NtUserChangeWindowMessageFilterEx",
    "NtUserCheckAccessForIntegrityLevel",
    "NtUserCheckProcessForClipboardAccess",
    "NtUserCheckProcessSession",
    "NtUserCheckWindowThreadDesktop",
    "NtUserChildWindowFromPointEx",
    "NtUserClearForeground",
    "NtUserClipCursor",
    "NtUserCompositionInputSinkLuidFromPoint",
    "NtUserCreateDCompositionHwndTarget",
    "NtUserCreateDesktopEx",
    "NtUserCreateInputContext",
    "NtUserCreateWindowStation",
    "NtUserCtxDisplayIOCtl",
    "NtUserDeferWindowPosAndBand",
    "NtUserDelegateCapturePointers",
    "NtUserDelegateInput",
    "NtUserDestroyDCompositionHwndTarget",
    "NtUserDestroyInputContext",
    "NtUserDisableImmersiveOwner",
    "NtUserDisableProcessWindowFiltering",
    "NtUserDisableThreadIme",
    "NtUserDiscardPointerFrameMessages",
    "NtUserDisplayConfigGetDeviceInfo",
    "NtUserDisplayConfigSetDeviceInfo",
    "NtUserDoSoundConnect",
    "NtUserDoSoundDisconnect",
    "NtUserDragDetect",
    "NtUserDragObject",
    "NtUserDrawAnimatedRects",
    "NtUserDrawCaption",
    "NtUserDrawCaptionTemp",
    "NtUserDrawMenuBarTemp",
    "NtUserDwmGetRemoteSessionOcclusionEvent",
    "NtUserDwmGetRemoteSessionOcclusionState",
    "NtUserDwmStartRedirection",
    "NtUserDwmStopRedirection",
    "NtUserDwmValidateWindow",
    "NtUserEnableIAMAccess",
    "NtUserEnableMouseInPointer",
    "NtUserEnableMouseInputForCursorSuppression",
    "NtUserEnableTouchPad",
    "NtUserEndMenu",
    "NtUserEvent",
    "NtUserFlashWindowEx",
    "NtUserFrostCrashedWindow",
    "NtUserGetAppImeLevel",
    "NtUserGetAutoRotationState",
    "NtUserGetCIMSSM",
    "NtUserGetCaretPos",
    "NtUserGetClipCursor",
    "NtUserGetClipboardAccessToken",
    "NtUserGetClipboardViewer",
    "NtUserGetComboBoxInfo",
    "NtUserGetCurrentInputMessageSource",
    "NtUserGetCursorDims",
    "NtUserGetCursorInfo",
    "NtUserGetDesktopID",
    "NtUserGetDisplayAutoRotationPreferences",
    "NtUserGetDisplayAutoRotationPreferencesByProcessId",
    "NtUserGetDisplayConfigBufferSizes",
    "NtUserGetDpiForMonitor",
    "NtUserGetGestureConfig",
    "NtUserGetGestureExtArgs",
    "NtUserGetGestureInfo",
    "NtUserGetGuiResources",
    "NtUserGetHimetricScaleFactorFromPixelLocation",
    "NtUserGetImeHotKey",
    "NtUserGetImeInfoEx",
    "NtUserGetInputLocaleInfo",
    "NtUserGetInternalWindowPos",
    "NtUserGetKeyNameText",
    "NtUserGetKeyboardLayoutName",
    "NtUserGetLayeredWindowAttributes",
    "NtUserGetListBoxInfo",
    "NtUserGetMenuIndex",
    "NtUserGetMenuItemRect",
    "NtUserGetMouseMovePointsEx",
    "NtUserGetOwnerTransformedMonitorRect",
    "NtUserGetPhysicalDeviceRect",
    "NtUserGetPointerCursorId",
    "NtUserGetPointerDevice",
    "NtUserGetPointerDeviceCursors",
    "NtUserGetPointerDeviceProperties",
    "NtUserGetPointerDeviceRects",
    "NtUserGetPointerDevices",
    "NtUserGetPointerInfoList",
    "NtUserGetPointerInputTransform",
    "NtUserGetPointerType",
    "NtUserGetPrecisionTouchPadConfiguration",
    "NtUserGetPriorityClipboardFormat",
    "NtUserGetProcessDpiAwareness",
    "NtUserGetProcessUIContextInformation",
    "NtUserGetQueueEventStatus",
    "NtUserGetRawInputBuffer",
    "NtUserGetRawInputData",
    "NtUserGetRawInputDeviceInfo",
    "NtUserGetRawInputDeviceList",
    "NtUserGetRawPointerDeviceData",
    "NtUserGetRegisteredRawInputDevices",
    "NtUserGetTopLevelWindow",
    "NtUserGetTouchInputInfo",
    "NtUserGetTouchValidationStatus",
    "NtUserGetUpdatedClipboardFormats",
    "NtUserGetWOWClass",
    "NtUserGetWindowBand",
    "NtUserGetWindowCompositionAttribute",
    "NtUserGetWindowCompositionInfo",
    "NtUserGetWindowDisplayAffinity",
    "NtUserGetWindowFeedbackSetting",
    "NtUserGetWindowMinimizeRect",
    "NtUserGetWindowRgnEx",
    "NtUserGhostWindowFromHungWindow",
    "NtUserHandleDelegatedInput",
    "NtUserHardErrorControl",
    "NtUserHidePointerContactVisualization",
    "NtUserHiliteMenuItem",
    "NtUserHungWindowFromGhostWindow",
    "NtUserHwndQueryRedirectionInfo",
    "NtUserHwndSetRedirectionInfo",
    "NtUserImpersonateDdeClientWindow",
    "NtUserInitTask",
    "NtUserInitialize",
    "NtUserInitializeClientPfnArrays",
    "NtUserInitializeTouchInjection",
    "NtUserInjectGesture",
    "NtUserInjectTouchInput",
    "NtUserInternalClipCursor",
    "NtUserInternalGetWindowIcon",
    "NtUserIsMouseInPointerEnabled",
    "NtUserIsMouseInputEnabled",
    "NtUserIsTopLevelWindow",
    "NtUserIsTouchWindow",
    "NtUserLayoutCompleted",
    "NtUserLinkDpiCursor",
    "NtUserLoadKeyboardLayoutEx",
    "NtUserLockWindowStation",
    "NtUserLockWorkStation",
    "NtUserLogicalToPerMonitorDPIPhysicalPoint",
    "NtUserLogicalToPhysicalPoint",
    "NtUserMNDragLeave",
    "NtUserMNDragOver",
    "NtUserMagControl",
    "NtUserMagGetContextInformation",
    "NtUserMagSetContextInformation",
    "NtUserMenuItemFromPoint",
    "NtUserMinMaximize",
    "NtUserModifyWindowTouchCapability",
    "NtUserNotifyIMEStatus",
    "NtUserOpenInputDesktop",
    "NtUserOpenThreadDesktop",
    "NtUserPaintMonitor",
    "NtUserPerMonitorDPIPhysicalToLogicalPoint",
    "NtUserPhysicalToLogicalPoint",
    "NtUserPrintWindow",
    "NtUserPromoteMouseInPointer",
    "NtUserPromotePointer",
    "NtUserQueryBSDRWindow",
    "NtUserQueryDisplayConfig",
    "NtUserQueryInformationThread",
    "NtUserQueryInputContext",
    "NtUserQuerySendMessage",
    "NtUserRealChildWindowFromPoint",
    "NtUserRealWaitMessageEx",
    "NtUserRegisterBSDRWindow",
    "NtUserRegisterEdgy",
    "NtUserRegisterErrorReportingDialog",
    "NtUserRegisterHotKey",
    "NtUserRegisterPointerDeviceNotifications",
    "NtUserRegisterPointerInputTarget",
    "NtUserRegisterRawInputDevices",
    "NtUserRegisterServicesProcess",
    "NtUserRegisterSessionPort",
    "NtUserRegisterTasklist",
    "NtUserRegisterTouchHitTestingWindow",
    "NtUserRegisterTouchPadCapable",
    "NtUserRegisterUserApiHook",
    "NtUserRemoteConnect",
    "NtUserRemoteRedrawRectangle",
    "NtUserRemoteRedrawScreen",
    "NtUserRemoteStopScreenUpdates",
    "NtUserRemoveClipboardFormatListener",
    "NtUserReportInertia",
    "NtUserResolveDesktopForWOW",
    "NtUserSendEventMessage",
    "NtUserSetActivationFilter",
    "NtUserSetActiveProcess",
    "NtUserSetAppImeLevel",
    "NtUserSetAutoRotation",
    "NtUserSetBrokeredForeground",
    "NtUserSetCalibrationData",
    "NtUserSetChildWindowNoActivate",
    "NtUserSetClassWord",
    "NtUserSetCursorContents",
    "NtUserSetDisplayAutoRotationPreferences",
    "NtUserSetDisplayConfig",
    "NtUserSetDisplayMapping",
    "NtUserSetFallbackForeground",
    "NtUserSetGestureConfig",
    "NtUserSetImeHotKey",
    "NtUserSetImeInfoEx",
    "NtUserSetImeOwnerWindow",
    "NtUserSetImmersiveBackgroundWindow",
    "NtUserSetInternalWindowPos",
    "NtUserSetLayeredWindowAttributes",
    "NtUserSetMenu",
    "NtUserSetMenuContextHelpId",
    "NtUserSetMenuFlagRtoL",
    "NtUserSetMirrorRendering",
    "NtUserSetObjectInformation",
    "NtUserSetPrecisionTouchPadConfiguration",
    "NtUserSetProcessDpiAwareness",
    "NtUserSetProcessRestrictionExemption",
    "NtUserSetProcessUIAccessZorder",
    "NtUserSetShellWindowEx",
    "NtUserSetSysColors",
    "NtUserSetSystemCursor",
    "NtUserSetSystemTimer",
    "NtUserSetThreadInputBlocked",
    "NtUserSetThreadLayoutHandles",
    "NtUserSetWindowBand",
    "NtUserSetWindowCompositionAttribute",
    "NtUserSetWindowCompositionTransition",
    "NtUserSetWindowDisplayAffinity",
    "NtUserSetWindowFeedbackSetting",
    "NtUserSetWindowRgnEx",
    "NtUserSetWindowStationUser",
    "NtUserShowSystemCursor",
    "NtUserShutdownBlockReasonCreate",
    "NtUserShutdownBlockReasonQuery",
    "NtUserShutdownReasonDestroy",
    "NtUserSignalRedirectionStartComplete",
    "NtUserSlicerControl",
    "NtUserSoundSentry",
    "NtUserSwitchDesktop",
    "NtUserTestForInteractiveUser",
    "NtUserTrackPopupMenuEx",
    "NtUserTransformPoint",
    "NtUserTransformRect",
    "NtUserUndelegateInput",
    "NtUserUnloadKeyboardLayout",
    "NtUserUnlockWindowStation",
    "NtUserUnregisterHotKey",
    "NtUserUnregisterSessionPort",
    "NtUserUnregisterUserApiHook",
    "NtUserUpdateDefaultDesktopThumbnail",
    "NtUserUpdateInputContext",
    "NtUserUpdateInstance",
    "NtUserUpdateLayeredWindow",
    "NtUserUpdatePerUserSystemParameters",
    "NtUserUpdateWindowInputSinkHints",
    "NtGdiInit",
    "NtUserUserHandleGrantAccess",
    "NtUserValidateHandleSecure",
    "NtUserWaitAvailableMessageEx",
    "NtUserWaitForInputIdle",
    "NtUserWaitForMsgAndEvent",
    "NtUserWaitForRedirectionStartComplete",
    "NtUserWindowFromPoint",
    "NtValidateCompositionSurfaceHandle",
    "NtUserSetClassLongPtr",
    "NtUserSetWindowLongPtr"
};
