# Hong Kong Character Set Project (HKCS) 香港民間字集
Hong Kong Character Set Project (HKCS) 香港民間字集 is a project to create fonts cataloguing
modern and historical Chinese character glyphs in the Ming typeface.

# Current Fonts
- **HKCS Traditional Orthography (BMP-CanonicalOnly)**  
  香港民間字集 傳承字形版 (基本區-僅正字形)  
 	_File name: hkcs-traditional-bmp-canonicalonly.otf_
    
  A serif font that supports the traditional orthography according to the orthography outlined
  by @SyaoranHinata.  The traditional orthography choosen is the one which matches modern
  Oracle Bone, Bronze Inscriptions and Small Seal etymology study better.  
    
  **Character Coverage:**  
  This version of the font includes all characters in URO / URO+ and also select characters
  from Extension A/B for Cantonese support in Hong Kong.  Full Extension A support is being
  worked on.
  
  **Treatment of Character Variants:**  
  Characters and glyphs which are deemed to be duplicates, simplified forms,
  vulgar forms or error glyphs are visually aliased to their canonical forms.
  
# Upcoming Fonts
- **HKCS Traditional Orthography (BMP-Aliased)**  
  香港民間字集 傳承字形版 (基本區-多碼同形)  
 	_File name: hkcs-traditional-bmp-aliased.otf_
    
  This is the version of HKCS Traditional Orthography (BMP) where the duplicate, simplified
  vulgar and error forms are directly replaced with their canonical glyphs.

- **HKCS Hong Kong Song (BMP-CanonicalOnly)**  
  香港民間字集 香港宋 (基本區-僅正字形)  
 	_File name: hkcs-hong-kong-song-bmp-canonicalonly.otf_
    
  A Song typeface font where the glyphs are designed according to the Hong Kong orthography.
  In general, the orthography matches MSungHK and DFLiSong, which is the de-facto standard
  Song fonts used in Hong Kong.
  
- **HKCS Hong Kong Ming (BMP-CanonicalOnly)**  
  香港民間字集 香港明 (基本區-僅正字形)  
 	_File name: hkcs-hong-kong-ming-bmp-canonicalonly.otf_
    
  A Ming typeface font where the glyphs are designed according to the Hong Kong orthography
  with a more traditional design style.
  
# License
  This Font Software is licensed under the SIL Open Font License, Version 1.1.  
    
  (c) 2018 Hong Kong Character Set Project (Hanzi Portion)  
  (c) 2008-2018 GlyphWiki Project (Alphanumerics and Symbols)  

# Thanks
  The glyphs are created on GlyphWiki, an online platform for drawing glyphs and outputting
  fonts. Thanks to SyaoranHinata, Ext C, Zonz, Gienwen CHAU and others for their suppport
  to the orthography standardization, character etymology and review work.

# Changelog
  http://en.glyphwiki.org/wiki/Special:Recentchanges?user=hkcs
