defmodule Codebattle.Tournament.Score.TimeAndTestsTest do
  use Codebattle.DataCase

  import Codebattle.Tournament.Score.TimeAndTests

  @test_results [100.0, 80.0, 60.0, 40.0, 20.0, 10.0, 3.0]

  describe "get_score/3" do
    test "elementary level" do
      level = "elementary"
      durations = [1.0, 10.0, 20.0, 60.0, 2 * 60.0, 3 * 60.0, 4 * 60.0, 5 * 60.0, 6 * 60.0]

      assert [
               [30, 24, 18, 12, 6, 3, 1],
               [30, 24, 18, 12, 6, 3, 1],
               [29, 23, 17, 12, 6, 3, 1],
               [25, 20, 15, 10, 5, 2, 1],
               [19, 15, 11, 7, 4, 2, 1],
               [13, 10, 8, 5, 3, 1, 0],
               [6, 5, 4, 3, 1, 1, 0],
               [0, 0, 0, 0, 0, 0, 0],
               [0, 0, 0, 0, 0, 0, 0]
             ] =
               Enum.map(durations, fn d ->
                 Enum.map(
                   @test_results,
                   fn tests -> get_score(level, tests, d) end
                 )
               end)
    end

    test "easy level" do
      level = "easy"

      durations = [
        1.0,
        20.0,
        60.0,
        2 * 60.0,
        3 * 60.0,
        4 * 60.0,
        5 * 60.0,
        6 * 60.0,
        7 * 60.0,
        8 * 60.0,
        9 * 60.0
      ]

      assert [
               [100, 80, 60, 40, 20, 10, 3],
               [100, 80, 60, 40, 20, 10, 3],
               [91, 73, 55, 37, 18, 9, 3],
               [78, 63, 47, 31, 16, 8, 2],
               [66, 52, 39, 26, 13, 7, 2],
               [53, 42, 32, 21, 11, 5, 2],
               [40, 32, 24, 16, 8, 4, 1],
               [27, 21, 16, 11, 5, 3, 1],
               [14, 11, 8, 6, 3, 1, 0],
               [1, 1, 1, 0, 0, 0, 0],
               [1, 1, 1, 0, 0, 0, 0]
             ] =
               Enum.map(durations, fn d ->
                 Enum.map(
                   @test_results,
                   fn tests -> get_score(level, tests, d) end
                 )
               end)
    end

    test "medium level" do
      level = "medium"

      durations = [
        1.0,
        40.0,
        60.0,
        2 * 60.0,
        3 * 60.0,
        4 * 60.0,
        5 * 60.0,
        6 * 60.0,
        7 * 60.0,
        8 * 60.0,
        10 * 60.0,
        11 * 60.0,
        12 * 60.0,
        13 * 60.0,
        14 * 60.0
      ]

      assert [
               [300, 240, 180, 120, 60, 30, 9],
               [300, 240, 180, 120, 60, 30, 9],
               [292, 234, 175, 117, 58, 29, 9],
               [268, 214, 161, 107, 54, 27, 8],
               [244, 195, 146, 98, 49, 24, 7],
               [220, 176, 132, 88, 44, 22, 7],
               [196, 157, 117, 78, 39, 20, 6],
               [172, 137, 103, 69, 34, 17, 5],
               [147, 118, 88, 59, 29, 15, 4],
               [123, 99, 74, 49, 25, 12, 4],
               [75, 60, 45, 30, 15, 8, 2],
               [51, 41, 31, 20, 10, 5, 2],
               [27, 22, 16, 11, 5, 3, 1],
               [3, 2, 2, 1, 1, 0, 0],
               [3, 2, 2, 1, 1, 0, 0]
             ] =
               Enum.map(durations, fn d ->
                 Enum.map(
                   @test_results,
                   fn tests -> get_score(level, tests, d) end
                 )
               end)
    end

    test "hard level" do
      level = "hard"

      durations = [
        1.0,
        60.0,
        2 * 60.0,
        3 * 60.0,
        4 * 60.0,
        5 * 60.0,
        6 * 60.0,
        7 * 60.0,
        8 * 60.0,
        10 * 60.0,
        11 * 60.0,
        12 * 60.0,
        13 * 60.0,
        14 * 60.0,
        15 * 60.0,
        16 * 60.0,
        17 * 60.0,
        18 * 60.0,
        19 * 60.0,
        20 * 60.0,
        21 * 60.0,
        22 * 60.0
      ]

      assert [
               [1000, 800, 600, 400, 200, 100, 30],
               [1000, 800, 600, 400, 200, 100, 30],
               [951, 760, 570, 380, 190, 95, 29],
               [901, 721, 541, 360, 180, 90, 27],
               [852, 681, 511, 341, 170, 85, 26],
               [802, 642, 481, 321, 160, 80, 24],
               [753, 602, 452, 301, 151, 75, 23],
               [703, 562, 422, 281, 141, 70, 21],
               [654, 523, 392, 261, 131, 65, 20],
               [555, 444, 333, 222, 111, 55, 17],
               [505, 404, 303, 202, 101, 51, 15],
               [456, 364, 273, 182, 91, 46, 14],
               [406, 325, 244, 162, 81, 41, 12],
               [357, 285, 214, 143, 71, 36, 11],
               [307, 246, 184, 123, 61, 31, 9],
               [258, 206, 155, 103, 52, 26, 8],
               [208, 166, 125, 83, 42, 21, 6],
               [159, 127, 95, 63, 32, 16, 5],
               [109, 87, 65, 44, 22, 11, 3],
               [60, 48, 36, 24, 12, 6, 2],
               [10, 8, 6, 4, 2, 1, 0],
               [10, 8, 6, 4, 2, 1, 0]
             ] =
               Enum.map(durations, fn d ->
                 Enum.map(
                   @test_results,
                   fn tests -> get_score(level, tests, d) end
                 )
               end)
    end
  end
end
