import { createSlice } from '@reduxjs/toolkit';

import initial from './initial';

const initialState = initial.tournamentRounds;

const tournament = createSlice({
  name: 'tournamentRounds',
  initialState,
  reducers: {
    setActiveGameId: (state, { payload }) => {
      state.gameId = payload.activeGameId;
    },
    clearActiveGameId: state => {
      state.gameId = null;
    },
    updateTournamentPlayerChannelState: (state, { payload }) => {
      state.channel.online = payload;
    },
  },
});

const { actions, reducer } = tournament;

export { actions };
export default reducer;
