//
// Copyright (C) 2017-2021 HERE Europe B.V.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

import Foundation

extension Locale {

    /// Returns a boolean indicating if the locale should use km/h for speed.
    /// The default value is true, in case the Locale doesn't have a measurement system specified.
    var usesKilometersPerHour: Bool {
        (self as NSLocale).object(forKey: .measurementSystem) as? String == "Metric"
    }
}
