/*
 * Copyright (C) 2017-2021 HERE Europe B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.here.msdkuiapp.espresso.impl.views.route.useractions

import androidx.test.espresso.action.ViewActions.click
import com.here.msdkuiapp.espresso.impl.views.route.screens.RouteBarView.onRouteBarBackImageIcon

/**
 * Route overview specific actionbar related actions
 */
object RouteBarActions {

    /**
     * Tap on back arrow image button to exit from route overview
     */
    fun tapOnBackArrowButton(): RouteBarActions {
        onRouteBarBackImageIcon.perform(click())
        return this
    }
}