/**
 * File RequestEvent.php
 * @henter
 * Time: 2018-11-25 23:15
 *
 */

namespace Zim\Event;

use Zim\Contract\Request;
use Zim\Contract\Response;

class TerminateEvent
{
    /**
     * @var Request
     */
    protected request;

    /**
     * @var Response
     */
    protected response;

    public function __construct(<Request> request, <Response> response = null)
    {
        let this->request = request;
        let this->response = response;
    }

    /**
     * @return Response
     */
    public function getResponse() -> <Response>
    {
        return this->response;
    }

    /**
     * @return Request
     */
    public function getRequest() -> <Request>
    {
        return this->request;
    }

}
