/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2015 - 2017 Henrique B. Behr
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
using hbehr.recaptcha.Internazionalization;

namespace hbehr.recaptcha
{
    public enum ReCaptchaLanguage
    {
        Auto,
        [Language("ar")] Arabic,
        [Language("af")] Afrikaans,
        [Language("am")] Amharic,
        [Language("hy")] Armenian,
        [Language("az")] Azerbaijani,
        [Language("eu")] Basque,
        [Language("bn")] Bengali,
        [Language("bg")] Bulgarian,
        [Language("ca")] Catalan,
        [Language("zh-HK")] ChineseHongKong,
        [Language("zh-CN")] ChineseSimplified,
        [Language("zh-TW")] ChineseTraditional,
        [Language("hr")] Croatian,
        [Language("cs")] Czech,
        [Language("da")] Danish,
        [Language("nl")] Dutch,
        [Language("en-GB")] EnglishUk,
        [Language("en")] EnglishUs,
        [Language("et")] Estonian,
        [Language("fil")] Filipino,
        [Language("fi")] Finnish,
        [Language("fr")] French,
        [Language("fr-CA")] FrenchCanadian,
        [Language("gl")] Galician,
        [Language("ka")] Georgian,
        [Language("de")] German,
        [Language("gu")] Gujarati,
        [Language("de-AT")] GermanAustria,
        [Language("de-CH")] GermanSwitzerland,
        [Language("el")] Greek,
        [Language("iw")] Hebrew,
        [Language("hi")] Hindi,
        [Language("hu")] Hungarain,
        [Language("is")] Icelandic,
        [Language("id")] Indonesian,
        [Language("it")] Italian,
        [Language("ja")] Japanese,
        [Language("kn")] Kannada,
        [Language("ko")] Korean,
        [Language("lo")] Laothian,
        [Language("lv")] Latvian,
        [Language("lt")] Lithuanian,
        [Language("ms")] Malay,
        [Language("ml")] Malayalam,
        [Language("mr")] Marathi,
        [Language("mn")] Mongolian,
        [Language("no")] Norwegian,
        [Language("fa")] Persian,
        [Language("pl")] Polish,
        [Language("pt")] Portuguese,
        [Language("pt-BR")] PortugueseBrazil,
        [Language("pt-PT")] PortuguesePortugal,
        [Language("ro")] Romanian,
        [Language("ru")] Russian,
        [Language("sr")] Serbian,
        [Language("si")] Sinhalese,
        [Language("sk")] Slovak,
        [Language("sl")] Slovenian,
        [Language("es")] Spanish,
        [Language("es-419")] SpanishLatinAmerica,
        [Language("sw")] Swahili,
        [Language("sv")] Swedish,
        [Language("ta")] Tamil,
        [Language("te")] Telugu,
        [Language("th")] Thai,
        [Language("tr")] Turkish,
        [Language("uk")] Ukrainian,
        [Language("ur")] Urdu,
        [Language("vi")] Vietnamese,
        [Language("zu")] Zulu
    }
}