import classNamesUtil from 'classnames'
import { last } from './arrays'

// TODO: remove, use classNames lib in all apps
/**
 * Tiny implementation of the classnames library.
 *
 * @param   {any} classes
 * @returns {string}
 */
export const classNames = classNamesUtil

/**
 * Used with classNames generated by a styled-component.
 * Styled component appends the hashed className at the very end.
 * This function plucks it out and returns it.
 *
 * @param   {string} classNames
 * @returns {string}
 */
export const getHashedClassName = classNames => {
  return last(classNames.split(' '))
}

/**
 * Convenience class for generating BEM style classNames, based on a block.
 */
class BEMClass {
  block = ''

  constructor(block) {
    this.block = block
  }

  /**
   * Generates a BEM element className
   *
   * @param   {string} element
   * @returns {string}
   */
  element(element) {
    return `${this.block}__${element}`
  }

  /**
   * Alias for BEM.element
   *
   * @param   {string} element
   * @returns {string}
   */
  e(element) {
    return this.element(element)
  }

  /**
   * Generates a BEM modifer className
   *
   * @param   {string} element
   * @returns {string}
   */
  modifier(modifier) {
    return `${this.block}--${modifier}`
  }

  /**
   * Alias for BEM.modifer
   *
   * @param   {string} element
   * @returns {string}
   */
  m(modifier) {
    return this.modifier(modifier)
  }
}

/**
 * Used with classNames generated by a styled-component, combined
 * with a BEM styled __element suffix.
 *
 * @param   {string} classNames
 * @param   {string} suffix
 * @returns {string}
 */
export const BEM = classNames => {
  return new BEMClass(getHashedClassName(classNames))
}

export default classNames
