import React from 'react'
import PropTypes from 'prop-types'
import getValidProps from '@helpscout/react-utils/dist/getValidProps'
import Text from '../Text'
import classNames from 'classnames'

const MessageCaption = (props, context) => {
  const { className, children, size, wordWrap, ...rest } = props
  const { theme } = context
  const isThemeEmbed = theme === 'embed'

  const componentClassName = classNames(
    'c-MessageCaption',
    theme && `is-theme-${theme}`,
    className
  )

  const textSize = size ? size : isThemeEmbed ? '11' : '13'

  return (
    <div {...getValidProps(rest)} className={componentClassName}>
      <Text
        className="c-MessageCaption__text"
        size={textSize}
        shade="faint"
        wordWrap={wordWrap}
      >
        {children}
      </Text>
    </div>
  )
}

function noop() {}

MessageCaption.contextTypes = {
  theme: noop,
}

MessageCaption.defaultProps = {
  'data-cy': 'MessageCaption',
  wordWrap: true,
}

MessageCaption.propTypes = {
  /** Custom class names to be added to the component. */
  className: PropTypes.string,
  /** Data attr for Cypress tests. */
  'data-cy': PropTypes.string,
  /** Adjusts the font size of the component, see `Text` for options. */
  size: PropTypes.string,
  /** Breaks longer text content. */
  wordWrap: PropTypes.bool,
}

export default MessageCaption
