# Problem/Feature

Write to your heart's content, include:

- [ ] A link to the Figma design in your story (list regularly updated [here](https://docs.google.com/spreadsheets/d/19-5gNbYuKjOb-kk7VTQZ0i_VWVd_8lubx-uhrlPUu1E/edit#gid=0))
- [ ] A link to the Story(ies) in the description
- [ ] Is there a Jira ticket associated?
- [ ] If useful, add screenshots or videos
- [ ] If useful (and unclear), add a little explanation of why a certain path was taken
- [ ] Instructions on how to test
- [ ] Found any restrictions/limitations? Let us know!

## Guidelines

Make sure the pull request:

- [ ] Follows the established folder/file structure
- [ ] Adds unit tests
- [ ] If it is a refactor or change to an existing component, have you verified it won't break existing Cypress tests or have you updated them?
- [ ] Did you verify some accessibility (a11y) basics?
- [ ] Adds/updates stories. [Guidelines](https://hsds.helpscout.com/?path=/docs/%F0%9F%8F%A0-welcome-4-writing-stories--page)
- [ ] Adds/updates documentation (ie `proptypes`) [Guidelines](https://hsds.helpscout.com/?path=/docs/%F0%9F%8F%A0-welcome-3-writing-components--page)
- [ ] Has it been tested in [Help Scout's supported browsers](https://docs.helpscout.com/article/1292-supported-browsers-and-system-requirements)?
- [ ] Requests review from designer of the feature
- [ ] Add label (bug? feature?)
