import React, { useState } from 'react';
import Title from './utils/title';
import { RevealWrapper } from 'next-reveal';
import CarroselCertificados from './utils/certificados';

export default function Qualification() {

    const [open, setOpen] = useState("Graduação");

    return (
      <RevealWrapper>
        <section className="my-20 pt-10 pb-16 px-0 mb-12 text-center">
        <div className="qualification_container container"> 
          <Title subtitle={"training"} title="formação" icon={"mortarboard"} />
       
  
          <div className="tab-wrap translate-x-12 ">
            <div className="tab">
            <button className={`tab_button ${open =="Graduação" ? "active" : "" }`} onClick={() => setOpen("Graduação")} >Graduação</button>
              <button className={`tab_button ${open =="Experiência" ? "active" : "" }`} onClick={() => setOpen("Experiência")} >Experiência</button>
              <button className={`tab_button ${open =="certificados" ? "active" : "" }`} onClick={() => setOpen("certificados")} >certificados</button>
            </div>
            {(() => {
              switch (open) {
                case "Graduação":
                  return (<>
                    <div id="Formacao" className="mx-2 h-64">
                    <div className="text-left">
                      <h3 className="qualification_name">Engenharia da Computação</h3>
                      <p className="qualification_description">Universidade Federal Rural de Pernambuco</p>
                  
                          <div className="status">
                            <span className="qualification_number"><span className="pont-green">80%</span></span>
                            </div>
                  
                          <div className="qualification_calendar">
                            <i className="uil uil-calendar-alt"></i>
                            2020 - 2025
                          </div>
                        </div>
                  
                        <div className="qualification_bar">
                          <div className="qualification_percentage qualification_ufrpe">
                          </div>
                        </div>
                      <div className="text-left ">
                          <h3 className="qualification_name">Analise de Desenvolvimento de Sistemas</h3>
                          <p className="qualification_description">Escola Técnica Estadual - Edson Mororó Moura</p>
                  
                              <div className="status">
                                <span className="qualification_number"><span className="pont-green">100%</span></span>
                                </div>
                  
                              <div className="qualification_calendar">
                                <i className="uil uil-calendar-alt"></i>
                                2017 - 2019
                              </div>
                            </div>
                  
                            <div className="qualification_bar">
                              <div className="qualification_percentage qualification_ete">
                              </div>
                            </div> 
                  </div>
                  
                  </>)
                case "Experiência":
                  return (<>
                    <div id="Experiência" className="mx-2 h-64" >            
                      <div className="text-left">
                     <h3 className="text-xl mb-1">Oportunidade</h3>
                        <p className="mb-1">Buscando uma oportunidade no mercado de trabalho.</p>
                        <p className="">Entre em contato:  <a className="qualification_exp-a" href="mailto:eliasvitor.dev@gmail.com">
                          <span className="exp-text">Email:</span> eliasvitor.dev@gmail.com</a>
                        <a className="qualification_exp-a" href="https://api.whatsapp.com/send?phone=+5581991426794&text=Olá elias!" target="_blank"><span className="exp-text">Whatsapp:</span> (81) 99142 - 6794</a> </p>
                      </div>
                      </div>
                  </>);
                case "certificados":
                  return ( <CarroselCertificados /> );
                default:
                  return null;      
              }

            })()}
            
    
  
          </div>
          </div>
    </section>
    </RevealWrapper>
    )
}
