﻿/* Reference: http://yuyin.baidu.com/docs/tts/136
 * 参数  可需       描述
 * tex   必填     合成的文本，使用UTF-8编码，请注意文本长度必须小于1024字节
 * lan   必填     语言选择, 填写zh
 * tok   必填     开放平台获取到的开发者 access_token
 * ctp   必填     客户端类型选择，web端填写1
 * cuid  必填     用户唯一标识，用来区分用户，填写机器 MAC 地址或 IMEI 码，长度为60以内
 * spd   选填     语速，取值0-9，默认为5中语速
 * pit   选填     音调，取值0-9，默认为5中语调
 * vol   选填     音量，取值0-9，默认为5中音量
 * per   选填     发音人选择, 0为女声，1为男声，3为情感合成-度逍遥，4为情感合成-度丫丫，默认为普通女声
 */
namespace SpeechProcessing.Model
{
    class SpeechModel
    {
        public string APIID { get; set; }
        public string APIKey { get; set; }
        public string APISecretKey { get; set; }
        public string APILanguage { get; set; }
        public string APIRecord { get; set; }
        public string APIFormat { get; set; }
        public string APIFrequency { get; set; }
        public string APIAccessToken { get; set; }

        public string APIClientType { get; set; }
        public string APISpeed { get; set; }
        public string APIPitch { get; set; }
        public string APIVolume { get; set; }
        public string APIPerson { get; set; }

        public SpeechModel()
        {
            APIID = "402"; // can be anything here, just be unique anyway
            APIKey = "Your key"; // Your key
            APISecretKey = "Your secret key"; // Your secret key
            APILanguage = "en"; // language
            APIRecord = ""; // recorded audio
            APIFormat = "wav"; // audio format
            APIFrequency = "16000"; // Hz
            APIAccessToken = null; // token, generated by key and secret key

            APIClientType = "1";
            APISpeed = "4";
            APIPitch = "5";
            APIVolume = "9";
            APIPerson = "1";
        }
    }
}
