# coding: utf-8

"""
    Ticketmaster Discovery API

    Swagger spec based on Ticketmaster Discovery API

    OpenAPI spec version: 1.0.0
    Contact: git@edward.sh
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class EventsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def event_details(self, id, **kwargs):
        """
        Get event details by ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.event_details(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: Event ID (required)
        :param str locale:
        :param str include_licensed_content:
        :return: Event
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.event_details_with_http_info(id, **kwargs)
        else:
            (data) = self.event_details_with_http_info(id, **kwargs)
            return data

    def event_details_with_http_info(self, id, **kwargs):
        """
        Get event details by ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.event_details_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: Event ID (required)
        :param str locale:
        :param str include_licensed_content:
        :return: Event
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'locale', 'include_licensed_content']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method event_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `event_details`")


        collection_formats = {}

        resource_path = '/events/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'locale' in params:
            query_params['locale'] = params['locale']
        if 'include_licensed_content' in params:
            query_params['includeLicensedContent'] = params['include_licensed_content']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['APIKeyQueryParam']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Event',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def event_images(self, id, **kwargs):
        """
        Get event images
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.event_images(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: Event ID (required)
        :param str locale:
        :param str include_licensed_content:
        :return: EventImages
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.event_images_with_http_info(id, **kwargs)
        else:
            (data) = self.event_images_with_http_info(id, **kwargs)
            return data

    def event_images_with_http_info(self, id, **kwargs):
        """
        Get event images
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.event_images_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: Event ID (required)
        :param str locale:
        :param str include_licensed_content:
        :return: EventImages
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'locale', 'include_licensed_content']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method event_images" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `event_images`")


        collection_formats = {}

        resource_path = '/events/{id}/images'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'locale' in params:
            query_params['locale'] = params['locale']
        if 'include_licensed_content' in params:
            query_params['includeLicensedContent'] = params['include_licensed_content']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['APIKeyQueryParam']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EventImages',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def search_events(self, **kwargs):
        """
        Event search
        Event search
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_events(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: Event ID
        :param str keyword: Search by keyword
        :param str attraction_id:
        :param str venue_id:
        :param str postal_code:
        :param str latlong:
        :param str radius:
        :param str unit:
        :param str source:
        :param str locale:
        :param str market_id:
        :param str start_date_time:
        :param str end_date_time:
        :param str include_tba:
        :param str include_tbd:
        :param str include_test:
        :param str size:
        :param str page:
        :param str sort:
        :param str onsale_start_date_time:
        :param str onsale_end_date_time:
        :param str city:
        :param str country_code:
        :param str state_code:
        :param str classification_name:
        :param str classification_id:
        :param str dma_id:
        :param str onsale_on_start_date:
        :param str onsale_on_after_start_date:
        :param str segment_id:
        :param str segment_name:
        :param str promoter_id:
        :param str client_visibility:
        :param str nlp:
        :param str include_licensed_content:
        :return: Container
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.search_events_with_http_info(**kwargs)
        else:
            (data) = self.search_events_with_http_info(**kwargs)
            return data

    def search_events_with_http_info(self, **kwargs):
        """
        Event search
        Event search
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_events_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: Event ID
        :param str keyword: Search by keyword
        :param str attraction_id:
        :param str venue_id:
        :param str postal_code:
        :param str latlong:
        :param str radius:
        :param str unit:
        :param str source:
        :param str locale:
        :param str market_id:
        :param str start_date_time:
        :param str end_date_time:
        :param str include_tba:
        :param str include_tbd:
        :param str include_test:
        :param str size:
        :param str page:
        :param str sort:
        :param str onsale_start_date_time:
        :param str onsale_end_date_time:
        :param str city:
        :param str country_code:
        :param str state_code:
        :param str classification_name:
        :param str classification_id:
        :param str dma_id:
        :param str onsale_on_start_date:
        :param str onsale_on_after_start_date:
        :param str segment_id:
        :param str segment_name:
        :param str promoter_id:
        :param str client_visibility:
        :param str nlp:
        :param str include_licensed_content:
        :return: Container
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'keyword', 'attraction_id', 'venue_id', 'postal_code', 'latlong', 'radius', 'unit', 'source', 'locale', 'market_id', 'start_date_time', 'end_date_time', 'include_tba', 'include_tbd', 'include_test', 'size', 'page', 'sort', 'onsale_start_date_time', 'onsale_end_date_time', 'city', 'country_code', 'state_code', 'classification_name', 'classification_id', 'dma_id', 'onsale_on_start_date', 'onsale_on_after_start_date', 'segment_id', 'segment_name', 'promoter_id', 'client_visibility', 'nlp', 'include_licensed_content']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_events" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/events'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']
        if 'keyword' in params:
            query_params['keyword'] = params['keyword']
        if 'attraction_id' in params:
            query_params['attractionId'] = params['attraction_id']
        if 'venue_id' in params:
            query_params['venueId'] = params['venue_id']
        if 'postal_code' in params:
            query_params['postalCode'] = params['postal_code']
        if 'latlong' in params:
            query_params['latlong'] = params['latlong']
        if 'radius' in params:
            query_params['radius'] = params['radius']
        if 'unit' in params:
            query_params['unit'] = params['unit']
        if 'source' in params:
            query_params['source'] = params['source']
        if 'locale' in params:
            query_params['locale'] = params['locale']
        if 'market_id' in params:
            query_params['marketId'] = params['market_id']
        if 'start_date_time' in params:
            query_params['startDateTime'] = params['start_date_time']
        if 'end_date_time' in params:
            query_params['endDateTime'] = params['end_date_time']
        if 'include_tba' in params:
            query_params['includeTBA'] = params['include_tba']
        if 'include_tbd' in params:
            query_params['includeTBD'] = params['include_tbd']
        if 'include_test' in params:
            query_params['includeTest'] = params['include_test']
        if 'size' in params:
            query_params['size'] = params['size']
        if 'page' in params:
            query_params['page'] = params['page']
        if 'sort' in params:
            query_params['sort'] = params['sort']
        if 'onsale_start_date_time' in params:
            query_params['onsaleStartDateTime'] = params['onsale_start_date_time']
        if 'onsale_end_date_time' in params:
            query_params['onsaleEndDateTime'] = params['onsale_end_date_time']
        if 'city' in params:
            query_params['city'] = params['city']
        if 'country_code' in params:
            query_params['countryCode'] = params['country_code']
        if 'state_code' in params:
            query_params['stateCode'] = params['state_code']
        if 'classification_name' in params:
            query_params['classificationName'] = params['classification_name']
        if 'classification_id' in params:
            query_params['classificationId'] = params['classification_id']
        if 'dma_id' in params:
            query_params['dmaId'] = params['dma_id']
        if 'onsale_on_start_date' in params:
            query_params['onsaleOnStartDate'] = params['onsale_on_start_date']
        if 'onsale_on_after_start_date' in params:
            query_params['onsaleOnAfterStartDate'] = params['onsale_on_after_start_date']
        if 'segment_id' in params:
            query_params['segmentId'] = params['segment_id']
        if 'segment_name' in params:
            query_params['segmentName'] = params['segment_name']
        if 'promoter_id' in params:
            query_params['promoterId'] = params['promoter_id']
        if 'client_visibility' in params:
            query_params['clientVisibility'] = params['client_visibility']
        if 'nlp' in params:
            query_params['nlp'] = params['nlp']
        if 'include_licensed_content' in params:
            query_params['includeLicensedContent'] = params['include_licensed_content']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['APIKeyQueryParam']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Container',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
