# coding: utf-8

"""
    Ticketmaster Discovery API

    Swagger spec based on Ticketmaster Discovery API

    OpenAPI spec version: 1.0.0
    Contact: git@edward.sh
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class AttractionsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def attraction_details(self, id, **kwargs):
        """
        Get attraction details by ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.attraction_details(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: Attraction ID (required)
        :param str locale:
        :param str include_licensed_content:
        :return: Attraction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.attraction_details_with_http_info(id, **kwargs)
        else:
            (data) = self.attraction_details_with_http_info(id, **kwargs)
            return data

    def attraction_details_with_http_info(self, id, **kwargs):
        """
        Get attraction details by ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.attraction_details_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: Attraction ID (required)
        :param str locale:
        :param str include_licensed_content:
        :return: Attraction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'locale', 'include_licensed_content']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method attraction_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `attraction_details`")


        collection_formats = {}

        resource_path = '/attractions/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'locale' in params:
            query_params['locale'] = params['locale']
        if 'include_licensed_content' in params:
            query_params['includeLicensedContent'] = params['include_licensed_content']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['APIKeyQueryParam']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Attraction',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def search_attractions(self, **kwargs):
        """
        Search attractions
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_attractions(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id:
        :param str keyword:
        :param str source:
        :param str locale:
        :param str include_test:
        :param str size:
        :param str page:
        :param str include_licensed_content:
        :param str sort:
        :param str classification_name:
        :param str classification_id:
        :return: Container
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.search_attractions_with_http_info(**kwargs)
        else:
            (data) = self.search_attractions_with_http_info(**kwargs)
            return data

    def search_attractions_with_http_info(self, **kwargs):
        """
        Search attractions
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_attractions_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id:
        :param str keyword:
        :param str source:
        :param str locale:
        :param str include_test:
        :param str size:
        :param str page:
        :param str include_licensed_content:
        :param str sort:
        :param str classification_name:
        :param str classification_id:
        :return: Container
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'keyword', 'source', 'locale', 'include_test', 'size', 'page', 'include_licensed_content', 'sort', 'classification_name', 'classification_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_attractions" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/attractions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']
        if 'keyword' in params:
            query_params['keyword'] = params['keyword']
        if 'source' in params:
            query_params['source'] = params['source']
        if 'locale' in params:
            query_params['locale'] = params['locale']
        if 'include_test' in params:
            query_params['includeTest'] = params['include_test']
        if 'size' in params:
            query_params['size'] = params['size']
        if 'page' in params:
            query_params['page'] = params['page']
        if 'include_licensed_content' in params:
            query_params['includeLicensedContent'] = params['include_licensed_content']
        if 'sort' in params:
            query_params['sort'] = params['sort']
        if 'classification_name' in params:
            query_params['classificationName'] = params['classification_name']
        if 'classification_id' in params:
            query_params['classificationId'] = params['classification_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['APIKeyQueryParam']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Container',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
