---
marp: true
title: 19 March 2021
theme: default
paginate: true
---
# <!-- fit --> CS 199 EMP

### Hosted by Jackie Chan and Akhila Ashokan

**Topics:** More on JSON Serialization, Interfaces, and Abstract Classes/Methods

---

# Today's Learning Objectives

- More on JSON Serialization

- Interfaces

- Abstract Classes/Methods

Write code on the homepage or any playground on the site!
https://cs125.cs.illinois.edu/

Slides are on the course site!
https://cs199emp.netlify.app/

---

# Serialization

The moving parts include:

- `Jackson` - The package used for (de)serialization.

- `ObjectMapper()` - The object provided by `Jackson` to serialize using `.writeValueAsString(object)` and `.readValue(json, object.class)`

**Note:** For this to work, you need *public getters* for the attributes you want to serialize and *a default construct*, i.e. a constructor that doesn't take any parameters, to deserialize.

---

# Serialization Practice (15 minutes)

You just got hired at an aquarium! Your task it to define a class for the `Fish` that will be serialized into a database.

The `Fish` object will store it's `String species`, `String diet`, `int size`, `boolean saltwater`. Please define the class so that it can be serialize and deserialized.

Also code a `toString()` function.

---

# Aquarium Starter Code

```java
import com.fasterxml.jackson.databind.ObjectMapper;

public class Fish {
  // Your code here.
}

ObjectMapper map = new ObjectMapper();

Fish nemo = new Fish("Clownfish", "Fecal Matter", 6, true);
Fish dory = new Fish("Regal Blue Tang", "Plankton", 12, true);

String json = map.writeValueAsString(new Fish(){nemo, dory});

Fish[] aquariumFish = map.readValue(json, Fish[].class);

for (int i = 0; i < aquariumFish.length; i++) {
  System.out.println(aquariumFish[i]);
}
```

---

# "Interfaces and Abstract, What's the Differences?"

Good question me!

In short, interfaces and abstract classes/methods allow you to specify certain functionalities that should exist, but *provide no details on how to implement them*, e.g. `Shape` class and `.getSides()`. It depends on the shape, but all shapes should have that ability.

```java
public abstract class Shape { // Objects can *extend* abstract classes.
  public abstract int getSides();
}

interface Shape { // Objects can *implement* interfaces.
  public int getSides();
}
```

---

# "There are differences though."

Both can have functions without bodies, not be declared alone, i.e. cannot declare an abstract class or interface.

`interface` can be *implemented* with multiple other interfaces, be *implemented* by classes, define static and final variables, only define *public* methods.

`abstact` classes can be *extended* by classes, have instance variables, have non-abstract methods with bodies, define both public and private methods.

---

# Practice with Interfaces (15 minutes)

Implement these interfaces to the `Mansion` class.

`Pool` interface: `swim()` should print `"Splash!"`, `suntan()` should print `"Getting sun-kissed skin!"`.

`Butler` interface: `callButler()` should print `"What may I help you with?"`.

`Vineyard` interface: `getGrapeType()` should return the grape types in the vineyard.

---

# Mansion Starter Code

```java
interface Pool {
  void swim();
  void suntan();
}

interface Butler {
  void callButler();
}

interface Vineyard {
  String getGrapeType();
}

class Mansion {
  // Your code here.
}
```

Remember that interfaces are by default public, but implementing them in a class requires you to explicitly state that they're `public`.



---

# Abstract Classes and Methods Practice (10 minutes)

Make your own social media platform by extending the `Social Media` abstract class.

Here we have a `vaguePost()` method that returns a `String` for a vague post, [definition](https://www.urbandictionary.com/define.php?term=Vague%20Post). Another is `postHumbleBrag()` which will take a humble brag, [definition](https://www.urbandictionary.com/define.php?term=Humble%20Brag), post and print it.

The last one, `welcomeMessage()`, you don't have to implement, just set a `platform` name to what your social media platform will be called.

---

# Social Media Starter Code

```java
public abstract class SocialMedia {
  
  public int followers;
  public int following;
  public String platform;
  
  public abstract String vaguePost();
  public abstract void postHumbleBrag(String post);
  public String welcomeMessage() {
    return "Welcome to " + this.platform + "!";
  }
}
```

---

# That's All Folks!

We covered a lot. Hopefully you understand the difference more between interfaces and abstract classes and methods. Feel free to ask about that here.

Have a good weekend. Enjoy the good weather, if you have it, and be sure to stay safe and have fun.

---

# Solution Section

---

# Aquarium Solution

```java
public class Fish {
  private String species;
  private String diet;
  private int size;
  private boolean saltwater;
  
  public Fish() { }
  
  public Fish(String setSpecies, String setDiet, int setSize,
      boolean setSaltwater) {
    this.species = setSpecies;
    this.diet = setDiet;
    this.size = setSize;
    this.saltwater = setSaltwater;
  }
  
  public String getSpecies() {
    return this.species;
  }
  
  public String getDiet() {
    return this.diet;
  }
  
  public int getSize() {
    return this.size;
  }
  
  public boolean getSaltwater() {
    return this.saltwater;
  }
  
  @Override
  public String toString() {
    String output = this.species + " eats " + this.diet;
    output += ", lives in ";
    
    if (this.saltwater) {
      output += "saltwater";
    } else {
      output += "freshwater";
    }
    
    output += ", and is " + this.size + " inches.";
    
    return output;
  }
}
```

---

# Mansion Solution

```java
class Mansion implements Pool, Butler, Vineyard {
  public void swim() {
    System.out.println("Splash!");
  }
  
  public void suntan() {
    System.out.println("Getting sun-kissed skin!");
  }
  
  public void callButler() {
    System.out.println("What may I help you with?");
  }
  
  public String getGrapeType() {
    return "Sauignon Blanc";
  }
}
```

---

# Social Media Solution

```java
public class TuringComplete extends SocialMedia { // Dating Platform
  
  public String platform = "Turing Complete";
  
  @Override
  public String vaguePost() {
    return "Imagine rejecting my merge requests when your code is bad.";
  }
  
  @Override
  public void postHumbleBrag(String post) {
    System.out.println(post);
  }
}
```